/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class OrphanedDOMNode
extends BytecodeScanningDetector {
    private static final Set<String> domCreationMethods = new HashSet<String>();
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<OpcodeStack.Item, Integer> nodeCreations;
    private Map<Integer, Integer> nodeStores;

    public OrphanedDOMNode(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.nodeCreations = new HashMap<OpcodeStack.Item, Integer>();
            this.nodeStores = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.nodeCreations = null;
            this.nodeStores = null;
        }
    }

    public void visitCode(Code obj) {
        Integer pc;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.nodeCreations.clear();
        this.nodeStores.clear();
        super.visitCode(obj);
        HashSet<Integer> reportedPCs = new HashSet<Integer>();
        Iterator<Integer> i$ = this.nodeCreations.values().iterator();
        while (i$.hasNext()) {
            pc = i$.next();
            if (reportedPCs.contains(pc)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "ODN_ORPHANED_DOM_NODE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
            reportedPCs.add(pc);
        }
        i$ = this.nodeStores.values().iterator();
        while (i$.hasNext()) {
            pc = i$.next();
            if (reportedPCs.contains(pc)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "ODN_ORPHANED_DOM_NODE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
            reportedPCs.add(pc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Integer itemPC;
        boolean sawCreate;
        block18: {
            sawCreate = false;
            itemPC = null;
            try {
                this.stack.mergeJumps((DismantleBytecode)this);
                if (seen == 185) {
                    String className = this.getClassConstantOperand();
                    String methodInfo = this.getNameConstantOperand() + ":" + this.getSigConstantOperand();
                    if ("org/w3c/dom/Document".equals(className) && domCreationMethods.contains(methodInfo)) {
                        sawCreate = true;
                        itemPC = Integer14.valueOf(this.getPC());
                    }
                } else if (seen == 58 || seen >= 75 && seen <= 78) {
                    Integer pc = this.findDOMNodeCreationPoint(0);
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (pc != null) {
                        this.nodeStores.put(Integer14.valueOf(reg), pc);
                    } else {
                        this.nodeStores.remove(Integer14.valueOf(reg));
                    }
                } else if (seen == 181) {
                    this.findDOMNodeCreationPoint(0);
                } else if (seen == 25 || seen >= 42 && seen <= 45) {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    itemPC = this.nodeStores.get(Integer14.valueOf(reg));
                    if (itemPC != null) {
                        sawCreate = true;
                    }
                } else if (seen == 176 && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    int reg = itm.getRegisterNumber();
                    this.nodeCreations.remove(itm);
                    this.nodeStores.remove(Integer14.valueOf(reg));
                }
                if (sawCreate || seen != 185 && seen != 182 && seen != 184 && seen != 183) break block18;
                String methodSig = this.getSigConstantOperand();
                int argCount = Type.getArgumentTypes((String)methodSig).length;
                if (this.stack.getStackDepth() < argCount) break block18;
                for (int a = 0; a < argCount; ++a) {
                    OpcodeStack.Item itm = this.stack.getStackItem(a);
                    if (!this.nodeCreations.containsKey(itm)) continue;
                    int reg = itm.getRegisterNumber();
                    this.nodeCreations.remove(itm);
                    this.nodeStores.remove(Integer14.valueOf(reg));
                }
                if (seen == 184 || this.stack.getStackDepth() <= argCount) break block18;
                this.nodeCreations.remove(this.stack.getStackItem(argCount));
            }
            catch (Throwable throwable) {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (sawCreate && this.stack.getStackDepth() > 0) {
                    this.nodeCreations.put(this.stack.getStackItem(0), itemPC);
                }
                throw throwable;
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (sawCreate && this.stack.getStackDepth() > 0) {
            this.nodeCreations.put(this.stack.getStackItem(0), itemPC);
        }
    }

    private Integer findDOMNodeCreationPoint(int index) {
        if (this.stack.getStackDepth() > index) {
            return this.nodeCreations.remove(this.stack.getStackItem(index));
        }
        return null;
    }

    static {
        domCreationMethods.add("createAttribute:(Ljava/lang/String;)Lorg/w3c/dom/Attr;");
        domCreationMethods.add("createAttributeNS:(Ljava/lang/String;Ljava/lang/String;)Lorg/w3c/dom/Attr;");
        domCreationMethods.add("createCDATASection:(Ljava/lang/String;)Lorg/w3c/dom/CDATASection;");
        domCreationMethods.add("createComment:(Ljava/lang/String;)Lorg/w3c/dom/Comment;");
        domCreationMethods.add("createElement:(Ljava/lang/String;)Lorg/w3c/dom/Element;");
        domCreationMethods.add("createElementNS:(Ljava/lang/String;Ljava/lang/String;)Lorg/w3c/dom/Element;");
        domCreationMethods.add("createProcessingInstruction:(Ljava/lang/String;Ljava/lang/String;)Lorg/w3c/dom/ProcessingInstruction;");
        domCreationMethods.add("createTextNode:(Ljava/lang/String;)Lorg/w3c/dom/Text;");
    }
}

