/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class NonOwnedSynchronization
extends BytecodeScanningDetector {
    private static final Integer OWNED = Integer14.valueOf(Integer.MAX_VALUE);
    private static final Integer LOW = Integer14.valueOf(3);
    private static final Integer NORMAL = Integer14.valueOf(2);
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, Integer> regPriorities;

    public NonOwnedSynchronization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.regPriorities = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.regPriorities = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(194);
    }

    public void visitCode(Code obj) {
        Method method = this.getMethod();
        if (this.prescreen(method)) {
            int[] parmRegs;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.regPriorities.clear();
            int[] arr$ = parmRegs = RegisterUtils.getParameterRegisters(method);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int reg = arr$[i$];
                this.regPriorities.put(Integer14.valueOf(reg), NORMAL);
            }
            if (!method.isStatic()) {
                this.regPriorities.put(Integer14.valueOf(0), LOW);
            }
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer tosIsPriority = null;
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            switch (seen) {
                case 180: {
                    tosIsPriority = OWNED;
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    if (this.getMethod().isStatic() && reg == 0) {
                        tosIsPriority = LOW;
                        return;
                    }
                    tosIsPriority = this.regPriorities.get(Integer14.valueOf(reg));
                    if (tosIsPriority != null) return;
                    tosIsPriority = NORMAL;
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Integer priority = (Integer)item.getUserValue();
                    this.regPriorities.put(Integer14.valueOf(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen)), priority);
                    return;
                }
                case 182: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)sig);
                    if (!t.getSignature().startsWith("L")) return;
                    int parmCnt = Type.getArgumentTypes((String)sig).length;
                    if (this.stack.getStackDepth() < parmCnt) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(parmCnt);
                    Integer priority = (Integer)itm.getUserValue();
                    if (priority != null && OWNED.equals(priority)) {
                        tosIsPriority = OWNED;
                        return;
                    }
                    int reg = itm.getRegisterNumber();
                    if (reg > 0) {
                        tosIsPriority = this.regPriorities.get(Integer14.valueOf(reg));
                        return;
                    }
                    tosIsPriority = OWNED;
                    return;
                }
                case 184: {
                    String sig = this.getSigConstantOperand();
                    Type t = Type.getReturnType((String)sig);
                    if (!t.getSignature().startsWith("L")) return;
                    tosIsPriority = OWNED;
                    return;
                }
                case 183: {
                    String name = this.getNameConstantOperand();
                    if (!"<init>".equals(name)) return;
                    tosIsPriority = OWNED;
                    return;
                }
                case 194: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    Integer priority = (Integer)itm.getUserValue();
                    if (priority == null) return;
                    if (priority.equals(OWNED)) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NOS_NON_OWNED_SYNCHRONIZATION", priority.intValue()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (tosIsPriority != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)tosIsPriority);
            }
        }
    }
}

