/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;

public class NonCollectionMethodUse
extends BytecodeScanningDetector {
    private static Set<String> oldMethods = new HashSet<String>();
    private BugReporter bugReporter;

    public NonCollectionMethodUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        if (seen == 182) {
            String className = this.getClassConstantOperand();
            String methodName = this.getNameConstantOperand();
            String methodSig = this.getSigConstantOperand();
            String methodInfo = className + "." + methodName + methodSig;
            if (oldMethods.contains(methodInfo)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NCMU_NON_COLLECTION_METHOD_USE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
    }

    static {
        oldMethods.add("java/util/Hashtable.contains(java/lang/Object)Z");
        oldMethods.add("java/util/Hashtable.elements()Ljava/util/Enumeration;");
        oldMethods.add("java/util/Hashtable.keys()Ljava/util/Enumeration;");
        oldMethods.add("java/util/Vector.addElement(Ljava/lang/Object;)V");
        oldMethods.add("java/util/Vector.elementAt(I)Ljava/lang/Object;");
        oldMethods.add("java/util/Vector.insertElementAt(Ljava/lang/Object;I)V");
        oldMethods.add("java/util/Vector.removeAllElements()V");
        oldMethods.add("java/util/Vector.removeElement(Ljava/lang/Object;)Z");
        oldMethods.add("java/util/Vector.removeElementAt(I)V");
        oldMethods.add("java/util/Vector.setElementAt(Ljava/lang/Object;I)V");
    }
}

