/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class NeedlessMemberCollectionSynchronization
extends BytecodeScanningDetector {
    private static JavaClass collectionClass;
    private static JavaClass mapClass;
    private static Set<String> syncCollections;
    private static Set<String> modifyingMethods;
    private static final int IN_METHOD = 0;
    private static final int IN_CLINIT = 1;
    private static final int IN_INIT = 2;
    private BugReporter bugReporter;
    private Map<String, FieldInfo> collectionFields;
    private Map<Integer, String> aliases;
    private OpcodeStack stack;
    private int state;
    private String className;

    public NeedlessMemberCollectionSynchronization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            if (collectionClass != null && mapClass != null) {
                this.collectionFields = new HashMap<String, FieldInfo>();
                this.aliases = new HashMap<Integer, String>();
                this.stack = new OpcodeStack();
                JavaClass cls = classContext.getJavaClass();
                this.className = cls.getClassName();
                super.visitClassContext(classContext);
                Iterator<FieldInfo> i$ = this.collectionFields.values().iterator();
                while (i$.hasNext()) {
                    FieldInfo fi = i$.next();
                    if (!fi.isSynchronized()) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NMCS_NEEDLESS_MEMBER_COLLECTION_SYNCHRONIZATION", 2).addClass((PreorderVisitor)this).addField(fi.getFieldAnnotation()));
                }
            }
        }
        finally {
            this.collectionFields = null;
            this.aliases = null;
            this.stack = null;
        }
    }

    public void visitField(Field obj) {
        String signature;
        if (obj.isPrivate() && (signature = obj.getSignature()).charAt(0) == 'L') {
            try {
                JavaClass cls = Repository.lookupClass((String)signature.substring(1, signature.length() - 1));
                if (cls.implementationOf(collectionClass) || cls.implementationOf(mapClass)) {
                    FieldAnnotation fa = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
                    this.collectionFields.put(fa.getFieldName(), new FieldInfo(fa));
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    public void visitCode(Code obj) {
        if (this.collectionFields.size() > 0) {
            this.aliases.clear();
            String methodName = this.getMethodName();
            this.state = "<clinit>".equals(methodName) ? 1 : ("<init>".equals(methodName) ? 2 : 0);
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 1: {
                this.sawCLInitOpcode(seen);
                break;
            }
            case 2: {
                this.sawInitOpcode(seen);
                break;
            }
            case 0: {
                this.sawMethodOpcode(seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sawCLInitOpcode(int seen) {
        boolean isSyncCollection = false;
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            isSyncCollection = this.isSyncCollectionCreation(seen);
            if (seen == 179) {
                this.processCollectionStore();
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (isSyncCollection && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sawInitOpcode(int seen) {
        boolean isSyncCollection = false;
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            isSyncCollection = this.isSyncCollectionCreation(seen);
            if (seen == 181) {
                this.processCollectionStore();
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (isSyncCollection && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sawMethodOpcode(int seen) {
        boolean isSyncCollection = false;
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            isSyncCollection = this.isSyncCollectionCreation(seen);
            switch (seen) {
                case 182: 
                case 185: {
                    String methodName = this.getNameConstantOperand();
                    if (modifyingMethods.contains(methodName)) {
                        String signature = this.getSigConstantOperand();
                        int parmCount = Type.getArgumentTypes((String)signature).length;
                        if (this.stack.getStackDepth() > parmCount) {
                            OpcodeStack.Item item = this.stack.getStackItem(parmCount);
                            XField field = item.getXField();
                            if (field != null) {
                                this.collectionFields.remove(field.getName());
                            } else {
                                Integer register;
                                String fName;
                                int reg = item.getRegisterNumber();
                                if (reg >= 0 && (fName = this.aliases.get(register = Integer14.valueOf(reg))) != null) {
                                    this.collectionFields.remove(fName);
                                    this.aliases.remove(register);
                                }
                            }
                        }
                    }
                    this.removeCollectionParameters();
                    return;
                }
                case 184: {
                    this.removeCollectionParameters();
                    return;
                }
                case 176: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    XField field = item.getXField();
                    if (field == null) return;
                    this.collectionFields.remove(field.getName());
                    return;
                }
                case 179: 
                case 181: {
                    String fieldName = this.getNameConstantOperand();
                    this.collectionFields.remove(fieldName);
                    return;
                }
                case 167: 
                case 200: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    XField field = item.getXField();
                    if (field == null) return;
                    this.collectionFields.remove(field.getName());
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (isSyncCollection && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    private boolean isSyncCollectionCreation(int seen) {
        if (seen == 183) {
            if ("<init>".equals(this.getNameConstantOperand())) {
                return syncCollections.contains(this.getClassConstantOperand());
            }
        } else if (seen == 184 && "java/util/Collections".equals(this.getClassConstantOperand())) {
            String methodName = this.getNameConstantOperand();
            return "synchronizedMap".equals(methodName) || "synchronizedSet".equals(methodName);
        }
        return false;
    }

    private void processCollectionStore() {
        FieldInfo fi;
        String fieldName;
        OpcodeStack.Item item;
        String fieldClassName = this.getDottedClassConstantOperand();
        if (fieldClassName.equals(this.className) && this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).getUserValue() != null && (fieldName = this.getNameConstantOperand()) != null && (fi = this.collectionFields.get(fieldName)) != null) {
            fi.getFieldAnnotation().setSourceLines(SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
            fi.setSynchronized();
        }
    }

    private void removeCollectionParameters() {
        int parmCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
        if (this.stack.getStackDepth() >= parmCount) {
            for (int i = 0; i < parmCount; ++i) {
                OpcodeStack.Item item = this.stack.getStackItem(i);
                XField field = item.getXField();
                if (field == null) continue;
                this.collectionFields.remove(field.getName());
            }
        }
    }

    static {
        try {
            collectionClass = Repository.lookupClass((String)"java/util/Collection");
        }
        catch (ClassNotFoundException cnfe) {
            collectionClass = null;
        }
        try {
            mapClass = Repository.lookupClass((String)"java/util/Map");
        }
        catch (ClassNotFoundException cnfe) {
            mapClass = null;
        }
        syncCollections = new HashSet<String>();
        syncCollections.add("java/util/Vector");
        syncCollections.add("java/util/Hashtable");
        modifyingMethods = new HashSet<String>();
        modifyingMethods.add("add");
        modifyingMethods.add("addAll");
        modifyingMethods.add("addFirst");
        modifyingMethods.add("addElement");
        modifyingMethods.add("addLast");
        modifyingMethods.add("clear");
        modifyingMethods.add("insertElementAt");
        modifyingMethods.add("put");
        modifyingMethods.add("remove");
        modifyingMethods.add("removeAll");
        modifyingMethods.add("removeAllElements");
        modifyingMethods.add("removeElement");
        modifyingMethods.add("removeElementAt");
        modifyingMethods.add("removeFirst");
        modifyingMethods.add("removeLast");
        modifyingMethods.add("removeRange");
        modifyingMethods.add("retainAll");
        modifyingMethods.add("set");
        modifyingMethods.add("setElementAt");
        modifyingMethods.add("setSize");
    }

    static class FieldInfo {
        private FieldAnnotation fieldAnnotation;
        private boolean isSynchronized;

        public FieldInfo(FieldAnnotation fa) {
            this.fieldAnnotation = fa;
            this.isSynchronized = false;
        }

        public void setSynchronized() {
            this.isSynchronized = true;
        }

        public FieldAnnotation getFieldAnnotation() {
            return this.fieldAnnotation;
        }

        public boolean isSynchronized() {
            return this.isSynchronized;
        }
    }
}

