/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.Type;

public class NeedlessInstanceRetrieval
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_INVOKE = 1;
    private static final int SEEN_POP = 2;
    private BugReporter bugReporter;
    private LineNumberTable lnTable;
    private int state;
    private int invokePC;

    public NeedlessInstanceRetrieval(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            this.lnTable = obj.getLineNumberTable();
            if (this.lnTable != null) {
                this.state = 0;
                super.visitCode(obj);
            }
        }
        finally {
            this.lnTable = null;
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                String clsName;
                String sig;
                Type retType;
                if (seen != 185 && seen != 182 || !(retType = Type.getReturnType((String)(sig = this.getSigConstantOperand()))).getSignature().startsWith("L") || "java/lang/Object".equals(clsName = this.getClassConstantOperand()) || "java/lang/String".equals(clsName)) break;
                this.invokePC = this.getPC();
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 87) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if (seen >= 1 && seen <= 15 && this.lnTable.getSourceLine(this.invokePC) == this.lnTable.getSourceLine(this.getPC())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NIR_NEEDLESS_INSTANCE_RETRIEVAL", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }
}

