/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class NeedlessCustomSerialization
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ALOAD1 = 1;
    private static final int SEEN_INVOKEVIRTUAL = 2;
    private static final int SEEN_RETURN = 3;
    private static final int SEEN_INVALID = 4;
    private static JavaClass serializableClass;
    private BugReporter bugReporter;
    private boolean inReadObject;
    private boolean inWriteObject;
    private int state;

    public NeedlessCustomSerialization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            if (serializableClass != null && cls.implementationOf(serializableClass)) {
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visitCode(Code obj) {
        String nameAndSignature = this.getMethod().getName() + this.getMethod().getSignature();
        if ("readObject(Ljava/io/ObjectInputStream;)V".equals(nameAndSignature)) {
            this.inReadObject = true;
            this.inWriteObject = false;
        } else if ("writeObject(Ljava/io/ObjectOutputStream;)V".equals(nameAndSignature)) {
            this.inReadObject = false;
            this.inWriteObject = true;
        }
        if (this.inReadObject || this.inWriteObject) {
            this.state = 0;
            super.visitCode(obj);
            if (this.state != 4) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NCS_NEEDLESS_CUSTOM_SERIALIZATION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 1));
            }
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen == 43) {
                    this.state = 1;
                    break;
                }
                this.state = 4;
                break;
            }
            case 1: {
                this.state = 4;
                if (seen != 182) break;
                String nameAndSignature = this.getNameConstantOperand() + this.getSigConstantOperand();
                if ((!this.inReadObject || !"defaultReadObject()V".equals(nameAndSignature)) && (!this.inWriteObject || !"defaultWriteObject()V".equals(nameAndSignature))) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (seen == 177) {
                    this.state = 3;
                    break;
                }
                this.state = 4;
                break;
            }
            case 3: {
                this.state = 4;
            }
        }
    }

    static {
        try {
            serializableClass = Repository.lookupClass((String)"java/io/Serializable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

