/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Method;

public class NeedlessAutoboxing
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_VALUE = 1;
    private static final int SEEN_VALUEOFSTRING = 2;
    private static final int SEEN_PARSE = 3;
    private static final int SEEN_CTOR = 4;
    private static final int SEEN_VALUEOFPRIMITIVE = 5;
    private static final int SEEN_GOTO = 6;
    private static final int SEEN_ICONST = 7;
    private static final int SEEN_GETSTATIC = 8;
    private static final Map<String, String[]> boxClasses = new HashMap<String, String[]>();
    private static final Map<String, String> parseClasses;
    private BugReporter bugReporter;
    private int state;
    private String boxClass;

    public NeedlessAutoboxing(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitMethod(Method obj) {
        this.state = 0;
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: 
            case 6: {
                if (seen == 182) {
                    String methodInfo;
                    this.boxClass = this.getClassConstantOperand();
                    String[] boxSigs = boxClasses.get(this.boxClass);
                    if (boxSigs == null || !boxSigs[0].equals(methodInfo = this.getNameConstantOperand() + this.getSigConstantOperand())) break;
                    this.state = 1;
                    break;
                }
                if (seen == 184) {
                    String methodInfo;
                    this.boxClass = this.getClassConstantOperand();
                    String[] boxSigs = boxClasses.get(this.boxClass);
                    if (boxSigs == null) break;
                    if ("valueOf".equals(this.getNameConstantOperand())) {
                        String sig = this.getSigConstantOperand();
                        if (sig.startsWith("(Ljava/lang/String;)")) {
                            if ("java/lang/Boolean".equals(this.boxClass) && this.getClassContext().getJavaClass().getMajor() < 49) break;
                            this.state = 2;
                            break;
                        }
                        if (sig.startsWith("(Ljava/lang/String;")) break;
                        this.state = 5;
                        break;
                    }
                    String parseSig = parseClasses.get(this.boxClass);
                    if (parseSig == null || !parseSig.equals(methodInfo = this.getNameConstantOperand() + this.getSigConstantOperand())) break;
                    this.state = 3;
                    break;
                }
                if (seen == 183) {
                    this.boxClass = this.getClassConstantOperand();
                    String[] boxSigs = boxClasses.get(this.boxClass);
                    if (boxSigs == null || !"<init>".equals(this.getNameConstantOperand()) || !boxSigs[1].equals(this.getSigConstantOperand())) break;
                    this.state = 4;
                    break;
                }
                if (seen == 3 || seen == 4) {
                    if (this.state != 0) break;
                    this.state = 7;
                    break;
                }
                if (seen == 178) {
                    String fldName;
                    String clsName = this.getClassConstantOperand();
                    if (!"java/lang/Boolean".equals(clsName) || !"TRUE".equals(fldName = this.getNameConstantOperand()) && !"FALSE".equals(fldName)) break;
                    this.state = 8;
                    break;
                }
                if (seen != 167 && seen != 200) break;
                this.state = 6;
                break;
            }
            case 1: {
                if (seen == 183) {
                    if (this.boxClass.equals(this.getClassConstantOperand())) {
                        String methodSig;
                        String methodName = this.getNameConstantOperand();
                        String boxSig = boxClasses.get(this.boxClass)[1];
                        if ("<init>".equals(methodName) && boxSig.equals(methodSig = this.getSigConstantOperand())) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_AUTOBOXING_CTOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                } else if (seen == 184 && this.boxClass.equals(this.getClassConstantOperand())) {
                    String methodSig;
                    String methodName = this.getNameConstantOperand();
                    String boxSig = boxClasses.get(this.boxClass)[2];
                    if ("valueOf".equals(methodName) && boxSig.equals(methodSig = this.getSigConstantOperand())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_AUTOBOXING_VALUEOF", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                this.state = 0;
                break;
            }
            case 4: 
            case 5: {
                if (seen == 182) {
                    String[] boxSigs = boxClasses.get(this.boxClass);
                    if (boxSigs[0].equals(this.getNameConstantOperand() + this.getSigConstantOperand())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOX_TO_UNBOX", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    } else if (this.getSigConstantOperand().startsWith("()") && this.getNameConstantOperand().endsWith("Value")) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOX_TO_CAST", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                this.state = 0;
                break;
            }
            case 2: {
                String[] boxSigs;
                if (seen == 182 && (boxSigs = boxClasses.get(this.boxClass))[0].equals(this.getNameConstantOperand() + this.getSigConstantOperand())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOXING_PARSE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (seen == 184) {
                    if (this.boxClass.equals(this.getClassConstantOperand()) && "valueOf".equals(this.getNameConstantOperand())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOXING_VALUEOF", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if (seen == 183 && "<init>".equals(this.getNameConstantOperand()) && this.boxClass.equals(this.getClassConstantOperand())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOXING_STRING_CTOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
                break;
            }
            case 7: {
                if (seen == 184 && "java/lang/Boolean".equals(this.getClassConstantOperand()) && "valueOf".equals(this.getNameConstantOperand()) && "(Z)Ljava/lang/Boolean;".equals(this.getSigConstantOperand())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOOLEAN_CONSTANT_CONVERSION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
                this.sawOpcode(seen);
                break;
            }
            case 8: {
                if (seen == 182 && "java/lang/Boolean".equals(this.getClassConstantOperand()) && "booleanValue".equals(this.getNameConstantOperand()) && "()Z".equals(this.getSigConstantOperand())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "NAB_NEEDLESS_BOOLEAN_CONSTANT_CONVERSION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
                this.sawOpcode(seen);
            }
        }
    }

    static {
        boxClasses.put("java/lang/Boolean", new String[]{"booleanValue()Z", "(Z)V", "(Z)Ljava/lang/Boolean;"});
        boxClasses.put("java/lang/Character", new String[]{"charValue()C", "(C)V", "(C)Ljava/lang/Character;"});
        boxClasses.put("java/lang/Byte", new String[]{"byteValue()B", "(B)V", "(B)Ljava/lang/Byte;"});
        boxClasses.put("java/lang/Short", new String[]{"shortValue()S", "(S)V", "(S)Ljava/lang/Short;"});
        boxClasses.put("java/lang/Integer", new String[]{"intValue()I", "(I)V", "(I)Ljava/lang/Integer;"});
        boxClasses.put("java/lang/Long", new String[]{"longValue()J", "(J)V", "(J)Ljava/lang/Long;"});
        boxClasses.put("java/lang/Float", new String[]{"floatValue()F", "(F)V", "(F)Ljava/lang/Float;"});
        boxClasses.put("java/lang/Double", new String[]{"doubleValue()D", "(D)V", "(D)Ljava/lang/Double;"});
        parseClasses = new HashMap<String, String>();
        parseClasses.put("java/lang/Boolean", "parseBoolean(Ljava/lang/String;)Z");
        parseClasses.put("java/lang/Byte", "parseByte(Ljava/lang/String;)B");
        parseClasses.put("java/lang/Short", "parseShort(Ljava/lang/String;)S");
        parseClasses.put("java/lang/Integer", "parseInt(Ljava/lang/String;)I");
        parseClasses.put("java/lang/Long", "parseLong(Ljava/lang/String;)J");
        parseClasses.put("java/lang/Float", "parseFloat(Ljava/lang/String;)F");
        parseClasses.put("java/lang/Double", "parseDouble(Ljava/lang/String;)D");
    }
}

