/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MisleadingOverloadModel
extends PreorderVisitor
implements Detector {
    private static final Integer INSTANCE = Integer14.valueOf(0);
    private static final Integer STATIC = Integer14.valueOf(1);
    private static final Integer BOTH = Integer14.valueOf(2);
    private final BugReporter bugReporter;

    public MisleadingOverloadModel(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methods;
        HashMap<String, Integer> declMethods = new HashMap<String, Integer>();
        JavaClass cls = classContext.getJavaClass();
        String clsName = cls.getClassName();
        Method[] arr$ = methods = cls.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer newType;
            boolean report;
            Method m = arr$[i$];
            String methodName = m.getName();
            if (m.isStatic()) {
                boolean bl = report = declMethods.get(methodName) == INSTANCE;
                newType = report ? BOTH : STATIC;
            } else {
                report = declMethods.get(m.getName()) == STATIC;
                newType = report ? BOTH : INSTANCE;
            }
            declMethods.put(methodName, newType);
            if (!report) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "MOM_MISLEADING_OVERLOAD_MODEL", 2).addClass(cls).addMethod(XFactory.createXMethod((String)clsName, (Method)m)).addString(methodName));
        }
    }

    public void report() {
    }
}

