/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class MethodReturnsConstant
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Object returnConstant;
    private boolean methodSuspect;
    private int returnPC;

    public MethodReturnsConstant(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        int aFlags = m.getAccessFlags();
        if (!((aFlags & 2) == 0 && (aFlags & 8) == 0 || (aFlags & 0x1000) != 0 || m.getSignature().endsWith(")Z"))) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.returnConstant = null;
            this.methodSuspect = true;
            this.returnPC = -1;
            super.visitCode(obj);
            if (this.methodSuspect && this.returnConstant != null) {
                BugInstance bi = new BugInstance((Detector)this, "MRC_METHOD_RETURNS_CONSTANT", (aFlags & 2) != 0 ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                if (this.returnPC >= 0) {
                    bi.addSourceLine((BytecodeScanningDetector)this, this.returnPC);
                }
                bi.addString(this.returnConstant.toString());
                this.bugReporter.reportBug(bi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean sawSBToString = false;
        try {
            String clsName;
            if (!this.methodSuspect) {
                return;
            }
            if (seen >= 172 && seen <= 176) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Object constant = item.getConstant();
                    if (constant == null) {
                        this.methodSuspect = false;
                        return;
                    }
                    if (item.getUserValue() != null && "".equals(constant)) {
                        this.methodSuspect = false;
                        return;
                    }
                    if (this.returnConstant != null && !this.returnConstant.equals(constant)) {
                        this.methodSuspect = false;
                        return;
                    }
                    this.returnConstant = constant;
                }
            } else if (seen == 167 || seen == 200) {
                if (this.stack.getStackDepth() > 0) {
                    this.methodSuspect = false;
                }
            } else if (seen == 182 && (clsName = this.getClassConstantOperand()).startsWith("java/lang/StringB")) {
                sawSBToString = "toString".equals(this.getNameConstantOperand());
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (sawSBToString && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }
}

