/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class ManualArrayCopy
extends BytecodeScanningDetector {
    public static final int SEEN_NOTHING = 0;
    public static final int SEEN_ARRAY1_LOAD = 1;
    public static final int SEEN_ARRAY1_INDEX = 2;
    public static final int SEEN_ARRAY2_LOAD = 3;
    public static final int SEEN_ARRAY2_INDEX = 4;
    public static final int SEEN_ELEM_LOAD = 5;
    private static final BitSet arrayLoadOps = new BitSet();
    private BugReporter bugReporter;
    private int state;
    private int arrayIndexReg;
    private int loadInstruction;

    public ManualArrayCopy(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.intersects(arrayLoadOps);
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.state = 0;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen != 25 && (seen < 42 || seen > 45)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 21) {
                    this.arrayIndexReg = this.getRegisterOperand();
                    this.state = 2;
                    break;
                }
                if (seen >= 26 && seen <= 29) {
                    this.arrayIndexReg = seen - 26;
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if (seen == 25 || seen >= 42 && seen <= 45) {
                    this.state = 3;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (seen == 21) {
                    if (this.arrayIndexReg == this.getRegisterOperand()) {
                        this.state = 4;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                if (seen >= 26 && seen <= 29) {
                    if (this.arrayIndexReg == seen - 26) {
                        this.state = 4;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            case 4: {
                if (seen == 50 || seen == 51 || seen == 52 || seen == 53 || seen == 46 || seen == 47 || seen == 49 || seen == 48) {
                    this.loadInstruction = seen;
                    this.state = 5;
                    break;
                }
                this.state = 0;
                break;
            }
            case 5: {
                if ((seen == 83 || seen == 84 || seen == 85 || seen == 86 || seen == 79 || seen == 80 || seen == 82 || seen == 81) && this.similarArrayInstructions(this.loadInstruction, seen)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "MAC_MANUAL_ARRAY_COPY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
            }
        }
    }

    private boolean similarArrayInstructions(int load, int store) {
        if (load == 50 && store == 83) {
            return true;
        }
        if (load == 46 && store == 79) {
            return true;
        }
        if (load == 49 && store == 82) {
            return true;
        }
        if (load == 47 && store == 80) {
            return true;
        }
        if (load == 48 && store == 81) {
            return true;
        }
        if (load == 51 && store == 84) {
            return true;
        }
        if (load == 52 && store == 85) {
            return true;
        }
        return load == 53 && store == 86;
    }

    static {
        arrayLoadOps.set(50);
        arrayLoadOps.set(51);
        arrayLoadOps.set(52);
        arrayLoadOps.set(53);
        arrayLoadOps.set(46);
        arrayLoadOps.set(47);
        arrayLoadOps.set(49);
        arrayLoadOps.set(48);
    }
}

