/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class LoggerOddities
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String clsName;

    public LoggerOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.clsName = classContext.getJavaClass().getClassName();
            int subclassIndex = this.clsName.indexOf(36);
            while (subclassIndex >= 0) {
                String simpleName = this.clsName.substring(subclassIndex + 1);
                try {
                    Integer.parseInt(simpleName);
                    this.clsName = this.clsName.substring(0, subclassIndex);
                    subclassIndex = this.clsName.indexOf(36);
                }
                catch (NumberFormatException nfe) {
                    subclassIndex = -1;
                }
            }
            this.clsName = this.clsName.replace('.', '/');
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        Method m = this.getMethod();
        if ("<init>".equals(m.getName())) {
            Type[] types;
            Type[] arr$ = types = Type.getArgumentTypes((String)m.getSignature());
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Type t = arr$[i$];
                String parmSig = t.getSignature();
                if (!"Lorg/slf4j/Logger;".equals(parmSig) && !"Lorg/apache/log4j/Logger;".equals(parmSig)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_SUSPECT_LOG_PARAMETER", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        String ldcClassName = null;
        try {
            if (seen == 18 || seen == 19) {
                Constant c = this.getConstantRefOperand();
                if (c instanceof ConstantClass) {
                    ConstantPool pool = this.getConstantPool();
                    ldcClassName = ((ConstantUtf8)pool.getConstant(((ConstantClass)c).getNameIndex())).getBytes();
                }
            } else if (seen == 184) {
                String callingClsName = this.getClassConstantOperand();
                String mthName = this.getNameConstantOperand();
                String loggingClassName = null;
                if ("org/slf4j/LoggerFactory".equals(callingClsName) && "getLogger".equals(mthName)) {
                    OpcodeStack.Item item;
                    String signature = this.getSigConstantOperand();
                    if ("(Ljava/lang/Class;)Lorg/slf4j/Logger;".equals(signature)) {
                        if (this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item item2 = this.stack.getStackItem(0);
                            loggingClassName = (String)item2.getUserValue();
                        }
                    } else if ("(Ljava/lang/String;)Lorg/slf4j/Logger;".equals(signature) && this.stack.getStackDepth() > 0 && (loggingClassName = (String)(item = this.stack.getStackItem(0)).getConstant()) != null) {
                        loggingClassName = loggingClassName.replace('.', '/');
                    }
                } else if ("org/apache/log4j/Logger".equals(callingClsName) && "getLogger".equals(mthName)) {
                    OpcodeStack.Item item;
                    String signature = this.getSigConstantOperand();
                    if ("(Ljava/lang/Class;)Lorg/apache/log4j/Logger;".equals(signature)) {
                        if (this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item item3 = this.stack.getStackItem(0);
                            loggingClassName = (String)item3.getUserValue();
                        }
                    } else if ("(Ljava/lang/String;)Lorg/apache/log4j/Logger;".equals(signature)) {
                        OpcodeStack.Item item4;
                        if (this.stack.getStackDepth() > 0 && (loggingClassName = (String)(item4 = this.stack.getStackItem(0)).getConstant()) != null) {
                            loggingClassName = loggingClassName.replace('.', '/');
                        }
                    } else if ("(Ljava/lang/String;Lorg/apache/log4j/spi/LoggerFactory;)Lorg/apache/log4j/Logger;".equals(signature) && this.stack.getStackDepth() > 1 && (loggingClassName = (String)(item = this.stack.getStackItem(1)).getConstant()) != null) {
                        loggingClassName = loggingClassName.replace('.', '/');
                    }
                }
                if (loggingClassName != null && this.stack.getStackDepth() > 0 && !loggingClassName.equals(this.clsName)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "LO_SUSPECT_LOG_CLASS", callingClsName.indexOf(36) >= 0 ? 3 : 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (ldcClassName != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)ldcClassName);
            }
        }
    }
}

