/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class ListIndexedIterating
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_IINC = 1;
    private static final int LOOP_NOT_STARTED = 0;
    private static final int LOOP_INDEX_LOADED_FOR_TEST = 1;
    private static final int LOOP_IN_BODY = 2;
    private static final int LOOP_IN_BODY_WITH_GET = 3;
    private static final int FIND_LOOP_STAGE = 0;
    private static final int FIND_BUG_STAGE = 1;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<ForLoop> possibleForLoops;
    private int stage;
    private int state;
    private int loopReg;
    private boolean sawListSize;

    public ListIndexedIterating(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.possibleForLoops = new HashSet<ForLoop>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.possibleForLoops = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(132) && (bytecodeSet.get(167) || bytecodeSet.get(200));
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (this.prescreen(m)) {
            this.sawListSize = false;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.state = 0;
            this.stage = 0;
            super.visitCode(obj);
            if (this.sawListSize) {
                this.stack.resetForMethodEntry((DismantleBytecode)this);
                this.state = 0;
                this.stage = 1;
                super.visitCode(obj);
            }
        }
    }

    public void sawOpcode(int seen) {
        if (this.stage == 0) {
            this.sawOpcodeLoop(seen);
        } else {
            this.sawOpcodeBug(seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sawOpcodeLoop(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            switch (this.state) {
                case 0: {
                    if (seen != 132 || this.getIntConstant() != 1) break;
                    this.loopReg = this.getRegisterOperand();
                    this.state = 1;
                    break;
                }
                case 1: {
                    int pc;
                    int branchTarget;
                    if ((seen == 167 || seen == 200) && (branchTarget = this.getBranchTarget()) < (pc = this.getPC())) {
                        this.possibleForLoops.add(new ForLoop(branchTarget, pc, this.loopReg));
                    }
                    this.state = 0;
                }
            }
            if (seen == 185 && "java/util/List".equals(this.getClassConstantOperand()) && "size".equals(this.getNameConstantOperand()) && "()I".equals(this.getSigConstantOperand())) {
                this.sawListSize = true;
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sawOpcodeBug(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            Iterator<ForLoop> it = this.possibleForLoops.iterator();
            while (it.hasNext()) {
                ForLoop fl = it.next();
                switch (fl.getLoopState()) {
                    case 0: {
                        if (this.getPC() != fl.getLoopStart()) break;
                        if ((seen == 21 || seen >= 26 && seen <= 29) && this.getReg(seen, 21, 26) == fl.getLoopReg()) {
                            fl.setLoopState(1);
                            break;
                        }
                        it.remove();
                        break;
                    }
                    case 1: {
                        OpcodeStack.Item itm;
                        if (this.getPC() >= fl.getLoopEnd()) {
                            it.remove();
                            break;
                        }
                        if (seen != 162) break;
                        if (this.stack.getStackDepth() > 1 && (itm = this.stack.getStackItem(0)).getConstant() != null) {
                            it.remove();
                            break;
                        }
                        int branchTarget = this.getBranchTarget();
                        if (branchTarget < fl.getLoopEnd() + 3 || branchTarget > fl.getLoopEnd() + 5) break;
                        fl.setLoopState(2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        boolean sawGet;
                        if (this.getPC() == fl.getLoopEnd() && fl.getLoopState() == 3) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "LII_LIST_INDEXED_ITERATING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLineRange((BytecodeScanningDetector)this, fl.getLoopStart(), fl.getLoopEnd()));
                            it.remove();
                        }
                        if (this.getPC() > fl.getLoopEnd()) {
                            it.remove();
                        }
                        if (seen == 21 || seen >= 26 && seen <= 29) {
                            this.loopReg = this.getReg(seen, 21, 26);
                            if (this.loopReg != fl.getLoopReg()) break;
                            fl.setLoopRegLoaded(true);
                            break;
                        }
                        if (!fl.getLoopRegLoaded()) break;
                        boolean bl = sawGet = seen == 185 && "java/util/List".equals(this.getClassConstantOperand()) && "get".equals(this.getNameConstantOperand()) && "(I)Ljava/lang/Object;".equals(this.getSigConstantOperand());
                        if (!sawGet) {
                            it.remove();
                            break;
                        }
                        fl.setLoopState(3);
                        if (this.stack.getStackDepth() > 1) {
                            OpcodeStack.Item itm = this.stack.getStackItem(0);
                            if (!itm.couldBeZero()) {
                                it.remove();
                            } else {
                                itm = this.stack.getStackItem(1);
                                if (fl.isSecondItem(itm)) {
                                    it.remove();
                                }
                            }
                        }
                        fl.setLoopRegLoaded(false);
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private int getReg(int seen, int generalOp, int zeroOp) {
        if (seen == generalOp) {
            return this.getRegisterOperand();
        }
        return seen - zeroOp;
    }

    static class ForLoop {
        private int loopStart;
        private int loopEnd;
        private int loopReg;
        private int loopState;
        private boolean loopRegLoaded;
        private OpcodeStack.Item loopCollectionItem;

        public ForLoop(int start, int end, int reg) {
            this.loopStart = start;
            this.loopEnd = end;
            this.loopReg = reg;
            this.loopState = 0;
            this.loopRegLoaded = false;
            this.loopCollectionItem = null;
        }

        public int getLoopStart() {
            return this.loopStart;
        }

        public int getLoopEnd() {
            return this.loopEnd;
        }

        public int getLoopReg() {
            return this.loopReg;
        }

        public void setLoopState(int state) {
            this.loopState = state;
        }

        public int getLoopState() {
            return this.loopState;
        }

        public void setLoopRegLoaded(boolean loaded) {
            this.loopRegLoaded = loaded;
        }

        public boolean getLoopRegLoaded() {
            return this.loopRegLoaded;
        }

        public boolean isSecondItem(OpcodeStack.Item itm) {
            if (this.loopCollectionItem == null) {
                this.loopCollectionItem = itm;
                return false;
            }
            int seenReg = this.loopCollectionItem.getRegisterNumber();
            if (seenReg >= 0) {
                if (itm.getXField() != null) {
                    return true;
                }
                int newReg = itm.getRegisterNumber();
                if (newReg >= 0 && seenReg != newReg) {
                    return true;
                }
            } else {
                XField seenField = this.loopCollectionItem.getXField();
                if (seenField != null) {
                    if (itm.getRegisterNumber() >= 0) {
                        return true;
                    }
                    XField newField = itm.getXField();
                    if (newField != null && !newField.getName().equals(seenField.getName())) {
                        return true;
                    }
                }
            }
            this.loopCollectionItem = itm;
            return false;
        }
    }
}

