/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.Type;

public class JUnitAssertionOddities
extends BytecodeScanningDetector {
    private static final String RUNTIME_VISIBLE_ANNOTATIONS = "RuntimeVisibleAnnotations";
    private static final String TEST_ANNOTATION_SIGNATURE = "Lorg/junit/Test;";
    private static final String OLD_ASSERT_CLASS = "junit/framework/Assert";
    private static final String NEW_ASSERT_CLASS = "org/junit/Assert";
    private static JavaClass testCaseClass;
    private static JavaClass testAnnotationClass;
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private boolean isTestCaseDerived;
    private boolean isAnnotationCapable;

    public JUnitAssertionOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            this.isTestCaseDerived = testCaseClass != null && cls.instanceOf(testCaseClass);
            boolean bl = this.isAnnotationCapable = cls.getMajor() >= 5 && testAnnotationClass != null;
            if (this.isTestCaseDerived || this.isAnnotationCapable) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        boolean isTestMethod;
        Method m = this.getMethod();
        boolean bl = isTestMethod = this.isTestCaseDerived && m.getName().startsWith("test");
        if (!isTestMethod && this.isAnnotationCapable) {
            Attribute[] atts;
            Attribute[] arr$ = atts = m.getAttributes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Unknown unAtt;
                byte[] bytes;
                int constantPoolIndex;
                String name;
                Attribute att = arr$[i$];
                ConstantPool cp = att.getConstantPool();
                Constant c = cp.getConstant(att.getNameIndex());
                if (!(c instanceof ConstantUtf8) || !RUNTIME_VISIBLE_ANNOTATIONS.equals(name = ((ConstantUtf8)c).getBytes()) || !(att instanceof Unknown) || !((c = cp.getConstant(constantPoolIndex = (bytes = (unAtt = (Unknown)att).getBytes())[3] & 0xFF)) instanceof ConstantUtf8) || !TEST_ANNOTATION_SIGNATURE.equals(name = ((ConstantUtf8)c).getBytes())) continue;
                isTestMethod = true;
                break;
            }
        }
        if (isTestMethod) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        block14: {
            block16: {
                block18: {
                    block17: {
                        block15: {
                            userValue = null;
                            this.stack.mergeJumps((DismantleBytecode)this);
                            if (seen != 184) break block14;
                            clsName = this.getClassConstantOperand();
                            if (!"junit/framework/Assert".equals(clsName) && !"org/junit/Assert".equals(clsName)) ** GOTO lbl56
                            methodName = this.getNameConstantOperand();
                            if (!"assertEquals".equals(methodName)) ** GOTO lbl53
                            signature = this.getSigConstantOperand();
                            argTypes = Type.getArgumentTypes((String)signature);
                            if (!argTypes[0].equals((Object)Type.STRING) || !argTypes[1].equals((Object)Type.STRING)) break block15;
                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                            if (userValue != null && this.stack.getStackDepth() > 0) {
                                item = this.stack.getStackItem(0);
                                item.setUserValue((Object)userValue);
                            }
                            return;
                        }
                        if (this.stack.getStackDepth() < 2) break block16;
                        item1 = this.stack.getStackItem(1);
                        cons1 = item1.getConstant();
                        if (cons1 == null || !argTypes[argTypes.length - 1].equals((Object)Type.BOOLEAN) || !argTypes[argTypes.length - 2].equals((Object)Type.BOOLEAN)) break block17;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_BOOLEAN_ASSERT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        if (userValue != null && this.stack.getStackDepth() > 0) {
                            item = this.stack.getStackItem(0);
                            item.setUserValue((Object)userValue);
                        }
                        return;
                    }
                    item0 = this.stack.getStackItem(0);
                    if (item0.getConstant() == null) break block18;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_ACTUAL_CONSTANT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    if (userValue != null && this.stack.getStackDepth() > 0) {
                        item = this.stack.getStackItem(0);
                        item.setUserValue((Object)userValue);
                    }
                    return;
                }
                if (!argTypes[0].equals((Object)Type.OBJECT) || !argTypes[1].equals((Object)Type.OBJECT) || !"Ljava/lang/Double;".equals(item0.getSignature()) || !"Ljava/lang/Double;".equals(item1.getSignature())) break block16;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_INEXACT_DOUBLE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (userValue != null && this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    item.setUserValue((Object)userValue);
                }
                return;
            }
            try {
                break block14;
lbl53:
                // 1 sources

                if ("assertNotNull".equals(methodName) && this.stack.getStackDepth() > 0 && "valueOf".equals(this.stack.getStackItem(0).getUserValue())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "JAO_JUNIT_ASSERTION_ODDITIES_IMPOSSIBLE_NULL", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                break block14;
lbl56:
                // 1 sources

                methodName = this.getNameConstantOperand();
                sig = this.getSigConstantOperand();
                if (clsName.startsWith("java/lang/") && "valueOf".equals(methodName) && sig.indexOf(")Ljava/lang/") >= 0) {
                    userValue = "valueOf";
                }
            }
            finally {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (userValue != null && this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    item.setUserValue(userValue);
                }
            }
        }
    }

    static {
        try {
            testCaseClass = Repository.lookupClass((String)"junit.framework.TestCase");
        }
        catch (ClassNotFoundException cnfe) {
            testCaseClass = null;
        }
        try {
            testAnnotationClass = Repository.lookupClass((String)"org.junit.Test");
        }
        catch (ClassNotFoundException cnfe) {
            testAnnotationClass = null;
        }
    }
}

