/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class InheritanceTypeChecking
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private Set<IfStatement> ifStatements;

    public InheritanceTypeChecking(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.ifStatements = new HashSet<IfStatement>();
            super.visitClassContext(classContext);
        }
        finally {
            this.ifStatements = null;
        }
    }

    public void visitCode(Code obj) {
        this.ifStatements.clear();
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        boolean processed = false;
        Iterator<IfStatement> isi = this.ifStatements.iterator();
        while (isi.hasNext()) {
            int action = isi.next().processOpcode(this, this.bugReporter, seen);
            if (action == 1) {
                isi.remove();
                continue;
            }
            if (action != 2) continue;
            processed = true;
        }
        if (!processed && (seen == 25 || seen >= 42 && seen <= 45)) {
            IfStatement is = new IfStatement(this, seen);
            this.ifStatements.add(is);
        }
    }

    private static class IfStatement {
        public static final int NO_ACTION = 0;
        public static final int REMOVE_ACTION = 1;
        public static final int PROCESSED_ACTION = 2;
        private static final int SEEN_ALOAD = 1;
        private static final int SEEN_INSTANCEOF = 2;
        private static final int SEEN_IFEQ = 3;
        private int state = 1;
        private int reg;
        private int firstPC;
        private int branchTarget;
        private int matchCount;
        private Set<String> instanceOfTypes;

        public IfStatement(BytecodeScanningDetector bsd, int seen) {
            this.reg = RegisterUtils.getALoadReg((DismantleBytecode)bsd, seen);
            this.matchCount = 0;
            this.firstPC = bsd.getPC();
        }

        public int processOpcode(BytecodeScanningDetector bsd, BugReporter bugReporter, int seen) {
            switch (this.state) {
                case 1: {
                    if (seen != 193) break;
                    if (this.instanceOfTypes == null) {
                        this.instanceOfTypes = new HashSet<String>();
                    }
                    this.instanceOfTypes.add(bsd.getClassConstantOperand());
                    this.state = 2;
                    return 2;
                }
                case 2: {
                    if (seen != 153) break;
                    this.branchTarget = bsd.getBranchTarget();
                    this.state = 3;
                    ++this.matchCount;
                    return 2;
                }
                case 3: {
                    if (bsd.getPC() == this.branchTarget) {
                        if ((seen == 25 || seen >= 42 && seen <= 45) && this.reg == RegisterUtils.getALoadReg((DismantleBytecode)bsd, seen)) {
                            this.state = 1;
                            return 2;
                        }
                        if (this.matchCount > 1) {
                            String clsName = bsd.getClassName();
                            int priority = 2;
                            Iterator<String> i$ = this.instanceOfTypes.iterator();
                            while (i$.hasNext()) {
                                String type = i$.next();
                                if (SignatureUtils.similarPackages(clsName, type, 2)) continue;
                                priority = 3;
                                break;
                            }
                            bugReporter.reportBug(new BugInstance((Detector)bsd, "ITC_INHERITANCE_TYPE_CHECKING", priority).addClass((PreorderVisitor)bsd).addMethod((PreorderVisitor)bsd).addSourceLine(bsd, this.firstPC));
                            return 1;
                        }
                    }
                    return 0;
                }
            }
            return 1;
        }
    }
}

