/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;

public class InefficientStringBuffering
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private boolean sawLDCEmpty;

    public InefficientStringBuffering(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        if (obj.getCode() != null) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.sawLDCEmpty = false;
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Boolean nestedSB;
        block19: {
            nestedSB = null;
            try {
                String s;
                Constant c;
                this.stack.mergeJumps((DismantleBytecode)this);
                if (seen == 183) {
                    String calledClass = this.getClassConstantOperand();
                    String signature = this.getSigConstantOperand();
                    if (("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) && "<init>".equals(this.getNameConstantOperand())) {
                        OpcodeStack.Item itm;
                        if ("()V".equals(signature)) {
                            OpcodeStack.Item itm2 = this.getStringBufferItemAt(2);
                            if (itm2 != null) {
                                nestedSB = Boolean.TRUE;
                            }
                        } else if ("(Ljava/lang/String;)V".equals(signature) && this.stack.getStackDepth() > 0 && (nestedSB = (Boolean)(itm = this.stack.getStackItem(0)).getUserValue()) != null && nestedSB.booleanValue()) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "ISB_INEFFICIENT_STRING_BUFFERING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                    break block19;
                }
                if (seen == 182) {
                    OpcodeStack.Item itm;
                    Object cons;
                    OpcodeStack.Item sbItm;
                    String calledClass;
                    if (this.sawLDCEmpty && ("java/lang/StringBuffer".equals(calledClass = this.getClassConstantOperand()) || "java/lang/StringBuilder".equals(calledClass)) && "append".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().startsWith("(Ljava/lang/String;)") && this.stack.getStackDepth() > 1 && (sbItm = this.stack.getStackItem(1)) != null && sbItm.getUserValue() == null && (cons = (itm = this.stack.getStackItem(0)).getConstant()) instanceof String && itm.getRegisterNumber() < 0 && ((String)cons).length() == 0) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "ISB_EMPTY_STRING_APPENDING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    if ("java/lang/StringBuffer".equals(calledClass = this.getClassConstantOperand()) || "java/lang/StringBuilder".equals(calledClass)) {
                        String methodName = this.getNameConstantOperand();
                        if ("append".equals(methodName)) {
                            Boolean uValue;
                            itm = this.getStringBufferItemAt(1);
                            Boolean bl = nestedSB = itm == null ? null : (Boolean)itm.getUserValue();
                            if (this.stack.getStackDepth() > 0 && (uValue = (Boolean)(itm = this.stack.getStackItem(0)).getUserValue()) != null && uValue.booleanValue()) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "ISB_INEFFICIENT_STRING_BUFFERING", "toString".equals(this.getMethodName()) ? 3 : 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                        } else if ("toString".equals(methodName)) {
                            itm = this.getStringBufferItemAt(0);
                            nestedSB = itm == null ? null : (Boolean)itm.getUserValue();
                        }
                    }
                    break block19;
                }
                if (seen == 167 || seen == 200) {
                    int depth = this.stack.getStackDepth();
                    for (int i = 0; i < depth; ++i) {
                        OpcodeStack.Item itm = this.stack.getStackItem(i);
                        itm.setUserValue((Object)Boolean.FALSE);
                    }
                    break block19;
                }
                if (seen != 18 && seen != 19 || !((c = this.getConstantRefOperand()) instanceof ConstantString) || (s = ((ConstantString)c).getBytes(this.getConstantPool())).length() != 0) break block19;
                this.sawLDCEmpty = true;
            }
            catch (Throwable throwable) {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (nestedSB != null && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    itm.setUserValue(nestedSB);
                }
                throw throwable;
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (nestedSB != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item itm = this.stack.getStackItem(0);
            itm.setUserValue((Object)nestedSB);
        }
    }

    private OpcodeStack.Item getStringBufferItemAt(int depth) {
        OpcodeStack.Item itm;
        String signature;
        if (this.stack.getStackDepth() > depth && ("Ljava/lang/StringBuffer;".equals(signature = (itm = this.stack.getStackItem(depth)).getSignature()) || "Ljava/lang/StringBuilder;".equals(signature))) {
            return itm;
        }
        return null;
    }
}

