/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class InappropriateToStringUse
extends BytecodeScanningDetector {
    private static final Set<String> validToStringClasses = new HashSet<String>();
    private static final Set<String> stringAlgoMethods;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, String> toStringRegisters;
    private String packageName;

    public InappropriateToStringUse(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.toStringRegisters = new HashMap<Integer, String>();
            this.packageName = classContext.getJavaClass().getPackageName();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.toStringRegisters = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.toStringRegisters.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        String methodPackage;
        block21: {
            methodPackage = null;
            try {
                if (seen == 182) {
                    String className;
                    String methodName = this.getNameConstantOperand();
                    if ("toString".equals(methodName)) {
                        OpcodeStack.Item item2;
                        JavaClass cls;
                        String className2;
                        String signature = this.getSigConstantOperand();
                        if ("()Ljava/lang/String;".equals(signature) && !validToStringClasses.contains(className2 = this.getClassConstantOperand()) && this.stack.getStackDepth() > 0 && (cls = (item2 = this.stack.getStackItem(0)).getJavaClass()) != null) {
                            methodPackage = cls.getPackageName();
                        }
                    } else if (stringAlgoMethods.contains(methodName) && "java/lang/String".equals(className = this.getClassConstantOperand())) {
                        OpcodeStack.Item item3;
                        String signature = this.getSigConstantOperand();
                        int numParms = Type.getArgumentTypes((String)signature).length;
                        if (this.stack.getStackDepth() > numParms && (item3 = this.stack.getStackItem(numParms)).getUserValue() != null) {
                            XMethod xm = item3.getReturnValueOf();
                            String tsPackage = null;
                            if (xm != null) {
                                tsPackage = xm.getPackageName();
                            }
                            if (tsPackage == null || !SignatureUtils.similarPackages(tsPackage, this.packageName, 2)) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "ITU_INAPPROPRIATE_TOSTRING_USE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                        }
                    }
                    break block21;
                }
                if (seen == 58 || seen >= 75 && seen <= 78) {
                    if (this.stack.getStackDepth() > 0) {
                        item = this.stack.getStackItem(0);
                        Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                        if (item.getUserValue() != null) {
                            XMethod xm = item.getReturnValueOf();
                            if (xm != null) {
                                this.toStringRegisters.put(reg, xm.getPackageName());
                            } else {
                                this.toStringRegisters.remove(reg);
                            }
                        } else {
                            this.toStringRegisters.remove(reg);
                        }
                    }
                    break block21;
                }
                if (seen != 25 && (seen < 42 || seen > 45)) break block21;
                Integer reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                methodPackage = this.toStringRegisters.get(reg);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    this.bugReporter.reportMissingClass(cnfe);
                }
                catch (Throwable throwable) {
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    if (methodPackage != null && this.stack.getStackDepth() > 0) {
                        OpcodeStack.Item item4 = this.stack.getStackItem(0);
                        item4.setUserValue(methodPackage);
                    }
                    throw throwable;
                }
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (methodPackage != null && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item5 = this.stack.getStackItem(0);
                    item5.setUserValue((Object)methodPackage);
                }
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (methodPackage != null && this.stack.getStackDepth() > 0) {
            item = this.stack.getStackItem(0);
            item.setUserValue((Object)methodPackage);
        }
    }

    static {
        validToStringClasses.add("java/lang/Object");
        validToStringClasses.add("java/lang/Byte");
        validToStringClasses.add("java/lang/Character");
        validToStringClasses.add("java/lang/Short");
        validToStringClasses.add("java/lang/Integer");
        validToStringClasses.add("java/lang/Boolean");
        validToStringClasses.add("java/lang/Float");
        validToStringClasses.add("java/lang/Double");
        validToStringClasses.add("java/lang/Long");
        validToStringClasses.add("java/lang/String");
        validToStringClasses.add("java/lang/Number");
        validToStringClasses.add("java/lang/StringBuffer");
        validToStringClasses.add("java/lang/StringBuilder");
        validToStringClasses.add("java/io/StringWriter");
        stringAlgoMethods = new HashSet<String>();
        stringAlgoMethods.add("indexOf");
        stringAlgoMethods.add("contains");
        stringAlgoMethods.add("startsWith");
        stringAlgoMethods.add("endsWith");
        stringAlgoMethods.add("substring");
    }
}

