/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldCouldBeLocal
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private ClassContext clsContext;
    private Map<String, FieldInfo> localizableFields;
    private CFG cfg;
    private ConstantPoolGen cpg;
    private BitSet visitedBlocks;

    public FieldCouldBeLocal(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            Field[] fields;
            this.localizableFields = new HashMap<String, FieldInfo>();
            this.visitedBlocks = new BitSet();
            this.clsContext = classContext;
            JavaClass cls = classContext.getJavaClass();
            for (Field f : fields = cls.getFields()) {
                if (f.isStatic() || f.getName().indexOf(36) >= 0 || !f.isPrivate()) continue;
                FieldAnnotation fa = new FieldAnnotation(cls.getClassName(), f.getName(), f.getSignature(), false);
                this.localizableFields.put(f.getName(), new FieldInfo(fa));
            }
            if (this.localizableFields.size() > 0) {
                super.visitClassContext(classContext);
                for (FieldInfo fi : this.localizableFields.values()) {
                    FieldAnnotation fa = fi.getFieldAnnotation();
                    SourceLineAnnotation sla = fi.getSrcLineAnnotation();
                    BugInstance bug = new BugInstance((Detector)this, "FCBL_FIELD_COULD_BE_LOCAL", 2).addClass((PreorderVisitor)this).addField(fa);
                    if (sla != null) {
                        bug.addSourceLine(sla);
                    }
                    this.bugReporter.reportBug(bug);
                }
            }
        }
        finally {
            this.localizableFields = null;
            this.visitedBlocks = null;
            this.clsContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(Method obj) {
        if (this.localizableFields.isEmpty()) {
            return;
        }
        String methodName = obj.getName();
        if ("<clinit>".equals(methodName) || "<init>".equals(methodName)) {
            return;
        }
        try {
            this.cpg = new ConstantPoolGen(this.getConstantPool());
            this.cfg = this.clsContext.getCFG(obj);
            BasicBlock bb = this.cfg.getEntry();
            HashSet<String> uncheckedFields = new HashSet<String>(this.localizableFields.keySet());
            this.visitedBlocks.clear();
            this.checkBlock(bb, uncheckedFields);
        }
        catch (CFGBuilderException cbe) {
            this.localizableFields.clear();
        }
        finally {
            this.cfg = null;
            this.cpg = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(181) || bytecodeSet.get(180));
    }

    public void visitCode(Code obj) {
        String methodName;
        Method m = this.getMethod();
        if (this.prescreen(m) && ("<clinit".equals(methodName = m.getName()) || "<init>".equals(methodName))) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        String fieldName;
        FieldInfo fi;
        if ((seen == 180 || seen == 181) && (fi = this.localizableFields.get(fieldName = this.getNameConstantOperand())) != null) {
            SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
            fi.setSrcLineAnnotation(sla);
        }
    }

    private void checkBlock(BasicBlock bb, Set<String> uncheckedFields) {
        LinkedList<BlockState> toBeProcessed = new LinkedList<BlockState>();
        toBeProcessed.add(new BlockState(bb, uncheckedFields));
        while (!toBeProcessed.isEmpty()) {
            if (this.localizableFields.isEmpty()) {
                return;
            }
            BlockState bState = (BlockState)toBeProcessed.removeFirst();
            bb = bState.getBasicBlock();
            uncheckedFields = bState.getUncheckedFields();
            this.visitedBlocks.set(bb.getLabel());
            BasicBlock.InstructionIterator ii = bb.instructionIterator();
            while (uncheckedFields.size() > 0 && ii.hasNext()) {
                InstructionHandle ih = ii.next();
                Instruction ins = ih.getInstruction();
                if (!(ins instanceof FieldInstruction)) continue;
                FieldInstruction fi = (FieldInstruction)ins;
                String fieldName = fi.getFieldName(this.cpg);
                boolean justRemoved = uncheckedFields.remove(fieldName);
                if (ins instanceof GETFIELD) {
                    if (!justRemoved) continue;
                    this.localizableFields.remove(fieldName);
                    if (!this.localizableFields.isEmpty()) continue;
                    return;
                }
                FieldInfo finfo = this.localizableFields.get(fieldName);
                if (finfo == null) continue;
                finfo.setSrcLineAnnotation(SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.clsContext, (PreorderVisitor)this, (int)ih.getPosition()));
            }
            if (uncheckedFields.size() <= 0) continue;
            Iterator oei = this.cfg.outgoingEdgeIterator((AbstractVertex)bb);
            while (oei.hasNext()) {
                Edge e = (Edge)oei.next();
                BasicBlock cb = (BasicBlock)e.getTarget();
                if (this.visitedBlocks.get(cb.getLabel())) continue;
                toBeProcessed.addLast(new BlockState(cb, uncheckedFields));
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockState {
        private final BasicBlock basicBlock;
        private final Set<String> uncheckedFields;

        public BlockState(BasicBlock bb, Set<String> fields) {
            this.basicBlock = bb;
            this.uncheckedFields = new HashSet<String>(fields);
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public Set<String> getUncheckedFields() {
            return this.uncheckedFields;
        }
    }

    private static class FieldInfo {
        private final FieldAnnotation fieldAnnotation;
        private SourceLineAnnotation srcLineAnnotation;

        public FieldInfo(FieldAnnotation fa) {
            this.fieldAnnotation = fa;
            this.srcLineAnnotation = null;
        }

        public void setSrcLineAnnotation(SourceLineAnnotation sla) {
            if (this.srcLineAnnotation == null) {
                this.srcLineAnnotation = sla;
            }
        }

        public FieldAnnotation getFieldAnnotation() {
            return this.fieldAnnotation;
        }

        public SourceLineAnnotation getSrcLineAnnotation() {
            return this.srcLineAnnotation;
        }
    }
}

