/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionSoftening
extends BytecodeScanningDetector {
    private static JavaClass runtimeClass;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, CodeException> catchHandlerPCs;
    private List<CatchInfo> catchInfos;
    private LocalVariableTable lvt;
    private Map<String, Set<String>> constrainingInfo;

    public ExceptionSoftening(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            if (runtimeClass != null) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            Method method = this.getMethod();
            if (this.prescreen(method)) {
                this.stack.resetForMethodEntry((DismantleBytecode)this);
                this.catchHandlerPCs = this.collectExceptions(obj.getExceptionTable());
                this.catchInfos = new ArrayList<CatchInfo>();
                this.lvt = method.getLocalVariableTable();
                this.constrainingInfo = null;
                super.visitCode(obj);
            }
        }
        finally {
            this.catchInfos = null;
            this.catchHandlerPCs = null;
            this.lvt = null;
            this.constrainingInfo = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block16: {
            try {
                this.stack.mergeJumps((DismantleBytecode)this);
                int pc = this.getPC();
                CodeException ex = this.catchHandlerPCs.get(Integer14.valueOf(pc));
                if (ex != null) {
                    int endPC = seen == 167 || seen == 200 ? this.getBranchTarget() : Integer.MAX_VALUE;
                    ConstantPool pool = this.getConstantPool();
                    ConstantClass ccls = (ConstantClass)pool.getConstant(ex.getCatchType());
                    String catchSig = ccls.getBytes(pool);
                    CatchInfo ci = new CatchInfo(ex.getHandlerPC(), endPC, catchSig);
                    this.catchInfos.add(ci);
                }
                this.updateEndPCsOnCatchRegScope(this.catchInfos, pc, seen);
                this.removeFinishedCatchBlocks(this.catchInfos, pc);
                if (seen != 191) break block16;
                try {
                    Set<String> possibleCatchSignatures;
                    OpcodeStack.Item itm;
                    JavaClass exClass;
                    if (this.stack.getStackDepth() > 0 && (exClass = (itm = this.stack.getStackItem(0)).getJavaClass()).instanceOf(runtimeClass) && this.catchInfos.size() > 0 && !(possibleCatchSignatures = this.findPossibleCatchSignatures(this.catchInfos, pc)).contains(exClass.getClassName())) {
                        boolean anyRuntimes = false;
                        for (String possibleCatches : possibleCatchSignatures) {
                            exClass = Repository.lookupClass((String)possibleCatches);
                            if (!exClass.instanceOf(runtimeClass)) continue;
                            anyRuntimes = true;
                            break;
                        }
                        if (!anyRuntimes) {
                            if (this.constrainingInfo == null) {
                                this.constrainingInfo = this.getConstrainingInfo(this.getClassContext().getJavaClass(), this.getMethod());
                            }
                            String bug = null;
                            int priority = 2;
                            if (this.constrainingInfo == null) {
                                bug = "EXS_EXCEPTION_SOFTENING_NO_CONSTRAINTS";
                                priority = 1;
                            } else if (!this.constrainingInfo.values().iterator().next().isEmpty()) {
                                bug = "EXS_EXCEPTION_SOFTENING_HAS_CHECKED";
                                priority = 2;
                            } else {
                                String pack1 = this.constrainingInfo.keySet().iterator().next();
                                String pack2 = this.getClassContext().getJavaClass().getClassName();
                                int dotPos = pack1.lastIndexOf(46);
                                if (SignatureUtils.similarPackages(pack1 = dotPos >= 0 ? pack1.substring(0, dotPos) : "", pack2 = (dotPos = pack2.lastIndexOf(46)) >= 0 ? pack2.substring(0, dotPos) : "", 2)) {
                                    bug = "EXS_EXCEPTION_SOFTENING_NO_CHECKED";
                                    priority = 2;
                                }
                            }
                            if (bug != null) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, bug, priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                        }
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                }
            }
            finally {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
            }
        }
    }

    private LinkedHashMap<Integer, CodeException> collectExceptions(CodeException[] exceptions) {
        ArrayList<CodeException> filteredEx = new ArrayList<CodeException>();
        for (CodeException ce : exceptions) {
            if (ce.getCatchType() == 0 || ce.getStartPC() >= ce.getEndPC() || ce.getEndPC() > ce.getHandlerPC()) continue;
            filteredEx.add(ce);
        }
        LinkedHashMap<Integer, CodeException> handlers = new LinkedHashMap<Integer, CodeException>();
        for (CodeException ex : filteredEx) {
            handlers.put(Integer14.valueOf(ex.getEndPC()), ex);
        }
        return handlers;
    }

    private void removeFinishedCatchBlocks(List<CatchInfo> catchInfos, int pc) {
        Iterator<CatchInfo> it = catchInfos.iterator();
        while (it.hasNext()) {
            if (it.next().getFinish() >= pc) continue;
            it.remove();
        }
    }

    private void updateEndPCsOnCatchRegScope(List<CatchInfo> catchInfos, int pc, int seen) {
        if (this.lvt != null) {
            for (CatchInfo ci : catchInfos) {
                if (ci.getStart() != pc || seen != 58 && (seen < 75 || seen > 78)) continue;
                int exReg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                LocalVariable lv = this.lvt.getLocalVariable(exReg, pc + 1);
                if (lv == null) break;
                ci.setFinish(lv.getStartPC() + lv.getLength());
                break;
            }
        }
    }

    public Set<String> findPossibleCatchSignatures(List<CatchInfo> catchInfos, int pc) {
        CatchInfo ci;
        HashSet<String> catchTypes = new HashSet<String>();
        ListIterator<CatchInfo> it = catchInfos.listIterator(catchInfos.size());
        while (it.hasPrevious() && pc >= (ci = it.previous()).getStart() && pc < ci.getFinish()) {
            catchTypes.add(ci.getSignature());
        }
        return catchTypes;
    }

    public Map<String, Set<String>> getConstrainingInfo(JavaClass cls, Method m) throws ClassNotFoundException {
        JavaClass[] infClasses;
        String methodName = m.getName();
        String methodSig = m.getSignature();
        for (JavaClass infCls : infClasses = cls.getInterfaces()) {
            Method infMethod = this.findMethod(infCls, methodName, methodSig);
            if (infMethod != null) {
                return this.buildConstrainingInfo(infCls, infMethod);
            }
            Map<String, Set<String>> constrainingExs = this.getConstrainingInfo(infCls, m);
            if (constrainingExs == null) continue;
            return constrainingExs;
        }
        JavaClass superCls = cls.getSuperClass();
        if (superCls != null) {
            Method superMethod = this.findMethod(superCls, methodName, methodSig);
            if (superMethod != null) {
                return this.buildConstrainingInfo(superCls, superMethod);
            }
            return this.getConstrainingInfo(superCls, m);
        }
        return null;
    }

    private Method findMethod(JavaClass cls, String methodName, String methodSig) {
        Method[] methods;
        for (Method method : methods = cls.getMethods()) {
            if (!method.getName().equals(methodName) || !method.getSignature().equals(methodSig)) continue;
            return method;
        }
        return null;
    }

    private Map<String, Set<String>> buildConstrainingInfo(JavaClass cls, Method m) throws ClassNotFoundException {
        HashMap<String, Set<String>> constraintInfo = new HashMap<String, Set<String>>();
        HashSet<String> exs = new HashSet<String>();
        ExceptionTable et = m.getExceptionTable();
        if (et != null) {
            int[] indexTable = et.getExceptionIndexTable();
            ConstantPool pool = cls.getConstantPool();
            for (int index : indexTable) {
                ConstantClass ccls;
                String exName;
                JavaClass exClass;
                if (index == 0 || (exClass = Repository.lookupClass((String)(exName = (ccls = (ConstantClass)pool.getConstant(index)).getBytes(pool)))).instanceOf(runtimeClass)) continue;
                exs.add(ccls.getBytes(pool));
            }
        }
        constraintInfo.put(cls.getClassName(), exs);
        return constraintInfo;
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(191);
    }

    static {
        try {
            runtimeClass = Repository.lookupClass((String)"java/lang/RuntimeException");
        }
        catch (ClassNotFoundException cnfe) {
            runtimeClass = null;
        }
    }

    private static class CatchInfo {
        private final int catchStart;
        private int catchFinish;
        private final String catchSignature;

        public CatchInfo(int start, int finish, String signature) {
            this.catchStart = start;
            this.catchFinish = finish;
            this.catchSignature = signature;
        }

        public int getStart() {
            return this.catchStart;
        }

        public void setFinish(int finish) {
            this.catchFinish = finish;
        }

        public int getFinish() {
            return this.catchFinish;
        }

        public String getSignature() {
            return this.catchSignature;
        }
    }
}

