/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class DubiousSetOfCollections
extends BytecodeScanningDetector {
    private static JavaClass collectionCls;
    private static JavaClass setCls;
    private static JavaClass mapCls;
    private final BugReporter bugReporter;
    private OpcodeStack stack;

    public DubiousSetOfCollections(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext clsContext) {
        try {
            if (collectionCls == null || setCls == null || mapCls == null) {
                return;
            }
            this.stack = new OpcodeStack();
            super.visitClassContext(clsContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code code) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            if (seen == 182 || seen == 185) {
                OpcodeStack.Item item;
                JavaClass entryCls;
                String clsName = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                String signature = this.getSigConstantOperand();
                if ("add".equals(methodName) && "(Ljava/lang/Object;)Z".equals(signature) && this.isImplementationOf(clsName, setCls)) {
                    OpcodeStack.Item item2;
                    JavaClass entryCls2;
                    if (this.stack.getStackDepth() > 1 && this.isImplementationOf(entryCls2 = (item2 = this.stack.getStackItem(0)).getJavaClass(), collectionCls)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "DSOC_DUBIOUS_SET_OF_COLLECTIONS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("put".equals(methodName) && "(Ljava/lang/Object;LJava/lang/Object;)Ljava/lang/Object;".equals(signature) && this.isImplementationOf(clsName, setCls) && this.stack.getStackDepth() > 2 && this.isImplementationOf(entryCls = (item = this.stack.getStackItem(1)).getJavaClass(), collectionCls)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "DSOC_DUBIOUS_SET_OF_COLLECTIONS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean isImplementationOf(String clsName, JavaClass inf) {
        try {
            if (clsName.startsWith("java/lang/")) {
                return false;
            }
            JavaClass cls = Repository.lookupClass((String)clsName);
            return this.isImplementationOf(cls, inf);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return false;
        }
    }

    private boolean isImplementationOf(JavaClass cls, JavaClass inf) {
        try {
            if (cls == null) {
                return false;
            }
            if (cls.implementationOf(inf)) {
                return true;
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        return false;
    }

    static {
        try {
            collectionCls = Repository.lookupClass((String)"java/util/Collection");
            setCls = Repository.lookupClass((String)"java/util/Set");
            mapCls = Repository.lookupClass((String)"java/util/Map");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

