/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class DubiousListCollection
extends BytecodeScanningDetector {
    private static Set<String> setMethods = new HashSet<String>();
    private static Set<String> listMethods = new HashSet<String>();
    private BugReporter bugReporter;
    private OpcodeStack stack = new OpcodeStack();
    private Map<String, FieldInfo> fieldsReported = new HashMap<String, FieldInfo>();

    public DubiousListCollection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Field[] flds;
        JavaClass cls = classContext.getJavaClass();
        Field[] arr$ = flds = cls.getFields();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field f = arr$[i$];
            String sig = f.getSignature();
            if (sig.charAt(0) != 'L' || !(sig = sig.substring(1, sig.length() - 1)).startsWith("java/util/") || !sig.endsWith("List")) continue;
            this.fieldsReported.put(f.getName(), new FieldInfo());
        }
        if (this.fieldsReported.size() > 0) {
            super.visitClassContext(classContext);
            this.reportBugs();
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            OpcodeStack.Item item;
            XField field;
            this.stack.mergeJumps((DismantleBytecode)this);
            if (seen == 185) {
                String fieldName;
                FieldInfo fi;
                String signature;
                XField field2;
                String className = this.getClassConstantOperand();
                if (className.startsWith("java/util/") && className.endsWith("List") && (field2 = this.getFieldFromStack(this.stack, signature = this.getSigConstantOperand())) != null && (fi = this.fieldsReported.get(fieldName = field2.getName())) != null) {
                    String methodName = this.getNameConstantOperand();
                    String methodInfo = methodName + signature;
                    if (listMethods.contains(methodInfo)) {
                        this.fieldsReported.remove(fieldName);
                    } else if (setMethods.contains(methodInfo)) {
                        fi.addUse(this.getPC());
                    }
                }
            } else if (seen == 182) {
                XField field3;
                String className = this.getClassConstantOperand();
                if (className.startsWith("java/util/") && className.endsWith("List") && (field3 = this.getFieldFromStack(this.stack, this.getSigConstantOperand())) != null) {
                    String fieldName = field3.getName();
                    this.fieldsReported.remove(fieldName);
                }
            } else if (seen == 176 && this.stack.getStackDepth() > 0 && (field = (item = this.stack.getStackItem(0)).getXField()) != null) {
                String fieldName = field.getName();
                this.fieldsReported.remove(fieldName);
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private XField getFieldFromStack(OpcodeStack stk, String signature) {
        int parmCount = Type.getArgumentTypes((String)signature).length;
        if (stk.getStackDepth() > parmCount) {
            OpcodeStack.Item itm = stk.getStackItem(parmCount);
            return itm.getXField();
        }
        return null;
    }

    private void reportBugs() {
        int major = this.getClassContext().getJavaClass().getMajor();
        Iterator<Map.Entry<String, FieldInfo>> i$ = this.fieldsReported.entrySet().iterator();
        while (i$.hasNext()) {
            FieldAnnotation fa;
            Map.Entry<String, FieldInfo> entry = i$.next();
            String field = entry.getKey();
            FieldInfo fi = entry.getValue();
            int cnt = fi.getSetCount();
            if (cnt <= 0 || (fa = this.getFieldAnnotation(field)) == null) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DLC_DUBIOUS_LIST_COLLECTION", major >= 48 ? 2 : 3).addClass((PreorderVisitor)this).addField(fa).addSourceLine(fi.getSourceLineAnnotation()));
        }
    }

    private FieldAnnotation getFieldAnnotation(String fieldName) {
        Field[] fields;
        JavaClass cls = this.getClassContext().getJavaClass();
        Field[] arr$ = fields = cls.getFields();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field f = arr$[i$];
            if (!f.getName().equals(fieldName)) continue;
            return new FieldAnnotation(cls.getClassName(), fieldName, f.getSignature(), (f.getAccessFlags() & 8) != 0);
        }
        return null;
    }

    static {
        setMethods.add("contains(Ljava/lang/Object;)Z");
        setMethods.add("containsAll(Ljava/util/Collection;)Z");
        setMethods.add("remove(Ljava/lang/Object;)Ljava/lang/Object;");
        setMethods.add("removeAll(Ljava/util/Collection;)Z");
        setMethods.add("retainAll(Ljava/util/Collection;)Z");
        listMethods.add("add(ILjava/lang/Object;)V");
        listMethods.add("addAll(ILjava/util/Collection;)Z");
        listMethods.add("lastIndexOf(Ljava/lang/Object;)I");
        listMethods.add("remove(I)Ljava/lang/Object;");
        listMethods.add("set(ILjava/lang/Object;)Ljava/lang/Object;");
        listMethods.add("subList(II)Ljava/util/List;");
        listMethods.add("listIterator()Ljava/util/ListIterator;");
        listMethods.add("listIterator(I)Ljava/util/ListIterator;");
    }

    class FieldInfo {
        private int setCnt = 0;
        private SourceLineAnnotation slAnnotation = null;

        public void addUse(int pc) {
            ++this.setCnt;
            if (this.slAnnotation == null) {
                this.slAnnotation = SourceLineAnnotation.fromVisitedInstruction((ClassContext)DubiousListCollection.this.getClassContext(), (PreorderVisitor)DubiousListCollection.this, (int)pc);
            }
        }

        public SourceLineAnnotation getSourceLineAnnotation() {
            return this.slAnnotation;
        }

        public int getSetCount() {
            return this.setCnt;
        }
    }
}

