/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class DeprecatedTypesafeEnumPattern
extends BytecodeScanningDetector {
    private static final int SAW_NOTHING = 0;
    private static final int SAW_INVOKESPECIAL = 1;
    private static final int SAW_BUG = 2;
    private final BugReporter bugReporter;
    private int firstEnumPC;
    private int enumCount;
    private Set<String> enumConstNames;
    int state;

    public DeprecatedTypesafeEnumPattern(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext context) {
        try {
            JavaClass cls = context.getJavaClass();
            if (!cls.isEnum() && cls.getMajor() >= 49) {
                Method[] methods;
                Method[] arr$ = methods = cls.getMethods();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Method m = arr$[i$];
                    if (!"<init>".equals(m.getName()) || (m.getAccessFlags() & 2) != 0) continue;
                    return;
                }
                this.firstEnumPC = 0;
                this.enumCount = 0;
                this.enumConstNames = new HashSet<String>();
                super.visitClassContext(context);
            }
        }
        finally {
            this.enumConstNames = null;
        }
    }

    public void visitField(Field obj) {
        int accessFlags = obj.getAccessFlags();
        if ((accessFlags & 8) != 0 && (accessFlags & 1) != 0 && (accessFlags & 0x10) != 0) {
            String clsClass;
            String fieldClass;
            JavaClass cls = this.getClassContext().getJavaClass();
            if (!obj.isEnum() && (fieldClass = obj.getSignature()).startsWith("L") && (fieldClass = fieldClass.substring(1, fieldClass.length() - 1)).equals(clsClass = cls.getClassName())) {
                this.enumConstNames.add(obj.getName());
                super.visitField(obj);
            }
        }
    }

    public void visitCode(Code obj) {
        if ("<clinit>".equals(this.getMethod().getName())) {
            this.state = 0;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (this.state == 0) {
            if (seen == 183) {
                this.state = 1;
            }
        } else if (this.state == 1) {
            String fieldName;
            if (seen == 179 && this.enumConstNames.contains(fieldName = this.getNameConstantOperand())) {
                if (this.enumCount == 0) {
                    this.firstEnumPC = this.getPC();
                }
                ++this.enumCount;
                if (this.enumCount >= 2) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "DTEP_DEPRECATED_TYPESAFE_ENUM_PATTERN", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.firstEnumPC));
                    this.state = 2;
                }
            }
            if (this.state != 2) {
                this.state = 0;
            }
        }
    }
}

