/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.Method;

public class ConstantListIndex
extends BytecodeScanningDetector {
    private static final String MAX_ICONST0_LOOP_DISTANCE_PROPERTY = "fb-contrib.cli.maxloopdistance";
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_CONSTANT_0 = 1;
    private static final int SEEN_CONSTANT = 2;
    private static final Set<String> ubiquitousMethods = new HashSet<String>();
    private final BugReporter bugReporter;
    private int state;
    private Set<Integer> iConst0Looped;
    private final int max_iConst0LoopDistance;
    private OpcodeStack stack;

    public ConstantListIndex(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.max_iConst0LoopDistance = Integer.getInteger(MAX_ICONST0_LOOP_DISTANCE_PROPERTY, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.iConst0Looped = new HashSet<Integer>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.iConst0Looped = null;
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.state = 0;
        this.iConst0Looped.clear();
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            switch (this.state) {
                case 0: {
                    Constant c;
                    if (seen == 3) {
                        this.state = 1;
                        break;
                    }
                    if (seen >= 4 && seen <= 8) {
                        this.state = 2;
                        break;
                    }
                    if (seen != 18 && seen != 19 || !((c = this.getConstantRefOperand()) instanceof ConstantInteger)) break;
                    this.state = 2;
                    break;
                }
                case 1: 
                case 2: {
                    switch (seen) {
                        case 50: {
                            if ("main".equals(this.getMethodName())) break;
                        }
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 53: {
                            OpcodeStack.Item item;
                            if (this.state == 1) {
                                this.iConst0Looped.add(Integer14.valueOf(this.getPC()));
                                break;
                            }
                            if (this.stack.getStackDepth() <= 1 || this.isArrayFromUbiquitousMethod(item = this.stack.getStackItem(1))) break;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "CLI_CONSTANT_LIST_INDEX", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                        case 182: {
                            String methodName;
                            if (!"java/util/List".equals(this.getClassConstantOperand()) || !"get".equals(methodName = this.getNameConstantOperand())) break;
                            if (this.state == 1) {
                                this.iConst0Looped.add(Integer14.valueOf(this.getPC()));
                                break;
                            }
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "CLI_CONSTANT_LIST_INDEX", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                    this.state = 0;
                }
            }
            if (seen >= 153 && seen <= 167 || seen == 200) {
                int branchTarget = this.getBranchTarget();
                Iterator<Integer> it = this.iConst0Looped.iterator();
                while (it.hasNext()) {
                    int bugPC = it.next();
                    if (branchTarget >= bugPC) continue;
                    if (bugPC - branchTarget < this.max_iConst0LoopDistance) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "CLI_CONSTANT_LIST_INDEX", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, bugPC));
                    }
                    it.remove();
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean isArrayFromUbiquitousMethod(OpcodeStack.Item item) {
        XMethod method = item.getReturnValueOf();
        if (method == null) {
            return false;
        }
        String methodDesc = method.getClassName() + '.' + method.getName() + method.getSignature();
        return ubiquitousMethods.contains(methodDesc);
    }

    static {
        ubiquitousMethods.add("java.lang.String.split(Ljava/lang/String;)[Ljava/lang/String;");
    }
}

