/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassEnvy
extends BytecodeScanningDetector {
    private static final String ENVY_PERCENT_PROPERTY = "fb-contrib.ce.percent";
    private static final Set<String> ignorableInterfaces = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String packageName;
    private String clsName;
    private Map<String, Set<Integer>> clsAccessCount;
    private int thisClsAccessCount;
    private String methodName;
    private boolean methodIsStatic;
    private double envyPercent = 0.9;
    private int envyMin = 5;

    public ClassEnvy(BugReporter bugReporter) {
        Integer min;
        this.bugReporter = bugReporter;
        String percent = System.getProperty(ENVY_PERCENT_PROPERTY);
        if (percent != null) {
            try {
                this.envyPercent = Double.parseDouble(percent);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((min = Integer.getInteger("ENVY_MIN_PROPERTY")) != null) {
            this.envyMin = min;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls = classContext.getJavaClass();
            this.packageName = cls.getPackageName();
            this.clsName = cls.getClassName();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.clsAccessCount = null;
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        this.methodIsStatic = (obj.getAccessFlags() & 8) != 0;
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.thisClsAccessCount = 0;
        if ("<clinit>".equals(this.methodName)) {
            return;
        }
        this.clsAccessCount = new HashMap<String, Set<Integer>>();
        super.visitCode(obj);
        if (this.clsAccessCount.size() > 0) {
            Map.Entry[] envies = this.clsAccessCount.entrySet().toArray(new Map.Entry[this.clsAccessCount.size()]);
            Arrays.sort(envies, new Comparator<Map.Entry<String, Set<Integer>>>(){

                @Override
                public int compare(Map.Entry<String, Set<Integer>> entry1, Map.Entry<String, Set<Integer>> entry2) {
                    return entry2.getValue().size() - entry1.getValue().size();
                }

                @Override
                public /* synthetic */ int compare(Object x0, Object x1) {
                    return this.compare((Map.Entry)x0, (Map.Entry)x1);
                }
            });
            Map.Entry bestEnvyEntry = envies[0];
            int bestEnvyCount = ((Set)bestEnvyEntry.getValue()).size();
            if (bestEnvyCount < this.envyMin) {
                return;
            }
            String bestEnvy = (String)bestEnvyEntry.getKey();
            double bestPercent = (double)bestEnvyCount / (double)(bestEnvyCount + this.thisClsAccessCount);
            if (bestPercent > this.envyPercent) {
                if (this.implementsCommonInterface(bestEnvy)) {
                    return;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CE_CLASS_ENVY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLineRange((BytecodeScanningDetector)this, 0, obj.getCode().length - 1).addString(bestEnvy));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            if (seen == 182 || seen == 185 || seen == 184 || seen == 183) {
                String calledClass = this.getClassConstantOperand().replace('/', '.');
                if (seen == 185) {
                    int parmCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                    if (!this.countClassAccess(parmCount)) {
                        this.countClassAccess(calledClass);
                    }
                } else {
                    this.countClassAccess(calledClass);
                }
            } else if (seen == 181) {
                this.countClassAccess(1);
            } else if (seen == 180) {
                this.countClassAccess(0);
            } else if (seen == 42 && !this.methodIsStatic) {
                this.countClassAccess(this.clsName);
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean implementsCommonInterface(String name) {
        try {
            JavaClass[] infs;
            JavaClass cls = Repository.lookupClass((String)name);
            for (JavaClass inf : infs = cls.getAllInterfaces()) {
                String infName = inf.getClassName();
                if (ignorableInterfaces.contains(infName) || !infName.startsWith("java.")) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return true;
        }
    }

    private boolean countClassAccess(int classAtStackIndex) {
        try {
            OpcodeStack.Item itm;
            JavaClass cls;
            if (this.stack.getStackDepth() > classAtStackIndex && (cls = (itm = this.stack.getStackItem(classAtStackIndex)).getJavaClass()) != null) {
                String calledClass = cls.getClassName();
                this.countClassAccess(calledClass);
                return true;
            }
        }
        catch (ClassNotFoundException cfne) {
            this.bugReporter.reportMissingClass(cfne);
        }
        return false;
    }

    private void countClassAccess(String calledClass) {
        if (calledClass.equals(this.clsName)) {
            ++this.thisClsAccessCount;
        } else {
            String calledPackage = SignatureUtils.getPackageName(calledClass);
            if (SignatureUtils.similarPackages(calledPackage, this.packageName, 2) && !this.generalPurpose(calledClass)) {
                Set<Integer> lineNumbers = this.clsAccessCount.get(calledClass);
                if (lineNumbers == null) {
                    lineNumbers = new HashSet<Integer>();
                    this.addLineNumber(lineNumbers);
                    this.clsAccessCount.put(calledClass, lineNumbers);
                } else {
                    this.addLineNumber(lineNumbers);
                }
            }
        }
    }

    private void addLineNumber(Set<Integer> lineNumbers) {
        LineNumberTable lnt = this.getCode().getLineNumberTable();
        if (lnt == null) {
            lineNumbers.add(Integer14.valueOf(-lineNumbers.size()));
        } else {
            int line = lnt.getSourceLine(this.getPC());
            if (line < 0) {
                lineNumbers.add(Integer14.valueOf(lineNumbers.size()));
            } else {
                lineNumbers.add(Integer14.valueOf(line));
            }
        }
    }

    private boolean generalPurpose(String className) {
        if (className.startsWith("java.") || className.startsWith("javax.")) {
            return true;
        }
        try {
            JavaClass[] sups;
            JavaClass[] infs;
            JavaClass cls = Repository.lookupClass((String)className);
            for (JavaClass inf : infs = cls.getAllInterfaces()) {
                String infName = inf.getClassName();
                if ("java.io.Serializable".equals(infName) || "java.lang.Cloneable".equals(infName) || "java.lang.Comparable".equals(infName) || "java.lang.Runnable".equals(infName) || !infName.startsWith("java.lang.") && !infName.startsWith("javax.lang.")) continue;
                return true;
            }
            for (JavaClass sup : sups = cls.getSuperClasses()) {
                String supName = sup.getClassName();
                if ("java.lang.Object".equals(supName) || "java.lang.Exception".equals(supName) || "java.lang.RuntimeException".equals(supName) || "java.lang.Throwable".equals(supName) || !supName.startsWith("java.lang.") && !supName.startsWith("javax.lang.")) continue;
                return true;
            }
        }
        catch (ClassNotFoundException cfne) {
            this.bugReporter.reportMissingClass(cfne);
            return true;
        }
        return false;
    }

    static {
        ignorableInterfaces.add("java.io.Serializable");
        ignorableInterfaces.add("java.lang.Cloneable");
        ignorableInterfaces.add("java.lang.Comparable");
    }
}

