/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BogusExceptionDeclaration
extends BytecodeScanningDetector {
    private static JavaClass runtimeExceptionClass;
    private static final Set<String> safeClasses;
    private final BugReporter bugReporter;
    private Set<String> declaredCheckedExceptions;

    public BogusExceptionDeclaration(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            if (runtimeExceptionClass != null) {
                this.declaredCheckedExceptions = new HashSet<String>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.declaredCheckedExceptions = null;
        }
    }

    public void visitCode(Code obj) {
        ExceptionTable et;
        this.declaredCheckedExceptions.clear();
        Method method = this.getMethod();
        if ((method.isStatic() || method.isPrivate() || "<init>".equals(method.getName())) && (et = method.getExceptionTable()) != null) {
            String[] exNames;
            String[] arr$ = exNames = et.getExceptionNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String exName = arr$[i$];
                try {
                    JavaClass exCls = Repository.lookupClass((String)exName);
                    if (exCls.instanceOf(runtimeExceptionClass)) continue;
                    this.declaredCheckedExceptions.add(exName);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                }
            }
            if (!this.declaredCheckedExceptions.isEmpty()) {
                super.visitCode(obj);
                if (!this.declaredCheckedExceptions.isEmpty()) {
                    BugInstance bi = new BugInstance((Detector)this, "BED_BOGUS_EXCEPTION_DECLARATION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0);
                    Iterator<String> i$ = this.declaredCheckedExceptions.iterator();
                    while (i$.hasNext()) {
                        String ex = i$.next();
                        bi.addString(ex.replaceAll("/", "."));
                    }
                    this.bugReporter.reportBug(bi);
                }
            }
        }
    }

    public void sawOpcode(int seen) {
        String clsName;
        if (this.declaredCheckedExceptions.isEmpty()) {
            return;
        }
        if (!(seen != 182 && seen != 185 && seen != 183 && seen != 184 || safeClasses.contains(clsName = this.getClassConstantOperand()))) {
            try {
                JavaClass cls = Repository.lookupClass((String)clsName);
                Method[] methods = cls.getMethods();
                String methodName = this.getNameConstantOperand();
                String signature = this.getSigConstantOperand();
                boolean found = false;
                Method[] arr$ = methods;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Method m = arr$[i$];
                    if (!m.getName().equals(methodName) || !m.getSignature().equals(signature)) continue;
                    ExceptionTable et = m.getExceptionTable();
                    if (et != null) {
                        String[] thrownExceptions;
                        String[] arr$2 = thrownExceptions = et.getExceptionNames();
                        int len$2 = arr$2.length;
                        for (int i$2 = 0; i$2 < len$2; ++i$2) {
                            String thrownException = arr$2[i$2];
                            this.declaredCheckedExceptions.remove(thrownException);
                            JavaClass exCls = Repository.lookupClass((String)thrownException);
                            JavaClass superCls = exCls.getSuperClass();
                            while ((exCls = superCls) != null) {
                                this.declaredCheckedExceptions.remove(exCls.getClassName());
                                superCls = exCls.getSuperClass();
                                if (!this.declaredCheckedExceptions.isEmpty() && !"java.lang.Exception".equals(exCls.getClassName()) && !"java.lang.Error".equals(exCls.getClassName())) continue;
                            }
                        }
                    } else {
                        this.declaredCheckedExceptions.clear();
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    this.declaredCheckedExceptions.clear();
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
                this.declaredCheckedExceptions.clear();
            }
        }
    }

    static {
        safeClasses = new HashSet<String>();
        try {
            safeClasses.add("java/lang/Object");
            safeClasses.add("java/lang/String");
            safeClasses.add("java/lang/Integer");
            safeClasses.add("java/lang/Long");
            safeClasses.add("java/lang/Float");
            safeClasses.add("java/lang/Double");
            safeClasses.add("java/lang/Short");
            safeClasses.add("java/lang/Boolean");
            runtimeExceptionClass = Repository.lookupClass((String)"java/lang/RuntimeException");
        }
        catch (ClassNotFoundException cnfe) {
            runtimeExceptionClass = null;
        }
    }
}

