/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class BloatedSynchronizedBlock
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private static final String BSB_MIN_SAFE_CODE_SIZE = "fb-contrib.bsb.minsize";
    private OpcodeStack stack;
    private Set<Integer> unsafeAliases;
    private Map<Integer, Integer> branchInfo;
    private int syncPC;
    private boolean isStatic;
    private final int minSafeCodeLength;
    private boolean unsafeCallOccurred;

    public BloatedSynchronizedBlock(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.minSafeCodeLength = Integer.getInteger(BSB_MIN_SAFE_CODE_SIZE, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.unsafeAliases = new HashSet<Integer>();
            this.branchInfo = new HashMap<Integer, Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.unsafeAliases = null;
            this.branchInfo = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(194);
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (this.prescreen(m)) {
            this.syncPC = m.isSynchronized() ? 0 : -1;
            this.isStatic = m.isStatic();
            this.unsafeAliases.clear();
            this.unsafeAliases.add(Integer14.valueOf(0));
            this.branchInfo.clear();
            this.unsafeCallOccurred = false;
            this.stack.resetForMethodEntry((DismantleBytecode)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            int storeReg;
            this.stack.mergeJumps((DismantleBytecode)this);
            if (this.unsafeCallOccurred && (seen == 58 || seen >= 75 && seen <= 78) && (storeReg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen)) >= 0) {
                this.unsafeAliases.add(Integer14.valueOf(storeReg));
            }
            if (seen == 182 || seen == 183 || seen == 185) {
                String methodSig = this.getSigConstantOperand();
                Type returnType = Type.getReturnType((String)methodSig);
                if (!returnType.equals((Object)Type.VOID)) {
                    int parmCount = Type.getArgumentTypes((String)methodSig).length;
                    if (this.stack.getStackDepth() > parmCount) {
                        OpcodeStack.Item itm = this.stack.getStackItem(parmCount);
                        this.unsafeCallOccurred = this.unsafeAliases.contains(Integer14.valueOf(itm.getRegisterNumber()));
                    } else {
                        this.unsafeCallOccurred = false;
                    }
                } else {
                    this.unsafeCallOccurred = false;
                }
            } else if (seen == 184) {
                this.unsafeCallOccurred = this.getDottedClassConstantOperand().equals(this.getClassContext().getJavaClass().getClassName());
            } else if (seen >= 153 && seen <= 167 || seen == 200) {
                Integer from = Integer14.valueOf(this.getPC());
                Integer to = Integer14.valueOf(this.getBranchTarget());
                this.branchInfo.put(from, to);
                this.unsafeCallOccurred = false;
            } else {
                this.unsafeCallOccurred = false;
            }
            if (seen == 194) {
                if (this.syncPC < 0) {
                    OpcodeStack.Item itm;
                    int monitorReg;
                    this.syncPC = this.getPC();
                    if (this.stack.getStackDepth() > 0 && (monitorReg = (itm = this.stack.getStackItem(0)).getRegisterNumber()) >= 0) {
                        this.unsafeAliases.add(Integer14.valueOf(monitorReg));
                    }
                }
            } else if (seen == 195) {
                this.syncPC = -1;
            } else if (this.syncPC >= 0) {
                boolean unsafe = this.unsafeCallOccurred;
                unsafe |= seen == 181 || seen == 180 || seen == 178 || seen == 179;
                unsafe |= !this.isStatic && (seen == 42 || seen == 75);
                int aloadReg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                if (unsafe |= aloadReg >= 0 && this.unsafeAliases.contains(Integer14.valueOf(aloadReg))) {
                    int pc = this.getPC();
                    if (pc - this.syncPC > this.minSafeCodeLength) {
                        Iterator<Map.Entry<Integer, Integer>> i$ = this.branchInfo.entrySet().iterator();
                        while (i$.hasNext()) {
                            int bEnd;
                            Map.Entry<Integer, Integer> entry = i$.next();
                            int bStart = entry.getKey();
                            if (bStart < this.syncPC || bStart > pc || (bEnd = entry.getValue().intValue()) <= pc) continue;
                            pc = bStart - 1;
                        }
                        if (pc - this.syncPC > this.minSafeCodeLength) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "BSB_BLOATED_SYNCHRONIZED_BLOCK", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLineRange((BytecodeScanningDetector)this, this.syncPC + 1, pc));
                        }
                    }
                    this.syncPC = -1;
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }
}

