/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BloatedAssignmentScope
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<Integer> ignoreRegs;
    private ScopeBlock rootScopeBlock;
    private Set<Integer> catchHandlers;
    private Set<Integer> switchTargets;
    private List<Integer> monitorSyncPCs;
    private boolean dontReport;
    private boolean sawDup;
    private boolean sawNull;

    public BloatedAssignmentScope(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.ignoreRegs = new HashSet<Integer>();
            this.catchHandlers = new HashSet<Integer>();
            this.switchTargets = new HashSet<Integer>();
            this.monitorSyncPCs = new ArrayList<Integer>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.ignoreRegs = null;
            this.catchHandlers = null;
            this.switchTargets = null;
            this.monitorSyncPCs = null;
            this.stack = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            int[] parmRegs;
            this.ignoreRegs.clear();
            Method method = this.getMethod();
            if (!method.isStatic()) {
                this.ignoreRegs.add(Integer14.valueOf(0));
            }
            for (int parm : parmRegs = RegisterUtils.getParameterRegisters(method)) {
                this.ignoreRegs.add(Integer14.valueOf(parm));
            }
            this.rootScopeBlock = new ScopeBlock(0, obj.getLength());
            this.catchHandlers.clear();
            CodeException[] exceptions = obj.getExceptionTable();
            if (exceptions != null) {
                for (CodeException ex : exceptions) {
                    this.catchHandlers.add(Integer14.valueOf(ex.getHandlerPC()));
                }
            }
            this.switchTargets.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.dontReport = false;
            this.sawDup = false;
            this.sawNull = false;
            super.visitCode(obj);
            if (!this.dontReport) {
                this.rootScopeBlock.findBugs(new HashSet<Integer>());
            }
        }
        finally {
            this.rootScopeBlock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        Comparable<?> caller = null;
        try {
            if (seen == 58 || seen == 54 || seen == 55 || seen == 56 || seen == 57 || seen >= 75 && seen <= 78 || seen >= 59 && seen <= 62 || seen >= 63 && seen <= 64 || seen >= 67 && seen <= 68 || seen >= 71 && seen <= 72) {
                int reg = RegisterUtils.getStoreReg((DismantleBytecode)this, seen);
                Integer iReg = Integer14.valueOf(reg);
                int pc = this.getPC();
                if (this.catchHandlers.contains(Integer14.valueOf(pc))) {
                    this.ignoreRegs.add(iReg);
                } else if (this.monitorSyncPCs.size() > 0) {
                    this.ignoreRegs.add(iReg);
                } else if (this.sawNull) {
                    this.ignoreRegs.add(iReg);
                }
                if (!this.ignoreRegs.contains(iReg)) {
                    ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, pc);
                    if (sb != null) {
                        Object assoc = null;
                        if (this.stack.getStackDepth() > 0) {
                            assoc = this.stack.getStackItem(0).getUserValue();
                        }
                        sb.addStore(reg, pc, assoc);
                        if (this.sawDup) {
                            sb.addLoad(reg, pc);
                        }
                    } else {
                        this.ignoreRegs.add(iReg);
                    }
                }
            } else if (seen == 132) {
                int pc;
                int reg = this.getRegisterOperand();
                Integer iReg = Integer14.valueOf(reg);
                if (!this.ignoreRegs.contains(iReg)) {
                    ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, this.getPC());
                    if (sb != null) {
                        sb.addLoad(reg, this.getPC());
                    } else {
                        this.ignoreRegs.add(iReg);
                    }
                }
                if (this.catchHandlers.contains(Integer14.valueOf(pc = this.getPC()))) {
                    this.ignoreRegs.add(iReg);
                } else if (this.monitorSyncPCs.size() > 0) {
                    this.ignoreRegs.add(iReg);
                } else if (this.sawNull) {
                    this.ignoreRegs.add(iReg);
                }
                if (!this.ignoreRegs.contains(iReg)) {
                    ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, pc);
                    if (sb != null) {
                        sb.addStore(reg, pc, null);
                        if (this.sawDup) {
                            sb.addLoad(reg, pc);
                        }
                    } else {
                        this.ignoreRegs.add(iReg);
                    }
                }
            } else if (seen == 25 || seen == 21 || seen == 22 || seen == 23 || seen == 24 || seen >= 42 && seen <= 45 || seen >= 26 && seen <= 29 || seen >= 30 && seen <= 31 || seen >= 34 && seen <= 35 || seen >= 38 && seen <= 39) {
                int reg = RegisterUtils.getLoadReg((DismantleBytecode)this, seen);
                if (!this.ignoreRegs.contains(Integer14.valueOf(reg))) {
                    ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, this.getPC());
                    if (sb != null) {
                        sb.addLoad(reg, this.getPC());
                    } else {
                        this.ignoreRegs.add(Integer14.valueOf(reg));
                    }
                }
            } else if (seen >= 153 && seen <= 167 || seen == 200) {
                int target = this.getBranchTarget();
                if (target > this.getPC()) {
                    if (seen == 167 || seen == 200) {
                        Integer nextPC = Integer14.valueOf(this.getNextPC());
                        if (!this.switchTargets.contains(nextPC)) {
                            ScopeBlock sb = this.findScopeBlockWithTarget(this.rootScopeBlock, this.getPC(), this.getNextPC());
                            if (sb == null) {
                                sb = new ScopeBlock(this.getPC(), target);
                                sb.setLoop();
                                sb.setGoto();
                                this.rootScopeBlock.addChild(sb);
                            } else {
                                sb = new ScopeBlock(this.getPC(), target);
                                sb.setGoto();
                                this.rootScopeBlock.addChild(sb);
                            }
                        }
                    } else {
                        ScopeBlock sb = this.findScopeBlockWithTarget(this.rootScopeBlock, this.getPC(), target);
                        if (sb != null && !sb.isLoop && !sb.hasChildren()) {
                            if (sb.isGoto()) {
                                ScopeBlock parent = sb.getParent();
                                sb.pushUpLoadStores();
                                if (parent != null) {
                                    parent.removeChild(sb);
                                }
                                sb = new ScopeBlock(this.getPC(), target);
                                this.rootScopeBlock.addChild(sb);
                            } else {
                                sb.pushUpLoadStores();
                                sb.setStart(this.getPC());
                                sb.setFinish(target);
                            }
                        } else {
                            sb = new ScopeBlock(this.getPC(), target);
                            this.rootScopeBlock.addChild(sb);
                        }
                    }
                } else {
                    ScopeBlock sb = this.findScopeBlock(this.rootScopeBlock, this.getPC());
                    if (sb != null) {
                        sb.setLoop();
                    }
                }
            } else if (seen == 170 || seen == 171) {
                int pc = this.getPC();
                int[] offsets = this.getSwitchOffsets();
                ArrayList<Integer> targets = new ArrayList<Integer>();
                for (int offset : offsets) {
                    targets.add(Integer14.valueOf(offset + pc));
                }
                Integer defOffset = Integer14.valueOf(this.getDefaultSwitchOffset() + pc);
                if (!targets.contains(defOffset)) {
                    targets.add(defOffset);
                }
                Collections.sort(targets);
                Integer lastTarget = (Integer)targets.get(0);
                for (int i = 1; i < targets.size(); ++i) {
                    Integer nextTarget = (Integer)targets.get(i);
                    ScopeBlock sb = new ScopeBlock(lastTarget, nextTarget);
                    this.rootScopeBlock.addChild(sb);
                    lastTarget = nextTarget;
                }
                this.switchTargets.addAll(targets);
            } else if (seen == 182 || seen == 185) {
                ScopeBlock sb;
                if ("wasNull".equals(this.getNameConstantOperand()) && "()Z".equals(this.getSigConstantOperand())) {
                    this.dontReport = true;
                }
                if ((caller = this.getCallingObject()) != null && (sb = this.findScopeBlock(this.rootScopeBlock, this.getPC())) != null) {
                    sb.removeByAssoc(caller);
                }
            } else if (seen == 194) {
                this.monitorSyncPCs.add(Integer14.valueOf(this.getPC()));
            } else if (seen == 195 && this.monitorSyncPCs.size() > 0) {
                this.monitorSyncPCs.remove(this.monitorSyncPCs.size() - 1);
            }
            this.sawDup = seen == 89;
            this.sawNull = seen == 1;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (caller != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(caller);
            }
        }
    }

    private Comparable<?> getCallingObject() {
        String sig = this.getSigConstantOperand();
        if ("V".equals(Type.getReturnType((String)sig).getSignature())) {
            return null;
        }
        Type[] types = Type.getArgumentTypes((String)sig);
        if (this.stack.getStackDepth() <= types.length) {
            return null;
        }
        OpcodeStack.Item caller = this.stack.getStackItem(types.length);
        int reg = caller.getRegisterNumber();
        if (reg >= 0) {
            return reg;
        }
        XField f = caller.getXField();
        if (f != null) {
            return f.getName();
        }
        return null;
    }

    private ScopeBlock findScopeBlock(ScopeBlock sb, int pc) {
        if (pc > sb.getStart() && pc < sb.getFinish()) {
            if (sb.children != null) {
                for (ScopeBlock child : sb.children) {
                    ScopeBlock foundSb = this.findScopeBlock(child, pc);
                    if (foundSb == null) continue;
                    return foundSb;
                }
            }
            return sb;
        }
        return null;
    }

    private ScopeBlock findScopeBlockWithTarget(ScopeBlock sb, int start, int target) {
        ScopeBlock parentBlock = null;
        if (sb.startLocation < start && sb.finishLocation >= start && (sb.finishLocation <= target || sb.isGoto() && !sb.isLoop())) {
            parentBlock = sb;
        }
        if (sb.children != null) {
            for (ScopeBlock child : sb.children) {
                ScopeBlock targetBlock = this.findScopeBlockWithTarget(child, start, target);
                if (targetBlock == null) continue;
                return targetBlock;
            }
        }
        return parentBlock;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScopeBlock {
        private ScopeBlock parent = null;
        private int startLocation;
        private int finishLocation;
        private boolean isLoop;
        private boolean isGoto;
        private Map<Integer, Integer> loads;
        private Map<Integer, Integer> stores;
        private Map<Object, Integer> assocs;
        private List<ScopeBlock> children;

        public ScopeBlock(int start, int finish) {
            this.startLocation = start;
            this.finishLocation = finish;
            this.isLoop = false;
            this.isGoto = false;
            this.loads = null;
            this.stores = null;
            this.assocs = null;
            this.children = null;
        }

        public String toString() {
            return new StringBuffer().append("Start=").append(this.startLocation).append(" Finish=").append(this.finishLocation).append(" Loop=").append(this.isLoop).append(" Loads=").append(this.loads).append(" Stores=").append(this.stores).toString();
        }

        public ScopeBlock getParent() {
            return this.parent;
        }

        public int getStart() {
            return this.startLocation;
        }

        public int getFinish() {
            return this.finishLocation;
        }

        public void setStart(int start) {
            this.startLocation = start;
        }

        public void setFinish(int finish) {
            this.finishLocation = finish;
        }

        public boolean hasChildren() {
            return this.children != null;
        }

        public void setLoop() {
            this.isLoop = true;
        }

        public boolean isLoop() {
            return this.isLoop;
        }

        public void setGoto() {
            this.isGoto = true;
        }

        public boolean isGoto() {
            return this.isGoto;
        }

        public void addStore(int reg, int pc, Object assocObject) {
            if (this.stores == null) {
                this.stores = new HashMap<Integer, Integer>();
            }
            this.stores.put(Integer14.valueOf(reg), Integer14.valueOf(pc));
            if (this.assocs == null) {
                this.assocs = new HashMap<Object, Integer>();
            }
            this.assocs.put(assocObject, Integer14.valueOf(reg));
        }

        public void removeByAssoc(Object assocObject) {
            Integer reg;
            if (this.assocs != null && (reg = this.assocs.remove(assocObject)) != null) {
                if (this.loads != null) {
                    this.loads.remove(reg);
                }
                if (this.stores != null) {
                    this.stores.remove(reg);
                }
            }
        }

        public void addLoad(int reg, int pc) {
            if (this.loads == null) {
                this.loads = new HashMap<Integer, Integer>();
            }
            this.loads.put(Integer14.valueOf(reg), Integer14.valueOf(pc));
        }

        public void addChild(ScopeBlock newChild) {
            newChild.parent = this;
            if (this.children != null) {
                for (ScopeBlock child : this.children) {
                    if (newChild.startLocation <= child.startLocation || newChild.finishLocation >= child.finishLocation) continue;
                    child.addChild(newChild);
                    return;
                }
                int pos = 0;
                for (ScopeBlock child : this.children) {
                    if (newChild.startLocation < child.startLocation) {
                        this.children.add(pos, newChild);
                        return;
                    }
                    ++pos;
                }
                this.children.add(newChild);
                return;
            }
            this.children = new ArrayList<ScopeBlock>();
            this.children.add(newChild);
        }

        public void removeChild(ScopeBlock child) {
            if (this.children != null) {
                this.children.remove(child);
            }
        }

        public void findBugs(Set<Integer> parentUsedRegs) {
            if (this.isLoop) {
                return;
            }
            HashSet<Integer> usedRegs = new HashSet<Integer>(parentUsedRegs);
            if (this.stores != null) {
                usedRegs.addAll(this.stores.keySet());
            }
            if (this.loads != null) {
                usedRegs.addAll(this.loads.keySet());
            }
            if (this.stores != null) {
                if (this.loads != null) {
                    this.stores.keySet().removeAll(this.loads.keySet());
                }
                this.stores.keySet().removeAll(parentUsedRegs);
                if (this.stores.size() > 0 && this.children != null) {
                    for (Map.Entry entry : this.stores.entrySet()) {
                        int childUseCount = 0;
                        boolean inLoop = false;
                        Integer reg = (Integer)entry.getKey();
                        for (ScopeBlock child : this.children) {
                            if (!child.usesReg(reg)) continue;
                            if (child.isLoop) {
                                inLoop = true;
                                break;
                            }
                            ++childUseCount;
                        }
                        if (inLoop || childUseCount != true) continue;
                        BloatedAssignmentScope.this.bugReporter.reportBug(new BugInstance((Detector)BloatedAssignmentScope.this, "BAS_BLOATED_ASSIGNMENT_SCOPE", 2).addClass((PreorderVisitor)BloatedAssignmentScope.this).addMethod((PreorderVisitor)BloatedAssignmentScope.this).addSourceLine((BytecodeScanningDetector)BloatedAssignmentScope.this, ((Integer)entry.getValue()).intValue()));
                    }
                }
            }
            if (this.children != null) {
                for (ScopeBlock scopeBlock : this.children) {
                    scopeBlock.findBugs(usedRegs);
                }
            }
        }

        public boolean usesReg(Integer reg) {
            if (this.loads != null && this.loads.containsKey(reg)) {
                return true;
            }
            if (this.stores != null && this.stores.containsKey(reg)) {
                return true;
            }
            if (this.children != null) {
                for (ScopeBlock child : this.children) {
                    if (!child.usesReg(reg)) continue;
                    return true;
                }
            }
            return false;
        }

        public void pushUpLoadStores() {
            if (this.parent != null) {
                if (this.loads != null) {
                    if (this.parent.loads != null) {
                        this.parent.loads.putAll(this.loads);
                    } else {
                        this.parent.loads = this.loads;
                    }
                }
                if (this.stores != null) {
                    if (this.parent.stores != null) {
                        this.parent.stores.putAll(this.stores);
                    } else {
                        this.parent.stores = this.stores;
                    }
                }
                this.loads = null;
                this.stores = null;
            }
        }
    }
}

