/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class ArrayWrappedCallByReference
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, WrapperInfo> wrappers;

    public ArrayWrappedCallByReference(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.wrappers = new HashMap<Integer, WrapperInfo>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.wrappers = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(188) || bytecodeSet.get(189));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.wrappers.clear();
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer userValue;
        block20: {
            userValue = null;
            try {
                OpcodeStack.Item itm;
                Integer elReg;
                this.stack.mergeJumps((DismantleBytecode)this);
                if (seen == 188 || seen == 189) {
                    OpcodeStack.Item itm2;
                    Integer size;
                    if (this.stack.getStackDepth() > 0 && (size = (Integer)(itm2 = this.stack.getStackItem(0)).getConstant()) != null && size == 1) {
                        userValue = Integer14.valueOf(-1);
                    }
                    break block20;
                }
                if (seen >= 79 && seen <= 86) {
                    if (this.stack.getStackDepth() < 2) break block20;
                    OpcodeStack.Item itm3 = this.stack.getStackItem(2);
                    int reg = itm3.getRegisterNumber();
                    if (reg != -1) {
                        WrapperInfo wi = this.wrappers.get(Integer14.valueOf(reg));
                        if (wi != null) {
                            OpcodeStack.Item elItm = this.stack.getStackItem(0);
                            wi.wrappedReg = elItm.getRegisterNumber();
                        }
                        break block20;
                    }
                    OpcodeStack.Item elItm = this.stack.getStackItem(0);
                    if (elItm.getRegisterNumber() != -1) {
                        userValue = Integer14.valueOf(elItm.getRegisterNumber());
                    }
                    break block20;
                }
                if (seen == 58 || seen >= 75 && seen <= 78) {
                    if (this.stack.getStackDepth() < 1) break block20;
                    OpcodeStack.Item itm4 = this.stack.getStackItem(0);
                    String sig = itm4.getSignature();
                    if (sig.length() > 0 && itm4.getSignature().charAt(0) == '[') {
                        int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                        Integer elReg2 = (Integer)itm4.getUserValue();
                        if (elReg2 != null) {
                            this.wrappers.put(Integer14.valueOf(reg), new WrapperInfo(elReg2));
                        }
                        break block20;
                    }
                    Integer elReg3 = (Integer)itm4.getUserValue();
                    if (elReg3 == null) break block20;
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (elReg3 == reg) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "AWCBR_ARRAY_WRAPPED_CALL_BY_REFERENCE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    break block20;
                }
                if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
                    String sig = this.getSigConstantOperand();
                    Type[] args = Type.getArgumentTypes((String)sig);
                    if (this.stack.getStackDepth() >= args.length) {
                        for (int i = 0; i < args.length; ++i) {
                            OpcodeStack.Item itm5;
                            int arrayReg;
                            WrapperInfo wi;
                            Type t = args[i];
                            String argSig = t.getSignature();
                            if (argSig.length() <= 0 || argSig.charAt(0) != '[' || (wi = this.wrappers.get(Integer14.valueOf(arrayReg = (itm5 = this.stack.getStackItem(args.length - i - 1)).getRegisterNumber()))) == null) continue;
                            wi.wasArg = true;
                        }
                    }
                    break block20;
                }
                if (seen >= 46 && seen <= 53) {
                    OpcodeStack.Item arItm;
                    int arReg;
                    WrapperInfo wi;
                    if (this.stack.getStackDepth() >= 2 && (wi = this.wrappers.get(Integer14.valueOf(arReg = (arItm = this.stack.getStackItem(1)).getRegisterNumber()))) != null && wi.wasArg) {
                        userValue = Integer14.valueOf(wi.wrappedReg);
                    }
                    break block20;
                }
                if (seen == 25 || seen >= 42 && seen <= 45) {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    WrapperInfo wi = this.wrappers.get(Integer14.valueOf(reg));
                    if (wi != null) {
                        userValue = Integer14.valueOf(wi.wrappedReg);
                    }
                    break block20;
                }
                if (!(seen == 54 || seen >= 59 && seen <= 62 || seen == 55 || seen >= 63 && seen <= 66 || seen == 57 || seen >= 71 && seen <= 74 || seen == 56) && (seen < 67 || seen > 70) || this.stack.getStackDepth() < 1 || (elReg = (Integer)(itm = this.stack.getStackItem(0)).getUserValue()) == null) break block20;
                int reg = RegisterUtils.getStoreReg((DismantleBytecode)this, seen);
                if (elReg == reg) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "AWCBR_ARRAY_WRAPPED_CALL_BY_REFERENCE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            catch (Throwable throwable) {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (userValue == null) throw throwable;
                if (this.stack.getStackDepth() <= 0) throw throwable;
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue(userValue);
                throw throwable;
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (userValue == null) return;
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item itm = this.stack.getStackItem(0);
        itm.setUserValue((Object)userValue);
    }

    static class WrapperInfo {
        public int wrappedReg;
        public boolean wasArg;

        public WrapperInfo(int reg) {
            this.wrappedReg = reg;
            this.wasArg = false;
        }
    }
}

