/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class AbstractOverriddenMethod
extends PreorderVisitor
implements Detector {
    private BugReporter bugReporter;
    private ClassContext clsContext;
    private JavaClass[] superClasses;

    public AbstractOverriddenMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.clsContext = classContext;
            JavaClass cls = classContext.getJavaClass();
            if (cls.isInterface()) {
                return;
            }
            this.superClasses = cls.getSuperClasses();
            cls.accept((Visitor)this);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.clsContext = null;
            this.superClasses = null;
        }
    }

    public void visitMethod(Method obj) {
        if (!obj.isAbstract()) {
            return;
        }
        String methodName = obj.getName();
        String methodSig = obj.getSignature();
        JavaClass[] arr$ = this.superClasses;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Method[] methods;
            JavaClass cls = arr$[i$];
            Method[] arr$2 = methods = cls.getMethods();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Method m = arr$2[i$2];
                if (m.isPrivate() || m.isAbstract() || !methodName.equals(m.getName()) || !methodSig.equals(m.getSignature())) continue;
                BugInstance bug = new BugInstance((Detector)this, "AOM_ABSTRACT_OVERRIDDEN_METHOD", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                Code code = obj.getCode();
                if (code != null) {
                    bug.addSourceLineRange(this.clsContext, (PreorderVisitor)this, 0, code.getLength() - 1);
                }
                this.bugReporter.reportBug(bug);
                break block0;
            }
        }
    }

    public void report() {
    }
}

