/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class AbstractClassEmptyMethods
extends BytecodeScanningDetector {
    public static final int SEEN_NOTHING = 0;
    public static final int SEEN_NEW = 1;
    public static final int SEEN_DUP = 2;
    public static final int SEEN_LDC = 3;
    public static final int SEEN_INVOKESPECIAL = 4;
    public static final int SEEN_DONE = 5;
    private static JavaClass EXCEPTION_CLASS;
    private BugReporter bugReporter;
    private String methodName;
    private int state;

    public AbstractClassEmptyMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        if (cls.isAbstract()) {
            super.visitClassContext(classContext);
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        this.state = 0;
    }

    public void visitCode(Code obj) {
        if ("<init>".equals(this.methodName) || "<clinit>".equals(this.methodName)) {
            return;
        }
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        try {
            switch (this.state) {
                case 0: {
                    if (seen == 177) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "ACEM_ABSTRACT_CLASS_EMPTY_METHODS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        this.state = 5;
                        break;
                    }
                    if (seen == 187) {
                        String newClass = this.getClassConstantOperand();
                        JavaClass exCls = Repository.lookupClass((String)newClass);
                        if (EXCEPTION_CLASS != null && exCls.instanceOf(EXCEPTION_CLASS)) {
                            this.state = 1;
                            break;
                        }
                        this.state = 5;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                case 1: {
                    if (seen == 89) {
                        this.state = 2;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                case 2: {
                    if ((seen == 18 || seen == 19) && this.getConstantRefOperand() instanceof ConstantString) {
                        this.state = 3;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                case 3: {
                    if (seen == 183 && "<init>".equals(this.getNameConstantOperand())) {
                        this.state = 4;
                        break;
                    }
                    this.state = 5;
                    break;
                }
                case 4: {
                    if (seen == 191) {
                        this.bugReporter.reportBug(new BugInstance("ACEM_ABSTRACT_CLASS_EMPTY_METHODS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                    this.state = 5;
                    break;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            this.state = 5;
        }
    }

    static {
        try {
            EXCEPTION_CLASS = Repository.lookupClass((String)"java.lang.Exception");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

