/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class AbnormalFinallyBlockReturn
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private List<FinallyBlockInfo> fbInfo;
    private int loadedReg;

    public AbnormalFinallyBlockReturn(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            int majorVersion = classContext.getJavaClass().getMajor();
            if (majorVersion >= 48) {
                this.fbInfo = new ArrayList<FinallyBlockInfo>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.fbInfo = null;
        }
    }

    public void visitCode(Code obj) {
        this.fbInfo.clear();
        this.loadedReg = -1;
        CodeException[] exc = obj.getExceptionTable();
        if (exc != null) {
            CodeException[] arr$ = exc;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                CodeException ce = arr$[i$];
                if (ce.getCatchType() != 0 || ce.getStartPC() != ce.getHandlerPC()) continue;
                this.fbInfo.add(new FinallyBlockInfo(ce.getStartPC(), ce.getEndPC()));
            }
        }
        if (!this.fbInfo.isEmpty()) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (this.fbInfo.isEmpty()) {
            return;
        }
        FinallyBlockInfo fbi = this.fbInfo.get(0);
        if (this.getPC() < fbi.startPC) {
            return;
        }
        if (this.getPC() == fbi.startPC) {
            if (seen == 58) {
                fbi.exReg = this.getRegisterOperand();
            } else if (seen >= 75 && seen <= 78) {
                fbi.exReg = seen - 75;
            } else {
                this.fbInfo.remove(0);
                this.sawOpcode(seen);
                return;
            }
            return;
        }
        if (seen == 194) {
            ++fbi.monitorCount;
        } else if (seen == 195) {
            --fbi.monitorCount;
            if (fbi.monitorCount < 0) {
                this.fbInfo.remove(0);
                this.sawOpcode(seen);
                return;
            }
        }
        if (seen == 191 && this.loadedReg == fbi.exReg) {
            this.fbInfo.remove(0);
            this.sawOpcode(seen);
            return;
        }
        this.loadedReg = seen == 25 ? this.getRegisterOperand() : (seen >= 42 && seen <= 45 ? seen - 42 : -1);
        if (seen >= 172 && seen <= 177 || seen == 191) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "AFBR_ABNORMAL_FINALLY_BLOCK_RETURN", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            this.fbInfo.remove(0);
        } else if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
            try {
                ExceptionTable et;
                JavaClass cls = Repository.lookupClass((String)this.getClassConstantOperand());
                Method m = this.findMethod(cls, this.getNameConstantOperand(), this.getSigConstantOperand());
                if (m != null && (et = m.getExceptionTable()) != null && et.getLength() > 0 && !this.catchBlockInFinally(fbi)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "AFBR_ABNORMAL_FINALLY_BLOCK_RETURN", 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.fbInfo.remove(0);
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    private Method findMethod(JavaClass cls, String name, String sig) {
        Method[] methods;
        Method[] arr$ = methods = cls.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            if (!m.getName().equals(name) || !m.getSignature().equals(sig)) continue;
            return m;
        }
        return null;
    }

    private boolean catchBlockInFinally(FinallyBlockInfo fbInfo) {
        CodeException[] catchExceptions = this.getCode().getExceptionTable();
        if (catchExceptions == null || catchExceptions.length == 0) {
            return false;
        }
        int pc = this.getPC();
        CodeException[] arr$ = catchExceptions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CodeException ex = arr$[i$];
            if (ex.getStartPC() > pc || ex.getEndPC() < pc || ex.getStartPC() < fbInfo.startPC) continue;
            return true;
        }
        return false;
    }

    public static class FinallyBlockInfo {
        public int startPC;
        public int endPC;
        public int monitorCount;
        public int exReg;

        public FinallyBlockInfo(int start, int end) {
            this.startPC = start;
            this.endPC = end;
            this.monitorCount = 0;
            this.exReg = -1;
        }
    }
}

