/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.collect;

import java.util.HashMap;
import java.util.Map;

public class Statistics {
    private static Statistics statistics = new Statistics();
    private Map<Long, Long> methodStatistics = new HashMap<Long, Long>();

    private Statistics() {
    }

    public static Statistics getStatistics() {
        return statistics;
    }

    public void clear() {
        this.methodStatistics.clear();
    }

    public void addMethodStatistics(String className, String methodName, String signature, MethodInfo methodInfo) {
        Long key = this.getKey(className, methodName, signature);
        if (this.methodStatistics.containsKey(key)) {
            this.methodStatistics.put(key, this.getValue(new MethodInfo()));
        } else {
            this.methodStatistics.put(this.getKey(className, methodName, signature), this.getValue(methodInfo));
        }
    }

    public MethodInfo getMethodStatistics(String className, String methodName, String signature) {
        Long v = this.methodStatistics.get(this.getKey(className, methodName, signature));
        if (v == null) {
            return new MethodInfo();
        }
        return this.buildMethodInfo(v);
    }

    private Long getKey(String className, String methodName, String signature) {
        long hashCode = className.hashCode();
        hashCode <<= 16;
        hashCode |= (long)methodName.hashCode();
        hashCode <<= 16;
        return new Long(hashCode |= (long)signature.hashCode());
    }

    private Long getValue(MethodInfo methodInfo) {
        long value = methodInfo.numBytes;
        value <<= 32;
        return new Long(value |= (long)methodInfo.numMethodCalls);
    }

    private MethodInfo buildMethodInfo(Long value) {
        MethodInfo mi = new MethodInfo();
        long v = value;
        mi.numBytes = (int)(v >>> 32);
        mi.numMethodCalls = (int)(v & Integer.MAX_VALUE);
        return mi;
    }

    public static class MethodInfo {
        public int numBytes;
        public int numMethodCalls;

        public MethodInfo() {
            this.numBytes = 0;
            this.numMethodCalls = 0;
        }

        public MethodInfo(int bytes, int calls) {
            this.numBytes = bytes;
            this.numMethodCalls = calls;
        }
    }
}

