/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.collect;

import com.mebigfatguy.fbcontrib.collect.Statistics;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import org.apache.bcel.classfile.Code;

public class CollectStatistics
extends BytecodeScanningDetector
implements NonReportingDetector {
    private int numMethodCalls;

    public CollectStatistics(BugReporter bugReporter) {
        Statistics.getStatistics().clear();
    }

    public void visitCode(Code obj) {
        this.numMethodCalls = 0;
        byte[] code = obj.getCode();
        if (code != null) {
            super.visitCode(obj);
            Statistics.getStatistics().addMethodStatistics(this.getClassName(), this.getMethodName(), this.getMethodSig(), new Statistics.MethodInfo(code.length, this.numMethodCalls));
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ++this.numMethodCalls;
            }
        }
    }
}

