/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.AntSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.execution.NbClassPath;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

public class AntCustomizer
extends JPanel
implements ActionListener {
    private List<File> classpath = Collections.emptyList();
    private Map<String, String> properties = Collections.emptyMap();
    private boolean changed = false;
    private boolean listen = false;
    private File originalAntHome;
    private final Node.Property classpathProperty;
    private final Node.Property propertiesProperty;
    private boolean initialized = false;
    private JButton bAntHome;
    private JButton bAntHomeDefault;
    private JCheckBox cbAlwaysShowOutput;
    private JCheckBox cbReuseOutput;
    private JCheckBox cbSaveFiles;
    private JComboBox cbVerbosity;
    private JLabel classpathLabel;
    private JPanel classpathPanel;
    private JLabel lAntVersion;
    private JLabel propertiesLabel;
    private JPanel propertiesPanel;
    private JTextField tfAntHome;

    public AntCustomizer() {
        this.initComponents();
        this.bAntHome.addActionListener(this);
        ((DefaultComboBoxModel)this.cbVerbosity.getModel()).removeAllElements();
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_warn"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_info"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_verbose"));
        this.cbVerbosity.addItem(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_verbosity_debug"));
        this.cbSaveFiles.addActionListener(this);
        this.cbReuseOutput.addActionListener(this);
        this.cbAlwaysShowOutput.addActionListener(this);
        this.cbVerbosity.addActionListener(this);
        this.classpathProperty = new PropertySupport.ReadWrite<NbClassPath>("classpath", NbClassPath.class, null, null){

            public NbClassPath getValue() throws IllegalAccessException, InvocationTargetException {
                return new NbClassPath(AntCustomizer.this.classpath.toArray(new File[AntCustomizer.this.classpath.size()]));
            }

            public void setValue(NbClassPath val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                String cp = val.getClassPath();
                if (cp.startsWith("\"") && cp.endsWith("\"")) {
                    cp = cp.substring(1, cp.length() - 1);
                }
                AntCustomizer.this.classpath = new ArrayList();
                for (String f : cp.split(Pattern.quote(File.pathSeparator))) {
                    AntCustomizer.this.classpath.add(new File(f));
                }
                AntCustomizer.this.changed = true;
            }
        };
        this.propertiesProperty = new PropertySupport.ReadWrite<Properties>("properties", Properties.class, null, null){

            public Properties getValue() throws IllegalAccessException, InvocationTargetException {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)AntCustomizer.this.properties);
                return p;
            }

            public void setValue(Properties val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                AntCustomizer.this.properties = NbCollections.checkedMapByCopy((Map)val, String.class, String.class, (boolean)true);
                AntCustomizer.this.changed = true;
            }
        };
        this.setUpPropertyPanels();
    }

    private void setUpPropertyPanels() {
        this.classpathPanel.removeAll();
        PropertyPanel pp = new PropertyPanel(this.classpathProperty, 2);
        this.classpathPanel.add((Component)pp);
        this.classpathLabel.setLabelFor((Component)pp);
        this.propertiesPanel.removeAll();
        pp = new PropertyPanel(this.propertiesProperty, 2);
        this.propertiesPanel.add((Component)pp);
        this.propertiesLabel.setLabelFor((Component)pp);
    }

    void update() {
        this.listen = false;
        this.classpath = AntSettings.getExtraClasspath();
        this.properties = AntSettings.getProperties();
        this.setUpPropertyPanels();
        this.originalAntHome = AntSettings.getAntHome();
        this.tfAntHome.setText(this.originalAntHome != null ? this.originalAntHome.toString() : null);
        this.cbSaveFiles.setSelected(AntSettings.getSaveAll());
        this.cbReuseOutput.setSelected(AntSettings.getAutoCloseTabs());
        this.cbAlwaysShowOutput.setSelected(AntSettings.getAlwaysShowOutput());
        this.cbVerbosity.setSelectedIndex(AntSettings.getVerbosity() - 1);
        this.updateAntVersion();
        this.changed = false;
        this.initialized = true;
        this.listen = true;
    }

    private void updateAntVersion() {
        this.lAntVersion.setText(NbBundle.getMessage(AntCustomizer.class, (String)"LBL_please_wait"));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final String version = AntSettings.getAntVersion();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AntCustomizer.this.lAntVersion.setText("(" + version + ")");
                    }
                });
            }
        });
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        String antHome = this.tfAntHome.getText().trim();
        AntSettings.setAntHome(new File(antHome));
        if (AntSettings.getAutoCloseTabs() != this.cbReuseOutput.isSelected()) {
            AntSettings.setAutoCloseTabs(this.cbReuseOutput.isSelected());
        }
        if (AntSettings.getSaveAll() != this.cbSaveFiles.isSelected()) {
            AntSettings.setSaveAll(this.cbSaveFiles.isSelected());
        }
        if (AntSettings.getAlwaysShowOutput() != this.cbAlwaysShowOutput.isSelected()) {
            AntSettings.setAlwaysShowOutput(this.cbAlwaysShowOutput.isSelected());
        }
        if (AntSettings.getVerbosity() != this.cbVerbosity.getSelectedIndex() + 1) {
            AntSettings.setVerbosity(this.cbVerbosity.getSelectedIndex() + 1);
        }
        if (!((Object)AntSettings.getProperties()).equals(this.properties)) {
            AntSettings.setProperties(this.properties);
        }
        if (!((Object)AntSettings.getExtraClasspath()).equals(this.classpath)) {
            AntSettings.setExtraClasspath(this.classpath);
        }
        this.changed = false;
    }

    void cancel() {
        if (AntSettings.getAntHome() != this.originalAntHome) {
            AntSettings.setAntHome(this.originalAntHome);
        }
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        Object o = e.getSource();
        if (o == this.cbAlwaysShowOutput) {
            this.changed = true;
        } else if (o == this.cbReuseOutput) {
            this.changed = true;
        } else if (o == this.cbSaveFiles) {
            this.changed = true;
        } else if (o == this.cbVerbosity) {
            this.changed = true;
        } else if (o == this.bAntHome) {
            JFileChooser chooser = new JFileChooser(this.tfAntHome.getText());
            chooser.setFileSelectionMode(1);
            int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(AntCustomizer.class, (String)"Select_Directory"));
            if (r == 0) {
                File file = chooser.getSelectedFile();
                if (!new File(new File(file, "lib"), "ant.jar").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntCustomizer.class, (String)"Not_a_ant_home", (Object)file), 2));
                    return;
                }
                this.tfAntHome.setText(file.getAbsolutePath());
                AntSettings.setAntHome(file);
                this.updateAntVersion();
                this.changed = true;
            }
        }
    }

    private void initComponents() {
        JLabel antHomeLabel = new JLabel();
        this.tfAntHome = new JTextField();
        this.bAntHome = new JButton();
        this.bAntHomeDefault = new JButton();
        this.lAntVersion = new JLabel();
        this.cbSaveFiles = new JCheckBox();
        this.cbReuseOutput = new JCheckBox();
        this.cbAlwaysShowOutput = new JCheckBox();
        this.cbVerbosity = new JComboBox();
        JLabel verbosityLabel = new JLabel();
        this.classpathLabel = new JLabel();
        this.classpathPanel = new JPanel();
        this.propertiesLabel = new JLabel();
        this.propertiesPanel = new JPanel();
        antHomeLabel.setLabelFor(this.tfAntHome);
        Mnemonics.setLocalizedText((JLabel)antHomeLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAntHome, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home_Button"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAntHomeDefault, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Ant_Home_Default_Button"));
        this.bAntHomeDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AntCustomizer.this.bAntHomeDefaultActionPerformed(evt);
            }
        });
        this.lAntVersion.setBackground(Color.white);
        Mnemonics.setLocalizedText((JLabel)this.lAntVersion, (String)NbBundle.getMessage(AntCustomizer.class, (String)"AntCustomizer.lAntVersion.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSaveFiles, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Save_Files"));
        this.cbSaveFiles.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseOutput, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Reuse_Output"));
        this.cbReuseOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAlwaysShowOutput, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Always_Show_Output"));
        this.cbAlwaysShowOutput.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbVerbosity.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal"}));
        verbosityLabel.setLabelFor(this.cbVerbosity);
        Mnemonics.setLocalizedText((JLabel)verbosityLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"Verbosity"));
        Mnemonics.setLocalizedText((JLabel)this.classpathLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"AntCustomizer.classpathLabel.text"));
        this.classpathPanel.setBackground(new Color(153, 0, 204));
        this.classpathPanel.setForeground(new Color(153, 0, 204));
        this.classpathPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.propertiesLabel, (String)NbBundle.getMessage(AntCustomizer.class, (String)"AntCustomizer.propertiesLabel.text"));
        this.propertiesPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(antHomeLabel).addGap(49, 49, 49).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbAlwaysShowOutput).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lAntVersion, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.tfAntHome, -2, 397, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAntHome).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAntHomeDefault).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbReuseOutput).addComponent(this.cbSaveFiles)).addContainerGap())))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(verbosityLabel).addComponent(this.classpathLabel).addComponent(this.propertiesLabel)).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.propertiesPanel, -2, 549, -2).addComponent(this.cbVerbosity, -2, -1, -2).addComponent(this.classpathPanel, -2, 549, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(antHomeLabel).addComponent(this.bAntHomeDefault).addComponent(this.bAntHome).addComponent(this.tfAntHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lAntVersion, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSaveFiles).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbReuseOutput).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAlwaysShowOutput).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbVerbosity, -2, -1, -2).addComponent(verbosityLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classpathLabel).addComponent(this.classpathPanel, -2, 175, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.propertiesLabel)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.propertiesPanel, -2, 93, -2))).addContainerGap()));
    }

    private void bAntHomeDefaultActionPerformed(ActionEvent evt) {
        AntSettings.setAntHome(null);
        File antHome = AntSettings.getAntHome();
        if (antHome != null) {
            this.tfAntHome.setText(antHome.getAbsolutePath());
        } else {
            this.tfAntHome.setText(null);
        }
        this.updateAntVersion();
        this.changed = true;
    }
}

