/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class UndoManager {
    private LinkedList<LinkedList<UndoItem>> undoList;
    private LinkedList<LinkedList<UndoItem>> redoList;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean wasUndo = false;
    private boolean wasRedo = false;
    private boolean transactionStart;
    private IdentityHashMap<LinkedList, String> descriptionMap;
    private String description;
    private ProgressListener progress;
    private static UndoManager instance;
    public boolean autoConfirm = false;
    private int stepCounter = 0;

    public void setAutoConfirm(boolean autoConfirm) {
        this.autoConfirm = autoConfirm;
    }

    public static synchronized UndoManager getDefault() {
        if (instance == null) {
            instance = new UndoManager();
        }
        return instance;
    }

    private UndoManager() {
        this.undoList = new LinkedList();
        this.redoList = new LinkedList();
        this.descriptionMap = new IdentityHashMap();
    }

    private UndoManager(ProgressListener progress) {
        this();
        this.progress = progress;
    }

    public void setUndoDescription(String desc) {
        this.description = desc;
    }

    public String getUndoDescription() {
        if (this.undoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.undoList.getFirst());
    }

    public String getRedoDescription() {
        if (this.redoList.isEmpty()) {
            return null;
        }
        return this.descriptionMap.get(this.redoList.getFirst());
    }

    public void transactionStarted() {
        this.transactionStart = true;
    }

    public void transactionEnded(boolean fail) {
        this.description = null;
        if ((!fail || this.undoList.isEmpty()) && this.isUndoAvailable() && this.getUndoDescription() == null) {
            this.descriptionMap.remove(this.undoList.removeFirst());
        }
        this.fireChange();
    }

    public void undo() {
        if (this.isUndoAvailable()) {
            if (!this.autoConfirm && JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(UndoManager.class, (String)"MSG_ReallyUndo", (Object)this.getUndoDescription()), NbBundle.getMessage(UndoManager.class, (String)"MSG_ConfirmUndo"), 0) != 0) {
                throw new CannotUndoException();
            }
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean fail = true;
                    try {
                        UndoManager.this.transactionStarted();
                        UndoManager.this.wasUndo = true;
                        LinkedList undo = (LinkedList)UndoManager.this.undoList.getFirst();
                        UndoManager.this.fireProgressListenerStart(0, undo.size());
                        Iterator undoIterator = undo.iterator();
                        UndoManager.this.redoList.addFirst(new LinkedList());
                        UndoManager.this.descriptionMap.put(UndoManager.this.redoList.getFirst(), UndoManager.this.descriptionMap.remove(undo));
                        try {
                            while (undoIterator.hasNext()) {
                                UndoManager.this.fireProgressListenerStep();
                                UndoItem item = (UndoItem)undoIterator.next();
                                item.undo();
                                if (!(item instanceof SessionUndoItem)) continue;
                                UndoManager.this.addItem(item);
                            }
                        }
                        catch (CannotUndoException e) {
                            UndoManager.this.descriptionMap.put(undo, UndoManager.this.descriptionMap.get(UndoManager.this.redoList.getFirst()));
                            UndoManager.this.descriptionMap.remove(UndoManager.this.redoList.getFirst());
                            UndoManager.this.redoList.removeFirst();
                            throw e;
                        }
                        UndoManager.this.undoList.removeFirst();
                        fail = false;
                    }
                    finally {
                        try {
                            UndoManager.this.wasUndo = false;
                            UndoManager.this.transactionEnded(fail);
                        }
                        finally {
                            UndoManager.this.fireProgressListenerStop();
                            UndoManager.this.fireChange();
                        }
                    }
                }
            };
            run.run();
        }
    }

    public void redo() {
        if (this.isRedoAvailable()) {
            if (!this.autoConfirm && JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(UndoManager.class, (String)"MSG_ReallyRedo", (Object)this.getRedoDescription()), NbBundle.getMessage(UndoManager.class, (String)"MSG_ConfirmRedo"), 0) != 0) {
                throw new CannotRedoException();
            }
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean fail = true;
                    try {
                        UndoManager.this.transactionStarted();
                        UndoManager.this.wasRedo = true;
                        LinkedList redo = (LinkedList)UndoManager.this.redoList.getFirst();
                        UndoManager.this.fireProgressListenerStart(1, redo.size());
                        Iterator redoIterator = redo.iterator();
                        UndoManager.this.description = (String)UndoManager.this.descriptionMap.remove(redo);
                        try {
                            while (redoIterator.hasNext()) {
                                UndoManager.this.fireProgressListenerStep();
                                UndoItem item = (UndoItem)redoIterator.next();
                                item.redo();
                                if (!(item instanceof SessionUndoItem)) continue;
                                UndoManager.this.addItem(item);
                            }
                        }
                        catch (CannotRedoException ex) {
                            UndoManager.this.descriptionMap.put(redo, UndoManager.this.description);
                            throw ex;
                        }
                        UndoManager.this.redoList.removeFirst();
                        fail = false;
                    }
                    finally {
                        try {
                            UndoManager.this.wasRedo = false;
                            UndoManager.this.transactionEnded(fail);
                        }
                        finally {
                            UndoManager.this.fireProgressListenerStop();
                            UndoManager.this.fireChange();
                        }
                    }
                }
            };
            run.run();
        }
    }

    public void clear() {
        this.undoList.clear();
        this.redoList.clear();
        this.descriptionMap.clear();
        BackupFacility.getDefault().clear();
        this.fireChange();
    }

    public void addItem(RefactoringSession session) {
        this.addItem(new SessionUndoItem(session));
    }

    private void addItem(UndoItem item) {
        if (this.wasUndo) {
            LinkedList<UndoItem> redo = this.redoList.getFirst();
            redo.addFirst(item);
        } else {
            if (this.transactionStart) {
                this.undoList.addFirst(new LinkedList());
                this.descriptionMap.put(this.undoList.getFirst(), this.description);
                this.transactionStart = false;
            }
            LinkedList<UndoItem> undo = this.undoList.getFirst();
            undo.addFirst(item);
        }
        if (!this.wasUndo && !this.wasRedo) {
            this.redoList.clear();
        }
    }

    public boolean isUndoAvailable() {
        return !this.undoList.isEmpty();
    }

    public boolean isRedoAvailable() {
        return !this.redoList.isEmpty();
    }

    public void addChangeListener(ChangeListener cl) {
        this.changeSupport.addChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.changeSupport.removeChangeListener(cl);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void fireProgressListenerStart(int type, int count) {
        this.stepCounter = 0;
        if (this.progress == null) {
            return;
        }
        this.progress.start(new ProgressEvent(this, 1, type, count));
    }

    private void fireProgressListenerStep() {
        if (this.progress == null) {
            return;
        }
        this.progress.step(new ProgressEvent(this, 2, 0, ++this.stepCounter));
    }

    private void fireProgressListenerStop() {
        if (this.progress == null) {
            return;
        }
        this.progress.stop(new ProgressEvent(this, 4));
    }

    private final class SessionUndoItem
    implements UndoItem {
        private RefactoringSession change;

        public SessionUndoItem(RefactoringSession change) {
            this.change = change;
        }

        @Override
        public void undo() {
            this.change.undoRefactoring(true);
        }

        @Override
        public void redo() {
            this.change.doRefactoring(true);
        }
    }

    private static interface UndoItem {
        public void undo();

        public void redo();
    }
}

