/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints;

import java.awt.Dialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.ElementUtilities;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsTypeAnalyzer;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.javascript.hints.infrastructure.JsAstRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsRuleContext;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class UnsupportedCalls
extends JsAstRule {
    private Collection<String> skip = null;
    private static final Set<String> NAME_SET = new HashSet<String>(262);
    private static final Map<String, Boolean> MUST_CHECK_FQN = new HashMap<String, Boolean>(262);
    private static final Map<String, String> NAME_TO_FQN = new HashMap<String, String>(262);
    private static final Map<String, EnumSet<BrowserVersion>> COMPAT_MAP = new HashMap<String, EnumSet<BrowserVersion>>(262);
    private static final EnumSet<BrowserVersion> FF2FF3OPERASAFARI2SAFARI3KONQ = BrowserVersion.fromFlags((String)"FF2|FF3|OPERA|SAFARI2|SAFARI3|KONQ");
    private static final EnumSet<BrowserVersion> NOT_IE = BrowserVersion.fromFlags((String)"FF1|FF2|FF3|OPERA|SAFARI2|SAFARI3|KONQ");
    private static final EnumSet<BrowserVersion> NOT_IE55 = BrowserVersion.fromFlags((String)"IE6|IE7|FF1|FF2|FF3|OPERA|SAFARI2|SAFARI3|KONQ");
    private static final EnumSet<BrowserVersion> NOT_IE55_OR_6 = BrowserVersion.fromFlags((String)"IE7|FF1|FF2|FF3|OPERA|SAFARI2|SAFARI3|KONQ");
    private static final EnumSet<BrowserVersion> FIREFOX = BrowserVersion.fromFlags((String)"FF1|FF2|FF3");
    private static final EnumSet<BrowserVersion> FF3 = BrowserVersion.fromFlags((String)"FF3");
    private static final EnumSet<BrowserVersion> FF2FF3OPERASAFARI3KONQ = BrowserVersion.fromFlags((String)"FF2|FF3|OPERA|SAFARI3|KONQ");
    private static final EnumSet<BrowserVersion> IE = BrowserVersion.fromFlags((String)"IE55|IE6|IE7");

    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    @Override
    public Set<Integer> getKinds() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(41);
        hashSet.add(30);
        return hashSet;
    }

    @Override
    public void run(JsRuleContext jsRuleContext, List<Hint> list) {
        Node node = jsRuleContext.node;
        if (node.getType() == 30) {
            String string;
            Node node2 = node.getFirstChild();
            if (node2 != null && node2.getType() == 39 && NAME_SET.contains(string = node2.getString())) {
                this.processCall(jsRuleContext, list, node, string, node2);
            }
        } else {
            Node node3;
            assert (node.getType() == 41);
            Node node4 = node.getParentNode();
            if (node4.getType() == 33 && (node3 = node4.getParentNode()) != null && (node3.getType() == 38 || node3.getType() == 30) && node3.getFirstChild() == node4) {
                String string = node.getString();
                Node node5 = node3;
                if (NAME_SET.contains(string)) {
                    this.processCall(jsRuleContext, list, node5, string, node);
                }
            }
        }
    }

    private void processCall(JsRuleContext jsRuleContext, List<Hint> list, Node node, String string, Node node2) {
        Object object;
        OffsetRange offsetRange;
        EnumSet<BrowserVersion> enumSet;
        String string2;
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)jsRuleContext.parserResult);
        Boolean bl = MUST_CHECK_FQN.get(string);
        if (bl == null) {
            string2 = JsIndex.get((Collection)QuerySupport.findRoots((FileObject)jsParseResult.getSnapshot().getSource().getFileObject(), null, Collections.singleton("JavascriptBootClassPath"), Collections.emptySet()));
            enumSet = string2.getAllNames(string, QuerySupport.Kind.EXACT, jsParseResult);
            if (enumSet.size() <= 1) {
                bl = Boolean.TRUE;
            } else {
                int n = 0;
                offsetRange = enumSet.iterator();
                while (offsetRange.hasNext() && ((object = (IndexedElement)offsetRange.next()).getKind() != ElementKind.METHOD || ++n != 2)) {
                }
                bl = n <= 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            MUST_CHECK_FQN.put(string, bl);
        }
        if (bl == Boolean.FALSE) {
            string2 = JsTypeAnalyzer.getCallFqn((JsParseResult)jsParseResult, (Node)node, (boolean)true);
            if (string2 == null) {
                return;
            }
            if (!COMPAT_MAP.containsKey(string2)) {
                return;
            }
        } else {
            string2 = NAME_TO_FQN.get(string);
            if (string2 == null) {
                return;
            }
        }
        if (this.getSkipMap().contains(string2)) {
            return;
        }
        enumSet = COMPAT_MAP.get(string2);
        if (!SupportedBrowsers.getInstance().isSupported(enumSet)) {
            OffsetRange offsetRange2 = AstUtilities.getRange((Node)node2);
            offsetRange = LexUtilities.getLexerOffsets((JsParseResult)jsParseResult, (OffsetRange)offsetRange2);
            if (offsetRange == OffsetRange.NONE) {
                return;
            }
            object = new ArrayList(3);
            object.add(new ShowDetails(jsParseResult, string2, enumSet));
            object.add(new SkipFunction(jsRuleContext, string2));
            object.add(new ChangeTargetFix());
            String string3 = NbBundle.getMessage(UnsupportedCalls.class, (String)"UnsupportedCallFqn", (Object)string2);
            Hint hint = new Hint((Rule)this, string3, jsParseResult.getSnapshot().getSource().getFileObject(), offsetRange, (List)object, 1450);
            list.add(hint);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(UnsupportedCalls.class).node("unsupportedCalls");
    }

    private Collection<String> getSkipMap() {
        Preferences preferences;
        if (this.skip == null && (preferences = this.getPreferences()) != null) {
            try {
                this.skip = Arrays.asList(preferences.keys());
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
                this.skip = new HashSet<String>();
            }
        }
        return this.skip;
    }

    private void skip(String string) {
        this.getSkipMap();
        if (this.skip.contains(string)) {
            return;
        }
        this.getPreferences().putBoolean(string, true);
        this.skip = null;
    }

    public String getId() {
        return "UnsupportedCalls";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UnsupportedCalls.class, (String)"UnsupportedCalls");
    }

    public String getDescription() {
        return NbBundle.getMessage(UnsupportedCalls.class, (String)"UnsupportedCallsDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    static {
        COMPAT_MAP.put("CanvasGradient.addColorStop", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.arc", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.arcTo", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.beginPath", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.bezierCurveTo", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.clearRect", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.clip", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.closePath", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.createImageData", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.createLinearGradient", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.createPattern", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.createRadialGradient", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.drawImage", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.fill", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.fillRect", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.getImageData", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.isPointInPath", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.lineTo", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.load", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.moveTo", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.putImageData", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.quadraticCurveTo", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.rect", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.rotate", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.save", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.scale", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.setTransform", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.stroke", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.strokeRect", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.transform", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("CanvasRenderingContext2D.translate", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("Document.adoptNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("Document.createAttributeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Document.createDocumentFragment", NOT_IE55);
        COMPAT_MAP.put("Document.createElementNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Document.getElementsByTagNameNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Document.implementation.createDocument", NOT_IE);
        COMPAT_MAP.put("Document.implementation.hasFeature", NOT_IE55);
        COMPAT_MAP.put("Document.importNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("Document.normalizeDocument", NOT_IE55_OR_6);
        COMPAT_MAP.put("Document.renameNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("DocumentRange.createRange", NOT_IE);
        COMPAT_MAP.put("DocumentTraversal.createNodeIterator", NOT_IE);
        COMPAT_MAP.put("DocumentTraversal.createTreeWalker", NOT_IE);
        COMPAT_MAP.put("Element.applyElement", IE);
        COMPAT_MAP.put("Element.contains", NOT_IE);
        COMPAT_MAP.put("Element.createAttribute", NOT_IE55);
        COMPAT_MAP.put("Element.getAttributeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.getAttributeNode", NOT_IE55);
        COMPAT_MAP.put("Element.getAttributeNodeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.getBoundingClientRect", FF3);
        COMPAT_MAP.put("Element.getClientRects", FF3);
        COMPAT_MAP.put("Element.getElementsByTagNameNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.hasAttributeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.hasAttributes", NOT_IE);
        COMPAT_MAP.put("Element.removeAttributeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.removeAttributeNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.setAttributeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.setAttributeNode", NOT_IE55);
        COMPAT_MAP.put("Element.setAttributeNodeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.setIdAttribute", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.setIdAttributeNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Element.setIdAttributeNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("HTMLCanvasElement.getContext", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("HTMLCanvasElement.toDataURL", FF2FF3OPERASAFARI2SAFARI3KONQ);
        COMPAT_MAP.put("Iterator", FF2FF3OPERASAFARI3KONQ);
        COMPAT_MAP.put("Iterator.next", FF2FF3OPERASAFARI3KONQ);
        COMPAT_MAP.put("NameList.contains", NOT_IE55_OR_6);
        COMPAT_MAP.put("NameList.containsNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("NameList.getName", NOT_IE55_OR_6);
        COMPAT_MAP.put("NameList.getNamespaceURI", NOT_IE55_OR_6);
        COMPAT_MAP.put("NamedNodeMap.getNamedItemNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("NamedNodeMap.removeNamedItemNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("NamedNodeMap.setNamedItemNS", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.appendData", NOT_IE55);
        COMPAT_MAP.put("Node.clearAttributes", IE);
        COMPAT_MAP.put("Node.compareDocumentPosition", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.getFeature", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.getUserData", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.hasAttributes", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.insertData", NOT_IE55);
        COMPAT_MAP.put("Node.isDefaultNamespace", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.isEqualNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.isSameNode", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.isSupported", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.lookupNamespaceURI", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.lookupPrefix", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.mergeAttributes", IE);
        COMPAT_MAP.put("Node.normalize", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.removeNode", IE);
        COMPAT_MAP.put("Node.replaceData", NOT_IE55);
        COMPAT_MAP.put("Node.replaceNode", IE);
        COMPAT_MAP.put("Node.setUserData", NOT_IE55_OR_6);
        COMPAT_MAP.put("Node.substringData", NOT_IE55);
        COMPAT_MAP.put("Node.swapNode", IE);
        COMPAT_MAP.put("NodeIterator.detach", NOT_IE);
        COMPAT_MAP.put("NodeIterator.nextNode", NOT_IE);
        COMPAT_MAP.put("NodeIterator.previousNode", NOT_IE);
        COMPAT_MAP.put("Range.cloneContents", NOT_IE);
        COMPAT_MAP.put("Range.cloneRange", NOT_IE);
        COMPAT_MAP.put("Range.collapse", NOT_IE);
        COMPAT_MAP.put("Range.compareBoundaryPoints", NOT_IE);
        COMPAT_MAP.put("Range.compareNode", FIREFOX);
        COMPAT_MAP.put("Range.comparePoint", FIREFOX);
        COMPAT_MAP.put("Range.createContextualFragment", FIREFOX);
        COMPAT_MAP.put("Range.deleteContents", NOT_IE);
        COMPAT_MAP.put("Range.detach", NOT_IE);
        COMPAT_MAP.put("Range.extractContents", NOT_IE);
        COMPAT_MAP.put("Range.insertNode", NOT_IE);
        COMPAT_MAP.put("Range.intersectsNode", FIREFOX);
        COMPAT_MAP.put("Range.isPointInRange", FIREFOX);
        COMPAT_MAP.put("Range.selectNode", NOT_IE);
        COMPAT_MAP.put("Range.selectNodeContents", NOT_IE);
        COMPAT_MAP.put("Range.setEnd", NOT_IE);
        COMPAT_MAP.put("Range.setEndAfter", NOT_IE);
        COMPAT_MAP.put("Range.setEndBefore", NOT_IE);
        COMPAT_MAP.put("Range.setStart", NOT_IE);
        COMPAT_MAP.put("Range.setStartAfter", NOT_IE);
        COMPAT_MAP.put("Range.setStartBefore", NOT_IE);
        COMPAT_MAP.put("Range.surroundContents", NOT_IE);
        COMPAT_MAP.put("Text.replaceWholeText", NOT_IE55_OR_6);
        COMPAT_MAP.put("TreeWalker.firstChild", NOT_IE);
        COMPAT_MAP.put("TreeWalker.lastChild", NOT_IE);
        COMPAT_MAP.put("TreeWalker.nextNode", NOT_IE);
        COMPAT_MAP.put("TreeWalker.nextSibling", NOT_IE);
        COMPAT_MAP.put("TreeWalker.parentNode", NOT_IE);
        COMPAT_MAP.put("TreeWalker.previousNode", NOT_IE);
        COMPAT_MAP.put("TreeWalker.previousSibling", NOT_IE);
        COMPAT_MAP.put("TypeInfo.isDerivedFrom", NOT_IE55_OR_6);
        COMPAT_MAP.put("XMLHttpRequest", NOT_IE55_OR_6);
        NAME_SET.add("Iterator");
        NAME_SET.add("XMLHttpRequest");
        NAME_SET.add("addColorStop");
        NAME_SET.add("adoptNode");
        NAME_SET.add("appendData");
        NAME_SET.add("applyElement");
        NAME_SET.add("arc");
        NAME_SET.add("arcTo");
        NAME_SET.add("beginPath");
        NAME_SET.add("bezierCurveTo");
        NAME_SET.add("clearAttributes");
        NAME_SET.add("clearRect");
        NAME_SET.add("clip");
        NAME_SET.add("cloneContents");
        NAME_SET.add("cloneRange");
        NAME_SET.add("closePath");
        NAME_SET.add("collapse");
        NAME_SET.add("compareBoundaryPoints");
        NAME_SET.add("compareDocumentPosition");
        NAME_SET.add("compareNode");
        NAME_SET.add("comparePoint");
        NAME_SET.add("contains");
        NAME_SET.add("containsNS");
        NAME_SET.add("createAttribute");
        NAME_SET.add("createAttributeNS");
        NAME_SET.add("createContextualFragment");
        NAME_SET.add("createDocument");
        NAME_SET.add("createDocumentFragment");
        NAME_SET.add("createElementNS");
        NAME_SET.add("createImageData");
        NAME_SET.add("createLinearGradient");
        NAME_SET.add("createNodeIterator");
        NAME_SET.add("createPattern");
        NAME_SET.add("createRadialGradient");
        NAME_SET.add("createRange");
        NAME_SET.add("createTreeWalker");
        NAME_SET.add("deleteContents");
        NAME_SET.add("detach");
        NAME_SET.add("drawImage");
        NAME_SET.add("extractContents");
        NAME_SET.add("fill");
        NAME_SET.add("fillRect");
        NAME_SET.add("firstChild");
        NAME_SET.add("getAttributeNS");
        NAME_SET.add("getAttributeNode");
        NAME_SET.add("getAttributeNodeNS");
        NAME_SET.add("getBoundingClientRect");
        NAME_SET.add("getClientRects");
        NAME_SET.add("getContext");
        NAME_SET.add("getElementsByTagNameNS");
        NAME_SET.add("getFeature");
        NAME_SET.add("getImageData");
        NAME_SET.add("getName");
        NAME_SET.add("getNamedItemNS");
        NAME_SET.add("getNamespaceURI");
        NAME_SET.add("getUserData");
        NAME_SET.add("hasAttributeNS");
        NAME_SET.add("hasAttributes");
        NAME_SET.add("hasFeature");
        NAME_SET.add("importNode");
        NAME_SET.add("insertData");
        NAME_SET.add("insertNode");
        NAME_SET.add("intersectsNode");
        NAME_SET.add("isDefaultNamespace");
        NAME_SET.add("isDerivedFrom");
        NAME_SET.add("isEqualNode");
        NAME_SET.add("isPointInPath");
        NAME_SET.add("isPointInRange");
        NAME_SET.add("isSameNode");
        NAME_SET.add("isSupported");
        NAME_SET.add("lastChild");
        NAME_SET.add("lineTo");
        NAME_SET.add("load");
        NAME_SET.add("lookupNamespaceURI");
        NAME_SET.add("lookupPrefix");
        NAME_SET.add("mergeAttributes");
        NAME_SET.add("moveTo");
        NAME_SET.add("next");
        NAME_SET.add("nextNode");
        NAME_SET.add("nextSibling");
        NAME_SET.add("normalize");
        NAME_SET.add("normalizeDocument");
        NAME_SET.add("parentNode");
        NAME_SET.add("previousNode");
        NAME_SET.add("previousSibling");
        NAME_SET.add("putImageData");
        NAME_SET.add("quadraticCurveTo");
        NAME_SET.add("rect");
        NAME_SET.add("removeAttributeNS");
        NAME_SET.add("removeAttributeNode");
        NAME_SET.add("removeNamedItemNS");
        NAME_SET.add("removeNode");
        NAME_SET.add("renameNode");
        NAME_SET.add("replaceData");
        NAME_SET.add("replaceNode");
        NAME_SET.add("replaceWholeText");
        NAME_SET.add("rotate");
        NAME_SET.add("save");
        NAME_SET.add("scale");
        NAME_SET.add("selectNode");
        NAME_SET.add("selectNodeContents");
        NAME_SET.add("setAttributeNS");
        NAME_SET.add("setAttributeNode");
        NAME_SET.add("setAttributeNodeNS");
        NAME_SET.add("setEnd");
        NAME_SET.add("setEndAfter");
        NAME_SET.add("setEndBefore");
        NAME_SET.add("setIdAttribute");
        NAME_SET.add("setIdAttributeNS");
        NAME_SET.add("setIdAttributeNode");
        NAME_SET.add("setNamedItemNS");
        NAME_SET.add("setStart");
        NAME_SET.add("setStartAfter");
        NAME_SET.add("setStartBefore");
        NAME_SET.add("setTransform");
        NAME_SET.add("setUserData");
        NAME_SET.add("stroke");
        NAME_SET.add("strokeRect");
        NAME_SET.add("substringData");
        NAME_SET.add("surroundContents");
        NAME_SET.add("swapNode");
        NAME_SET.add("toDataURL");
        NAME_SET.add("transform");
        NAME_SET.add("translate");
        NAME_TO_FQN.put("Iterator", "Iterator");
        NAME_TO_FQN.put("XMLHttpRequest", "XMLHttpRequest");
        NAME_TO_FQN.put("addColorStop", "CanvasGradient.addColorStop");
        NAME_TO_FQN.put("adoptNode", "Document.adoptNode");
        NAME_TO_FQN.put("appendData", "Node.appendData");
        NAME_TO_FQN.put("applyElement", "Element.applyElement");
        NAME_TO_FQN.put("arc", "CanvasRenderingContext2D.arc");
        NAME_TO_FQN.put("arcTo", "CanvasRenderingContext2D.arcTo");
        NAME_TO_FQN.put("beginPath", "CanvasRenderingContext2D.beginPath");
        NAME_TO_FQN.put("bezierCurveTo", "CanvasRenderingContext2D.bezierCurveTo");
        NAME_TO_FQN.put("clearAttributes", "Node.clearAttributes");
        NAME_TO_FQN.put("clearRect", "CanvasRenderingContext2D.clearRect");
        NAME_TO_FQN.put("clip", "CanvasRenderingContext2D.clip");
        NAME_TO_FQN.put("cloneContents", "Range.cloneContents");
        NAME_TO_FQN.put("cloneRange", "Range.cloneRange");
        NAME_TO_FQN.put("closePath", "CanvasRenderingContext2D.closePath");
        NAME_TO_FQN.put("collapse", "Range.collapse");
        NAME_TO_FQN.put("compareBoundaryPoints", "Range.compareBoundaryPoints");
        NAME_TO_FQN.put("compareDocumentPosition", "Node.compareDocumentPosition");
        NAME_TO_FQN.put("compareNode", "Range.compareNode");
        NAME_TO_FQN.put("comparePoint", "Range.comparePoint");
        NAME_TO_FQN.put("containsNS", "NameList.containsNS");
        NAME_TO_FQN.put("createAttribute", "Element.createAttribute");
        NAME_TO_FQN.put("createAttributeNS", "Document.createAttributeNS");
        NAME_TO_FQN.put("createContextualFragment", "Range.createContextualFragment");
        NAME_TO_FQN.put("createDocument", "Document.implementation.createDocument");
        NAME_TO_FQN.put("createDocumentFragment", "Document.createDocumentFragment");
        NAME_TO_FQN.put("createElementNS", "Document.createElementNS");
        NAME_TO_FQN.put("createImageData", "CanvasRenderingContext2D.createImageData");
        NAME_TO_FQN.put("createLinearGradient", "CanvasRenderingContext2D.createLinearGradient");
        NAME_TO_FQN.put("createNodeIterator", "DocumentTraversal.createNodeIterator");
        NAME_TO_FQN.put("createPattern", "CanvasRenderingContext2D.createPattern");
        NAME_TO_FQN.put("createRadialGradient", "CanvasRenderingContext2D.createRadialGradient");
        NAME_TO_FQN.put("createRange", "DocumentRange.createRange");
        NAME_TO_FQN.put("createTreeWalker", "DocumentTraversal.createTreeWalker");
        NAME_TO_FQN.put("deleteContents", "Range.deleteContents");
        NAME_TO_FQN.put("drawImage", "CanvasRenderingContext2D.drawImage");
        NAME_TO_FQN.put("extractContents", "Range.extractContents");
        NAME_TO_FQN.put("fill", "CanvasRenderingContext2D.fill");
        NAME_TO_FQN.put("fillRect", "CanvasRenderingContext2D.fillRect");
        NAME_TO_FQN.put("firstChild", "TreeWalker.firstChild");
        NAME_TO_FQN.put("getAttributeNS", "Element.getAttributeNS");
        NAME_TO_FQN.put("getAttributeNode", "Element.getAttributeNode");
        NAME_TO_FQN.put("getAttributeNodeNS", "Element.getAttributeNodeNS");
        NAME_TO_FQN.put("getBoundingClientRect", "Element.getBoundingClientRect");
        NAME_TO_FQN.put("getClientRects", "Element.getClientRects");
        NAME_TO_FQN.put("getContext", "HTMLCanvasElement.getContext");
        NAME_TO_FQN.put("getFeature", "Node.getFeature");
        NAME_TO_FQN.put("getImageData", "CanvasRenderingContext2D.getImageData");
        NAME_TO_FQN.put("getName", "NameList.getName");
        NAME_TO_FQN.put("getNamedItemNS", "NamedNodeMap.getNamedItemNS");
        NAME_TO_FQN.put("getNamespaceURI", "NameList.getNamespaceURI");
        NAME_TO_FQN.put("getUserData", "Node.getUserData");
        NAME_TO_FQN.put("hasAttributeNS", "Element.hasAttributeNS");
        NAME_TO_FQN.put("hasFeature", "Document.implementation.hasFeature");
        NAME_TO_FQN.put("importNode", "Document.importNode");
        NAME_TO_FQN.put("insertData", "Node.insertData");
        NAME_TO_FQN.put("insertNode", "Range.insertNode");
        NAME_TO_FQN.put("intersectsNode", "Range.intersectsNode");
        NAME_TO_FQN.put("isDefaultNamespace", "Node.isDefaultNamespace");
        NAME_TO_FQN.put("isDerivedFrom", "TypeInfo.isDerivedFrom");
        NAME_TO_FQN.put("isEqualNode", "Node.isEqualNode");
        NAME_TO_FQN.put("isPointInPath", "CanvasRenderingContext2D.isPointInPath");
        NAME_TO_FQN.put("isPointInRange", "Range.isPointInRange");
        NAME_TO_FQN.put("isSameNode", "Node.isSameNode");
        NAME_TO_FQN.put("isSupported", "Node.isSupported");
        NAME_TO_FQN.put("lastChild", "TreeWalker.lastChild");
        NAME_TO_FQN.put("lineTo", "CanvasRenderingContext2D.lineTo");
        NAME_TO_FQN.put("load", "CanvasRenderingContext2D.load");
        NAME_TO_FQN.put("lookupNamespaceURI", "Node.lookupNamespaceURI");
        NAME_TO_FQN.put("lookupPrefix", "Node.lookupPrefix");
        NAME_TO_FQN.put("mergeAttributes", "Node.mergeAttributes");
        NAME_TO_FQN.put("moveTo", "CanvasRenderingContext2D.moveTo");
        NAME_TO_FQN.put("next", "Iterator.next");
        NAME_TO_FQN.put("nextSibling", "TreeWalker.nextSibling");
        NAME_TO_FQN.put("normalize", "Node.normalize");
        NAME_TO_FQN.put("normalizeDocument", "Document.normalizeDocument");
        NAME_TO_FQN.put("parentNode", "TreeWalker.parentNode");
        NAME_TO_FQN.put("previousSibling", "TreeWalker.previousSibling");
        NAME_TO_FQN.put("putImageData", "CanvasRenderingContext2D.putImageData");
        NAME_TO_FQN.put("quadraticCurveTo", "CanvasRenderingContext2D.quadraticCurveTo");
        NAME_TO_FQN.put("rect", "CanvasRenderingContext2D.rect");
        NAME_TO_FQN.put("removeAttributeNS", "Element.removeAttributeNS");
        NAME_TO_FQN.put("removeAttributeNode", "Element.removeAttributeNode");
        NAME_TO_FQN.put("removeNamedItemNS", "NamedNodeMap.removeNamedItemNS");
        NAME_TO_FQN.put("removeNode", "Node.removeNode");
        NAME_TO_FQN.put("renameNode", "Document.renameNode");
        NAME_TO_FQN.put("replaceData", "Node.replaceData");
        NAME_TO_FQN.put("replaceNode", "Node.replaceNode");
        NAME_TO_FQN.put("replaceWholeText", "Text.replaceWholeText");
        NAME_TO_FQN.put("rotate", "CanvasRenderingContext2D.rotate");
        NAME_TO_FQN.put("save", "CanvasRenderingContext2D.save");
        NAME_TO_FQN.put("scale", "CanvasRenderingContext2D.scale");
        NAME_TO_FQN.put("selectNode", "Range.selectNode");
        NAME_TO_FQN.put("selectNodeContents", "Range.selectNodeContents");
        NAME_TO_FQN.put("setAttributeNS", "Element.setAttributeNS");
        NAME_TO_FQN.put("setAttributeNode", "Element.setAttributeNode");
        NAME_TO_FQN.put("setAttributeNodeNS", "Element.setAttributeNodeNS");
        NAME_TO_FQN.put("setEnd", "Range.setEnd");
        NAME_TO_FQN.put("setEndAfter", "Range.setEndAfter");
        NAME_TO_FQN.put("setEndBefore", "Range.setEndBefore");
        NAME_TO_FQN.put("setIdAttribute", "Element.setIdAttribute");
        NAME_TO_FQN.put("setIdAttributeNS", "Element.setIdAttributeNS");
        NAME_TO_FQN.put("setIdAttributeNode", "Element.setIdAttributeNode");
        NAME_TO_FQN.put("setNamedItemNS", "NamedNodeMap.setNamedItemNS");
        NAME_TO_FQN.put("setStart", "Range.setStart");
        NAME_TO_FQN.put("setStartAfter", "Range.setStartAfter");
        NAME_TO_FQN.put("setStartBefore", "Range.setStartBefore");
        NAME_TO_FQN.put("setTransform", "CanvasRenderingContext2D.setTransform");
        NAME_TO_FQN.put("setUserData", "Node.setUserData");
        NAME_TO_FQN.put("stroke", "CanvasRenderingContext2D.stroke");
        NAME_TO_FQN.put("strokeRect", "CanvasRenderingContext2D.strokeRect");
        NAME_TO_FQN.put("substringData", "Node.substringData");
        NAME_TO_FQN.put("surroundContents", "Range.surroundContents");
        NAME_TO_FQN.put("swapNode", "Node.swapNode");
        NAME_TO_FQN.put("toDataURL", "HTMLCanvasElement.toDataURL");
        NAME_TO_FQN.put("transform", "CanvasRenderingContext2D.transform");
        NAME_TO_FQN.put("translate", "CanvasRenderingContext2D.translate");
        MUST_CHECK_FQN.put("TreeWalker.previousNode", Boolean.FALSE);
        MUST_CHECK_FQN.put("TreeWalker.nextNode", Boolean.FALSE);
        MUST_CHECK_FQN.put("Range.detach", Boolean.FALSE);
        MUST_CHECK_FQN.put("Document.getElementsByTagNameNS", Boolean.FALSE);
        MUST_CHECK_FQN.put("Element.hasAttributes", Boolean.FALSE);
        MUST_CHECK_FQN.put("NameList.contains", Boolean.FALSE);
    }

    private static class ChangeTargetFix
    implements HintFix {
        ChangeTargetFix() {
        }

        public String getDescription() {
            return NbBundle.getMessage(UnsupportedCalls.class, (String)"ChangeBrowserTargets");
        }

        public void implement() throws Exception {
            OptionsDisplayer.getDefault().open("Advanced/JsOptions");
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }

    private static class ShowDetails
    implements HintFix {
        private EnumSet<BrowserVersion> compat;
        private JsParseResult info;
        private String fqn;

        ShowDetails(JsParseResult jsParseResult, String string, EnumSet<BrowserVersion> enumSet) {
            this.info = jsParseResult;
            this.fqn = string;
            this.compat = enumSet;
        }

        public String getDescription() {
            return NbBundle.getMessage(UnsupportedCalls.class, (String)"ShowUnsupportedDetails");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void implement() throws Exception {
            BrowserVersion browserVersion2;
            String string;
            Object object;
            Serializable serializable;
            String string2;
            String string3;
            int n = this.fqn.lastIndexOf(46);
            if (n != -1) {
                string3 = this.fqn.substring(n + 1);
                string2 = this.fqn.substring(0, n);
            } else {
                string3 = "";
                string2 = this.fqn;
            }
            Set set = Collections.emptySet();
            if (set.size() > 0) {
                serializable = (IndexedElement)set.iterator().next();
                object = ElementUtilities.getSignature((Element)serializable);
                string = "<html><body>" + (String)object + "</body></html>";
            } else {
                serializable = new StringBuilder();
                ((StringBuilder)serializable).append("<p style=\"background:#ffcccc\">");
                ((StringBuilder)serializable).append(NbBundle.getMessage(UnsupportedCalls.class, (String)"NotSupportedBr"));
                ((StringBuilder)serializable).append("\n");
                ((StringBuilder)serializable).append("<ul>");
                for (BrowserVersion browserVersion2 : BrowserVersion.ALL) {
                    if (!SupportedBrowsers.getInstance().isSupported(browserVersion2) || this.compat.contains(browserVersion2)) continue;
                    ((StringBuilder)serializable).append("<li>");
                    ((StringBuilder)serializable).append(browserVersion2.getDisplayName());
                }
                ((StringBuilder)serializable).append("</ul>\n");
                ((StringBuilder)serializable).append("\n");
                ((StringBuilder)serializable).append("</p>");
                string = "<html><body>" + ((StringBuilder)serializable).toString() + "</body></html>";
            }
            serializable = new JButton(NbBundle.getMessage(UnsupportedCalls.class, (String)"CTL_Close"));
            object = new JLabel(string);
            ((JComponent)object).setBorder(new EmptyBorder(12, 12, 11, 11));
            browserVersion2 = new DialogDescriptor(object, this.fqn, true, new Object[]{serializable}, (Object)serializable, 0, new HelpCtx(UnsupportedCalls.class), null);
            Dialog dialog = null;
            try {
                dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)browserVersion2);
                dialog.setVisible(true);
            }
            finally {
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }

    private class SkipFunction
    implements HintFix {
        private String fqn;
        private JsRuleContext context;

        SkipFunction(JsRuleContext jsRuleContext, String string) {
            this.context = jsRuleContext;
            this.fqn = string;
        }

        public String getDescription() {
            return NbBundle.getMessage(UnsupportedCalls.class, (String)"SkipFunction", (Object)this.fqn);
        }

        public void implement() throws Exception {
            UnsupportedCalls.this.skip(this.fqn);
            this.context.manager.refreshHints((RuleContext)this.context);
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

