/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.admin.payload.TextPayloadImpl;
import org.glassfish.admin.payload.ZipPayloadImpl;
import org.glassfish.api.admin.Payload;

public class PayloadImpl
implements Payload {

    public static abstract class Inbound
    implements Payload.Inbound {
        private static final Inbound EMPTY_PAYLOAD = new Inbound(){

            public Iterator<Payload.Part> parts() {
                return Collections.EMPTY_LIST.iterator();
            }
        };

        public static Inbound newInstance(String payloadContentType, InputStream is) throws IOException {
            if (payloadContentType == null) {
                return EMPTY_PAYLOAD;
            }
            if (TextPayloadImpl.Inbound.supportsContentType(payloadContentType)) {
                return TextPayloadImpl.Inbound.newInstance(payloadContentType, is);
            }
            if (ZipPayloadImpl.Inbound.supportsContentType(payloadContentType)) {
                return ZipPayloadImpl.Inbound.newInstance(payloadContentType, is);
            }
            return null;
        }

        public String getHeaderName() {
            return "org.glassfish.payload.admin.data";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Outbound
    implements Payload.Outbound {
        private final ArrayList<Payload.Part> parts = new ArrayList();

        public void addPart(String contentType, String name, Properties props, String content) throws IOException {
            this.parts.add(Part.newInstance(contentType, name, props, content));
        }

        public void addPart(String contentType, String name, Properties props, InputStream content) throws IOException {
            this.parts.add(Part.newInstance(contentType, name, props, content));
        }

        public void addPart(int index, String contentType, String name, Properties props, InputStream content) throws IOException {
            this.parts.add(index, Part.newInstance(contentType, name, props, content));
        }

        public void attachFile(String contentType, URI fileURI, String dataRequestName, File file) throws IOException {
            this.attachFile(contentType, fileURI, dataRequestName, null, file, false);
        }

        public void attachFile(String contentType, URI fileURI, String dataRequestName, File file, boolean isRecursive) throws IOException {
            this.attachFile(contentType, fileURI, dataRequestName, null, file, isRecursive);
        }

        public void attachFile(String contentType, URI fileURI, String dataRequestName, Properties props, File file) throws IOException {
            this.attachFile(contentType, fileURI, dataRequestName, props, file, false);
        }

        public void attachFile(String contentType, URI fileURI, String dataRequestName, Properties props, File file, boolean isRecursive) throws IOException {
            Properties enhancedProps = new Properties();
            if (props != null) {
                enhancedProps.putAll((Map<?, ?>)props);
            }
            enhancedProps.setProperty("data-request-type", "file-xfer");
            enhancedProps.setProperty("data-request-name", dataRequestName);
            enhancedProps.setProperty("data-request-is-recursive", Boolean.toString(isRecursive));
            enhancedProps.setProperty("last-modified", Long.toString(file.lastModified()));
            if (file.isDirectory() && isRecursive) {
                String relativeURIPath = fileURI.getRawPath();
                if (relativeURIPath.endsWith("/")) {
                    relativeURIPath = relativeURIPath.substring(0, relativeURIPath.length() - 1);
                }
                relativeURIPath = relativeURIPath.substring(0, relativeURIPath.lastIndexOf("/") + 1);
                this.attachFilesRecursively(file.getParentFile().toURI(), URI.create(relativeURIPath), fileURI, dataRequestName, enhancedProps, file);
            } else {
                this.parts.add(Part.newInstance(contentType, fileURI.getRawPath(), enhancedProps, file.isDirectory() ? null : file));
            }
        }

        public void requestFileReplacement(String contentType, URI fileURI, String dataRequestName, Properties props, File file, boolean isRecursive) throws IOException {
            Properties enhancedProps = new Properties();
            if (props != null) {
                enhancedProps.putAll((Map<?, ?>)props);
            }
            enhancedProps.setProperty("data-request-type", "file-replace");
            enhancedProps.setProperty("data-request-name", dataRequestName);
            enhancedProps.setProperty("data-request-is-recursive", Boolean.toString(isRecursive));
            enhancedProps.setProperty("last-modified", Long.toString(file.lastModified()));
            if (file.isDirectory()) {
                this.parts.add(Part.newInstance("application/octet-stream", fileURI.getRawPath(), enhancedProps, (String)null));
                if (isRecursive) {
                    enhancedProps.setProperty("data-request-type", "file-xfer");
                    this.attachContainedFilesRecursively(file.toURI(), fileURI, dataRequestName, enhancedProps, file);
                }
            } else {
                this.parts.add(Part.newInstance(contentType, fileURI.getRawPath(), enhancedProps, file));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attachContainedFilesRecursively(URI actualBaseDirAbsURI, URI targetBaseDirRelURI, String dataRequestName, Properties enhancedProps, File dirFile) throws FileNotFoundException, IOException {
            for (File f : dirFile.listFiles()) {
                if (f.isDirectory()) {
                    enhancedProps.setProperty("last-modified", Long.toString(f.lastModified()));
                    this.attachFilesRecursively(actualBaseDirAbsURI, targetBaseDirRelURI, targetBaseDirRelURI.resolve(actualBaseDirAbsURI.relativize(f.toURI())), "", enhancedProps, f);
                    continue;
                }
                String contentType = URLConnection.guessContentTypeFromName(f.getName());
                if (contentType == null) {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                    try {
                        contentType = URLConnection.guessContentTypeFromStream(is);
                        if (contentType == null) {
                            contentType = "application/octet-stream";
                        }
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                enhancedProps.setProperty("last-modified", Long.toString(f.lastModified()));
                URI fileURI = targetBaseDirRelURI.resolve(actualBaseDirAbsURI.relativize(f.toURI()));
                this.parts.add(Part.newInstance(contentType, fileURI.getRawPath(), enhancedProps, f));
            }
        }

        private void attachFilesRecursively(URI actualBaseDirAbsURI, URI targetBaseDirRelURI, URI dirFileURI, String dataRequestName, Properties enhancedProps, File dirFile) throws FileNotFoundException, IOException {
            String dirFileURIPath = dirFileURI.getRawPath();
            this.parts.add(Part.newInstance("application/octet-stream", dirFileURIPath + (dirFileURIPath.endsWith("/") ? "" : "/"), enhancedProps, (InputStream)null));
            enhancedProps.remove("data-request-name");
            this.attachContainedFilesRecursively(actualBaseDirAbsURI, targetBaseDirRelURI, dataRequestName, enhancedProps, dirFile);
        }

        public void requestFileRemoval(URI fileURI, String dataRequestName, Properties props) throws IOException {
            this.requestFileRemoval(fileURI, dataRequestName, props, false);
        }

        public void requestFileRemoval(URI fileURI, String dataRequestName, Properties props, boolean isRecursive) throws IOException {
            Properties enhancedProps = new Properties();
            if (props != null) {
                enhancedProps.putAll((Map<?, ?>)props);
            }
            enhancedProps.setProperty("data-request-type", "file-remove");
            enhancedProps.setProperty("data-request-name", dataRequestName);
            enhancedProps.setProperty("data-request-is-recursive", Boolean.toString(isRecursive));
            this.parts.add(Part.newInstance("application/octet-stream", fileURI.getRawPath(), enhancedProps, (String)null));
        }

        public String getHeaderName() {
            return "org.glassfish.payload.admin.data";
        }

        public String getContentType() {
            return this.isComplex() ? this.getComplexContentType() : this.getSinglePartContentType();
        }

        ArrayList<Payload.Part> getParts() {
            return this.parts;
        }

        abstract void writePartsTo(OutputStream var1) throws IOException;

        public void writeTo(OutputStream os) throws IOException {
            if (this.isComplex()) {
                this.writePartsTo(os);
            } else {
                this.parts.get(0).copy(os);
            }
        }

        public abstract String getComplexContentType();

        private boolean isComplex(String partType) {
            return this.parts.size() > 1 || !partType.startsWith("text");
        }

        private boolean isComplex() {
            return this.isComplex(this.parts.get(0).getContentType());
        }

        String getSinglePartContentType() {
            String partType = this.parts.get(0).getContentType();
            if (this.isComplex(partType)) {
                return this.getComplexContentType();
            }
            return partType;
        }

        public static Outbound newInstance() {
            return ZipPayloadImpl.Outbound.newInstance();
        }
    }

    public static abstract class Part
    implements Payload.Part {
        private static final Logger logger = LogDomains.getLogger(PayloadImpl.class, "javax.enterprise.system.core");
        private String name;
        private String contentType;
        private Properties props;
        private boolean isRecursive;

        Part(String contentType, String name, Properties props) {
            this.contentType = contentType;
            this.name = name;
            this.props = new Properties();
            if (props != null) {
                this.props.putAll((Map<?, ?>)props);
            }
            this.isRecursive = Boolean.valueOf(this.props.getProperty("data-request-is-recursive"));
        }

        public String getName() {
            return this.name;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Properties getProperties() {
            return this.props;
        }

        public boolean isRecursive() {
            return this.isRecursive;
        }

        public static Part newInstance(String contentType, String name, Properties props, InputStream is) {
            return new Streamed(contentType, name, props, is);
        }

        public static Part newInstance(String contentType, String name, Properties props, String content) {
            return new Buffered(contentType, name, props, content);
        }

        public static Part newInstance(String contentType, String name, Properties props, File file) throws FileNotFoundException {
            return new Filed(contentType, name, props, file);
        }

        public void copy(OutputStream os) throws IOException {
            byte[] buffer = new byte[1024];
            InputStream is = this.getInputStream();
            if (is != null) {
                int bytesRead;
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
        }

        static class Buffered
        extends Part {
            private final String content;
            private InputStream is = null;

            Buffered(String contentType, String name, Properties props, String content) {
                super(contentType, name, props);
                this.content = content;
            }

            public InputStream getInputStream() {
                if (this.is == null) {
                    byte[] data = this.content != null ? this.content.getBytes() : new byte[]{};
                    this.is = new ByteArrayInputStream(data);
                }
                return this.is;
            }
        }

        static class Filed
        extends Part {
            private final File file;

            Filed(String contentType, String name, Properties props, File file) throws FileNotFoundException {
                super(contentType, name, props);
                this.file = file;
                this.validateFile(file);
            }

            public InputStream getInputStream() {
                try {
                    return this.file != null ? new SelfClosingInputStream(new BufferedInputStream(new FileInputStream(this.file))) : this.dummyStream();
                }
                catch (FileNotFoundException ex) {
                    return null;
                }
            }

            private void validateFile(File f) throws FileNotFoundException {
                if (f != null && !f.canRead()) {
                    throw new FileNotFoundException(f.getAbsolutePath());
                }
            }

            private InputStream dummyStream() {
                return new ByteArrayInputStream(new byte[0]);
            }

            private static class SelfClosingInputStream
            extends InputStream {
                private final InputStream wrappedStream;
                private boolean isWrappedStreamClosed = false;
                private boolean isExternallyClosed = false;

                private SelfClosingInputStream(InputStream wrappedStream) {
                    this.wrappedStream = wrappedStream;
                }

                public int read() throws IOException {
                    if (this.isExternallyClosed) {
                        throw new IOException();
                    }
                    if (this.isWrappedStreamClosed) {
                        return -1;
                    }
                    int result = this.wrappedStream.read();
                    if (result == -1) {
                        this.closeInternally();
                    }
                    return result;
                }

                public long skip(long n) throws IOException {
                    return this.wrappedStream.skip(n);
                }

                public int available() throws IOException {
                    return this.wrappedStream.available();
                }

                public synchronized void mark(int readlimit) {
                    this.wrappedStream.mark(readlimit);
                }

                public boolean markSupported() {
                    return this.wrappedStream.markSupported();
                }

                public synchronized void reset() throws IOException {
                    this.wrappedStream.reset();
                }

                public void close() throws IOException {
                    this.closeInternally();
                    this.isExternallyClosed = true;
                }

                private void closeInternally() throws IOException {
                    this.wrappedStream.close();
                    this.isWrappedStreamClosed = true;
                }
            }
        }

        static class Streamed
        extends Part {
            private final InputStream is;

            Streamed(String contentType, String name, Properties props, InputStream is) {
                super(contentType, name, props);
                this.is = is;
            }

            public InputStream getInputStream() {
                return this.is;
            }
        }
    }
}

