/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.pmd.codedefects.tasklist;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.IRuleViolation;
import org.nbheaven.sqe.core.java.search.SearchUtilities;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDResult;
import org.nbheaven.sqe.tools.pmd.codedefects.core.PMDSession;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PMDTaskProvider
extends PushTaskScanner {
    public PMDTaskProvider() {
        super("PMD", "PMD found Errors", null);
    }

    public synchronized void setScope(TaskScanningScope taskScanningScope, PushTaskScanner.Callback callback) {
        if (taskScanningScope == null || callback == null) {
            return;
        }
        for (FileObject file : taskScanningScope.getLookup().lookupAll(FileObject.class)) {
            Project project = FileOwnerQuery.getOwner((FileObject)file);
            if (null == project || null == project.getLookup().lookup(PMDSession.class) || null == JavaSource.forFileObject((FileObject)file)) continue;
            PMDResult result = this.getResult(file);
            Map instanceByClass = result.getInstanceByClass();
            Collection classes = SearchUtilities.getFQNClassNames((FileObject)file);
            LinkedList<Task> tasks = new LinkedList<Task>();
            for (String className : classes) {
                for (Object key : instanceByClass.keySet()) {
                    PMDResult.ClassKey classKey = (PMDResult.ClassKey)key;
                    if (!classKey.getClassName().equals(className)) continue;
                    Collection bugs = (Collection)instanceByClass.get(classKey);
                    tasks.addAll(this.getTasks(bugs, file));
                }
            }
            callback.setTasks(file, tasks);
        }
        for (Project project : taskScanningScope.getLookup().lookupAll(Project.class)) {
            PMDResult result;
            if (null == project.getLookup().lookup(PMDSession.class) || (result = this.getResult(project)) == null) continue;
            LinkedList<Task> tasks = new LinkedList<Task>();
            for (Map.Entry classKey : result.getInstanceByClass().entrySet()) {
                tasks.addAll(this.getTasks((Collection)classKey.getValue(), ((PMDResult.ClassKey)classKey.getKey()).getFileObject()));
            }
            callback.setTasks(project.getProjectDirectory(), tasks);
        }
    }

    private List<Task> getTasks(Collection<IRuleViolation> bugs, FileObject file) {
        if (file == null) {
            return Collections.emptyList();
        }
        LinkedList<Task> tasks = new LinkedList<Task>();
        for (IRuleViolation ruleViolation : bugs) {
            tasks.add(Task.create((FileObject)file, (String)"sqe-tasklist-pmd", (String)ruleViolation.getDescription(), (int)ruleViolation.getBeginLine()));
        }
        return tasks;
    }

    private PMDResult getResult(FileObject fileObject) {
        return this.getResult(FileOwnerQuery.getOwner((FileObject)fileObject));
    }

    private PMDResult getResult(Project project) {
        PMDSession qualitySession = (PMDSession)project.getLookup().lookup(PMDSession.class);
        PMDResult result = qualitySession.getResult();
        if (null == result) {
            result = qualitySession.computeResultAndWait();
        }
        return result;
    }
}

