/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.PropertyType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SpringRefactorings {
    private static final Logger LOGGER = Logger.getLogger(SpringRefactorings.class.getName());
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static boolean isJavaFile(FileObject fo) {
        return JAVA_MIME_TYPE.equals(fo.getMIMEType());
    }

    public static RenamedProperty getRenamedProperty(final TreePathHandle oldHandle, JavaSource javaSource, final String newName) throws IOException {
        final RenamedProperty[] result = new RenamedProperty[]{null};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Element element = oldHandle.resolveElement((CompilationInfo)cc);
                if (element == null || element.getKind() != ElementKind.METHOD) {
                    return;
                }
                PropertyType type = null;
                ExecutableElement ee = (ExecutableElement)element;
                if (JavaUtils.isGetter(ee)) {
                    type = PropertyType.READ_ONLY;
                } else if (JavaUtils.isSetter(ee)) {
                    type = PropertyType.WRITE_ONLY;
                } else {
                    return;
                }
                Collection<ElementHandle<ExecutableElement>> methodHandles = JavaUtils.getOverridenMethodsAsHandles(ee, (CompilationInfo)cc);
                methodHandles = new ArrayList<ElementHandle<ExecutableElement>>(methodHandles);
                methodHandles.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)ee));
                String oldName = JavaUtils.getPropertyName(element.getSimpleName().toString());
                element = element.getEnclosingElement();
                result[0] = new RenamedProperty(methodHandles, oldName, JavaUtils.getPropertyName(newName), type);
            }
        }, true);
        return result[0];
    }

    public static RenamedClassName getRenamedClassName(final TreePathHandle oldHandle, JavaSource javaSource, final String newName) throws IOException {
        final RenamedClassName[] result = new RenamedClassName[]{null};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Element element = oldHandle.resolveElement((CompilationInfo)cc);
                if (element == null || element.getKind() != ElementKind.CLASS) {
                    return;
                }
                String oldBinaryName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element));
                String oldSimpleName = element.getSimpleName().toString();
                String newBinaryName = null;
                if ((element = element.getEnclosingElement()).getKind() == ElementKind.CLASS) {
                    newBinaryName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)) + '$' + newName;
                } else if (element.getKind() == ElementKind.PACKAGE) {
                    String packageName = ((PackageElement)element).getQualifiedName().toString();
                    newBinaryName = SpringRefactorings.createQualifiedName(packageName, newName);
                } else {
                    LOGGER.log(Level.WARNING, "Enclosing element of {0} was neither class nor package", oldHandle);
                }
                result[0] = new RenamedClassName(oldSimpleName, oldBinaryName, newBinaryName);
            }
        }, true);
        return result[0];
    }

    public static List<String> getTopLevelClassNames(FileObject fo) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
        if (javaSource == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> result = new ArrayList<String>(1);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (TypeElement typeElement : cc.getTopLevelElements()) {
                    result.add(ElementUtilities.getBinaryName((TypeElement)typeElement));
                }
            }
        }, true);
        return result;
    }

    public static String getPackageName(FileObject folder) {
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (cp != null) {
            return cp.getResourceName(folder, '.', false);
        }
        return null;
    }

    public static String getRenamedPackageName(FileObject folder, String newName) {
        FileObject parent = folder.getParent();
        if (parent == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)parent, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        String parentName = cp.getResourceName(parent, '.', false);
        if (parentName == null) {
            return null;
        }
        if (parentName.length() > 0) {
            return parentName + '.' + newName;
        }
        return newName;
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            String path = URLDecoder.decode(url.getPath(), "UTF-8");
            f = FileUtil.normalizeFile((File)new File(path));
        }
        catch (UnsupportedEncodingException u) {
            throw new IllegalArgumentException("Cannot create package name for URL " + url);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return SpringRefactorings.getPackageName(fo);
                }
                String prefix = SpringRefactorings.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            try {
                suffix = URLDecoder.decode(f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1), "UTF-8") + suffix;
            }
            catch (UnsupportedEncodingException u) {
                throw new IllegalArgumentException("Cannot create package name for URL " + url);
            }
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for URL " + url);
    }

    public static String getSimpleElementName(String elementName) {
        int lastDot;
        while (true) {
            if (elementName.length() == 0) {
                return elementName;
            }
            lastDot = elementName.lastIndexOf(46);
            if (lastDot == -1) {
                return elementName;
            }
            if (lastDot != elementName.length() - 1) break;
            elementName = elementName.substring(0, lastDot);
        }
        return elementName.substring(lastDot + 1);
    }

    public static String createQualifiedName(String packageName, String simpleName) {
        if (packageName.length() == 0) {
            return simpleName;
        }
        if (simpleName.length() == 0) {
            return packageName;
        }
        return packageName + '.' + simpleName;
    }

    public static final class RenamedClassName {
        private final String oldSimpleName;
        private final String oldBinaryName;
        private final String newBinaryName;

        public RenamedClassName(String oldSimpleName, String oldBinaryName, String newBinaryName) {
            this.oldSimpleName = oldSimpleName;
            this.oldBinaryName = oldBinaryName;
            this.newBinaryName = newBinaryName;
        }

        public String getOldSimpleName() {
            return this.oldSimpleName;
        }

        public String getOldBinaryName() {
            return this.oldBinaryName;
        }

        public String getNewBinaryName() {
            return this.newBinaryName;
        }
    }

    public static final class RenamedProperty {
        private final String oldName;
        private final String newName;
        private final PropertyType type;
        private final Collection<ElementHandle<ExecutableElement>> methodHandles;

        public RenamedProperty(Collection<ElementHandle<ExecutableElement>> methodHandles, String oldName, String newName, PropertyType type) {
            this.methodHandles = methodHandles;
            this.oldName = oldName;
            this.newName = newName;
            this.type = type;
        }

        public String getNewName() {
            return this.newName;
        }

        public String getOldName() {
            return this.oldName;
        }

        public PropertyType getType() {
            return this.type;
        }

        public Collection<ElementHandle<ExecutableElement>> getMethodHandles() {
            return this.methodHandles;
        }
    }
}

