/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

public class SpringConfigFileModelController {
    private static final Logger LOGGER = Logger.getLogger(SpringConfigFileModelController.class.getName());
    private static final int DELAY = 500;
    private final ConfigFileSpringBeanSource beanSource;
    private final File file;
    private boolean parsedAtLeastOnce;
    private ExclusiveAccess.AsyncTask currentUpdateTask;
    private FileObject currentFile;

    public SpringConfigFileModelController(File file, ConfigFileSpringBeanSource beanSource) {
        this.file = file;
        this.beanSource = beanSource;
    }

    public SpringBeanSource getUpToDateBeanSource() throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        FileObject fo = this.getFileToMakeUpToDate();
        if (fo != null) {
            this.doParse(fo, false);
        }
        return this.beanSource;
    }

    public LockedDocument getLockedDocument() throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        FileObject fo = this.getFileToMakeUpToDate();
        if (fo == null) {
            fo = FileUtil.toFileObject((File)this.file);
        }
        if (fo != null) {
            return new LockedDocument(fo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getFileToMakeUpToDate() throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        FileObject fileToParse = null;
        SpringConfigFileModelController springConfigFileModelController = this;
        synchronized (springConfigFileModelController) {
            if (this.currentUpdateTask == null || this.currentUpdateTask.isFinished()) {
                if (!this.parsedAtLeastOnce) {
                    fileToParse = FileUtil.toFileObject((File)this.file);
                }
            } else {
                fileToParse = this.currentFile;
            }
        }
        return fileToParse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse(FileObject fo, boolean updateTask) throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        BaseDocument document = (BaseDocument)SpringConfigFileModelController.getEditorCookie(fo).openDocument();
        document.readLock();
        try {
            this.doParse(fo, document, updateTask);
        }
        finally {
            document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParse(FileObject fo, BaseDocument document, boolean updateTask) throws IOException {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
        this.beanSource.parse(document);
        SpringConfigFileModelController springConfigFileModelController = this;
        synchronized (springConfigFileModelController) {
            if (!this.parsedAtLeastOnce) {
                this.parsedAtLeastOnce = true;
            }
            if (!updateTask && fo.equals(this.currentFile)) {
                LOGGER.log(Level.FINE, "Canceling update task for " + this.currentFile);
                this.currentUpdateTask.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChange(FileObject configFO) {
        assert (configFO != null);
        LOGGER.log(Level.FINE, "Scheduling update for {0}", configFO);
        SpringConfigFileModelController springConfigFileModelController = this;
        synchronized (springConfigFileModelController) {
            if (configFO != this.currentFile) {
                if (this.currentUpdateTask != null) {
                    this.currentUpdateTask.cancel();
                }
                this.currentFile = configFO;
                this.currentUpdateTask = ExclusiveAccess.getInstance().createAsyncTask(new Updater(configFO));
            }
            this.currentUpdateTask.schedule(500);
        }
    }

    private static EditorCookie getEditorCookie(FileObject fo) throws IOException {
        DataObject dataObject = DataObject.find((FileObject)fo);
        EditorCookie result = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (result == null) {
            throw new IllegalStateException("File " + fo + " does not have an EditorCookie.");
        }
        return result;
    }

    public final class LockedDocument {
        private final FileObject fo;
        private final CloneableEditorSupport editor;
        final BaseDocument document;
        private final AtomicBoolean locked = new AtomicBoolean();
        private final AtomicBoolean unlocked = new AtomicBoolean();

        public LockedDocument(FileObject fo) throws IOException {
            this.fo = fo;
            this.editor = (CloneableEditorSupport)SpringConfigFileModelController.getEditorCookie(fo);
            this.document = (BaseDocument)this.editor.openDocument();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() throws IOException {
            if (!this.locked.getAndSet(true)) {
                this.document.atomicLock();
                boolean success = false;
                try {
                    SpringConfigFileModelController.this.doParse(this.fo, this.document, false);
                    success = true;
                }
                finally {
                    if (!success) {
                        this.document.atomicUnlock();
                    }
                }
            }
        }

        public void unlock() throws IOException {
            assert (this.locked.get());
            if (!this.unlocked.getAndSet(true)) {
                this.document.atomicUnlock();
            }
        }

        public BaseDocument getDocument() {
            assert (this.locked.get());
            return this.document;
        }

        public SpringBeanSource getBeanSource() throws IOException {
            assert (this.locked.get());
            return SpringConfigFileModelController.this.beanSource;
        }

        public PositionRef createPositionRef(int offset, Position.Bias bias) {
            assert (this.locked.get());
            return this.editor.createPositionRef(offset, bias);
        }
    }

    private final class Updater
    implements Runnable {
        private final FileObject configFile;

        public Updater(FileObject configFile) {
            this.configFile = configFile;
        }

        @Override
        public void run() {
            LOGGER.log(Level.FINE, "Running scheduled update for file {0}", this.configFile);
            assert (ExclusiveAccess.getInstance().isCurrentThreadAccess());
            try {
                SpringConfigFileModelController.this.doParse(this.configFile, true);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }
}

