/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorRegistry;
import org.netbeans.modules.spring.beans.completion.SpringCompletionResult;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.spring.beans.index.SpringIndex;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;

public class SpringXMLConfigCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 1) == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new SpringXMLConfigCompletionQuery(queryType), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static class SpringXMLConfigCompletionQuery
    extends AsyncCompletionQuery {
        private final int queryType;
        private JTextComponent component;
        private volatile Completor completor;

        public SpringXMLConfigCompletionQuery(int queryType) {
            this.queryType = queryType;
        }

        protected void preQueryUpdate(JTextComponent component) {
            this.component = component;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            CompletionContext context = new CompletionContext(doc, caretOffset, this.queryType);
            if (context.getCompletionType() == CompletionContext.CompletionType.NONE) {
                resultSet.finish();
                return;
            }
            SpringXMLConfigDocumentListener listener = SpringXMLConfigDocumentListener.getListener(context.getDocumentContext());
            doc.removeDocumentListener(listener);
            doc.addDocumentListener(listener);
            this.completor = CompletorRegistry.getDefault().getCompletor(context);
            if (this.completor != null) {
                SpringCompletionResult springCompletionResult = this.completor.complete(context);
                this.populateResultSet(resultSet, springCompletionResult);
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            if (this.completor == null) {
                return false;
            }
            boolean retVal = this.completor.canFilter(new CompletionContext(component.getDocument(), component.getCaretPosition(), this.queryType));
            if (!retVal && this.completor != null) {
                this.completor.cancel();
            }
            return retVal;
        }

        protected void filter(CompletionResultSet resultSet) {
            CompletionContext context = new CompletionContext(this.component.getDocument(), this.component.getCaretPosition(), this.queryType);
            SpringCompletionResult springCompletionResult = this.completor.filter(context);
            this.populateResultSet(resultSet, springCompletionResult);
            resultSet.finish();
        }

        private void populateResultSet(CompletionResultSet resultSet, SpringCompletionResult springCompletionResult) {
            if (springCompletionResult == SpringCompletionResult.NONE) {
                return;
            }
            resultSet.addAllItems(springCompletionResult.getItems());
            if (this.completor.getAnchorOffset() != -1) {
                resultSet.setAnchorOffset(this.completor.getAnchorOffset());
            }
            if (springCompletionResult.hasAdditionalItems()) {
                resultSet.setHasAdditionalItems(true);
                resultSet.setHasAdditionalItemsText(springCompletionResult.getAdditionalItemsText());
            }
        }
    }

    private static class SpringXMLConfigDocumentListener
    implements DocumentListener {
        private static Map<String, String> declaredNamespaces;
        private static SpringXMLConfigDocumentListener listener;

        private SpringXMLConfigDocumentListener(DocumentContext docContext) {
            SpringXMLConfigDocumentListener.updateDeclaredNamespaces(docContext);
        }

        public static SpringXMLConfigDocumentListener getListener(DocumentContext docContext) {
            if (listener == null) {
                listener = new SpringXMLConfigDocumentListener(docContext);
            } else {
                SpringXMLConfigDocumentListener.updateDeclaredNamespaces(docContext);
            }
            return listener;
        }

        private static void updateDeclaredNamespaces(DocumentContext docContext) {
            declaredNamespaces = docContext.getDeclaredNamespacesMap();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            int length = evt.getLength();
            int offset = evt.getOffset();
            try {
                Document doc = evt.getDocument();
                String text = evt.getDocument().getText(offset, length).trim();
                if (text.startsWith("xmlns:")) {
                    String namespace = this.parseNamespace(text);
                    if (!declaredNamespaces.values().contains(namespace)) {
                        String schemaLocation = this.findSchemaLocation(doc, namespace);
                        this.updateSchemaLocation(doc, offset, namespace, schemaLocation);
                    }
                    evt.getDocument().removeDocumentListener(this);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            evt.getDocument().removeDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
            evt.getDocument().removeDocumentListener(this);
        }

        void updateSchemaLocation(Document doc, final int offset, final String namespace, final String schemaLocation) {
            BaseDocument baseDoc = (BaseDocument)doc;
            final XMLSyntaxSupport syntaxSupport = (XMLSyntaxSupport)baseDoc.getSyntaxSupport();
            baseDoc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        String val;
                        Attr attr;
                        SyntaxElement element = syntaxSupport.getElementChain(offset);
                        if (element instanceof StartTag && (attr = ((StartTag)element).getAttributeNode("xsi:schemaLocation")) != null && (val = attr.getValue()).indexOf(namespace) == -1) {
                            attr.setValue(val + "\n       " + namespace + " " + schemaLocation);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        String parseNamespace(String text) {
            String namespace = text.substring(text.indexOf(34) + 1, text.length() - 1);
            return namespace;
        }

        String findSchemaLocation(Document document, String namespace) {
            FileObject fo = NbEditorUtilities.getFileObject((Document)document);
            Map<String, FileObject> map = new SpringIndex(fo).getAllSpringLibraryDescriptors();
            for (String ns : map.keySet()) {
                if (!ns.equals(namespace)) continue;
                FileObject file = map.get(ns);
                return namespace + "/" + file.getNameExt();
            }
            throw new UnsupportedOperationException("schemaLocation not found");
        }
    }
}

