/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

public class CompletionContext {
    private ArrayList<String> existingAttributes;
    private CompletionType completionType = CompletionType.NONE;
    private int caretOffset;
    private DocumentContext documentContext;
    private String typedChars = "";
    private char lastTypedChar;
    private XMLSyntaxSupport support;
    private FileObject fileObject;
    private BaseDocument internalDoc = new BaseDocument(true, "text/xml");
    private int queryType;

    public CompletionContext(Document doc, int caretOffset, int queryType) {
        this.caretOffset = caretOffset;
        this.fileObject = NbEditorUtilities.getFileObject((Document)doc);
        this.queryType = queryType;
        this.initContext((BaseDocument)doc);
    }

    private void initContext(BaseDocument bDoc) {
        boolean copyResult = this.copyDocument(bDoc, this.internalDoc);
        if (!copyResult) {
            return;
        }
        Object sdp = bDoc.getProperty((Object)"stream");
        this.internalDoc.putProperty((Object)"stream", sdp);
        this.support = (XMLSyntaxSupport)this.internalDoc.getSyntaxSupport();
        this.documentContext = DocumentContext.create((Document)this.internalDoc, this.caretOffset);
        this.lastTypedChar = ((XMLSyntaxSupport)bDoc.getSyntaxSupport()).lastTypedChar();
        if (this.documentContext == null) {
            return;
        }
        TokenItem token = this.documentContext.getCurrentToken();
        if (token == null) {
            return;
        }
        if (token.getTokenID().getNumericID() == 3 && token.getImage().equals("/")) {
            token = new WsToken(this.caretOffset, token);
        }
        boolean tokenBoundary = token.getOffset() == this.caretOffset || token.getOffset() + token.getImage().length() == this.caretOffset;
        int id = token.getTokenID().getNumericID();
        SyntaxElement element = this.documentContext.getCurrentElement();
        switch (id) {
            case 1: {
                String chars = token.getImage().trim();
                if (chars != null && chars.equals("") && token.getPrevious().getImage().trim().equals("/>")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.equals("") && token.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (chars != null && !chars.equals("<") && token.getPrevious().getImage().trim().equals(">")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.startsWith("<")) {
                    this.typedChars = chars.substring(1);
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 4: {
                if (element instanceof EndTag) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (element instanceof EmptyTag) {
                    if (token != null && token.getImage().trim().equals("/>")) {
                        TokenItem prevToken = token.getPrevious();
                        if (prevToken != null && prevToken.getTokenID().getNumericID() == 2 && this.caretOffset == token.getOffset()) {
                            this.completionType = CompletionType.ATTRIBUTE;
                            break;
                        }
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    EmptyTag tag = (EmptyTag)element;
                    if (element.getElementOffset() + 1 == this.caretOffset) {
                        this.completionType = CompletionType.TAG;
                        break;
                    }
                    if (this.caretOffset > element.getElementOffset() + 1 && this.caretOffset <= element.getElementOffset() + 1 + tag.getTagName().length()) {
                        this.completionType = CompletionType.TAG;
                        this.typedChars = tag.getTagName();
                        break;
                    }
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (element instanceof StartTag) {
                    if (token != null && token.getImage().trim().equals(">")) {
                        TokenItem prevToken = token.getPrevious();
                        if (prevToken != null && prevToken.getTokenID().getNumericID() == 2 && this.caretOffset == token.getOffset()) {
                            this.completionType = CompletionType.ATTRIBUTE;
                            break;
                        }
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (element.getElementOffset() + 1 != this.caretOffset) {
                        StartTag tag = (StartTag)element;
                        this.typedChars = tag.getTagName();
                    }
                }
                if (this.lastTypedChar == '>') {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case 5: {
                this.completionType = CompletionType.ATTRIBUTE;
                this.typedChars = token.getImage().substring(0, this.caretOffset - token.getOffset());
                break;
            }
            case 6: 
            case 11: {
                this.completionType = CompletionType.NONE;
                break;
            }
            case 7: {
                if (!tokenBoundary) {
                    this.completionType = CompletionType.ATTRIBUTE_VALUE;
                    this.typedChars = token.getImage().substring(1, this.caretOffset - token.getOffset());
                    break;
                }
                this.completionType = CompletionType.NONE;
                break;
            }
            case 2: {
                TokenItem prev;
                this.completionType = CompletionType.NONE;
                for (prev = token.getPrevious(); prev != null && prev.getTokenID().getNumericID() == 2; prev = prev.getPrevious()) {
                }
                if (prev.getTokenID().getNumericID() == 5 && prev.getOffset() + prev.getImage().length() == this.caretOffset) {
                    this.typedChars = prev.getImage();
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (prev.getTokenID().getNumericID() != 7 && prev.getTokenID().getNumericID() != 4 || tokenBoundary) break;
                this.completionType = CompletionType.ATTRIBUTE;
                break;
            }
            default: {
                this.completionType = CompletionType.NONE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDocument(final BaseDocument src, final BaseDocument dest) {
        final boolean[] retVal = new boolean[]{true};
        src.readLock();
        try {
            dest.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        String docText = src.getText(0, src.getLength());
                        dest.insertString(0, docText, null);
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                        retVal[0] = false;
                    }
                }
            });
        }
        finally {
            src.readUnlock();
        }
        return retVal[0];
    }

    public CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getTypedPrefix() {
        return this.typedChars;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public Node getTag() {
        SyntaxElement element = this.documentContext.getCurrentElement();
        return element instanceof Tag ? (Node)element : null;
    }

    public TokenItem getCurrentToken() {
        return this.documentContext.getCurrentToken();
    }

    public List<String> getExistingAttributes() {
        if (this.existingAttributes == null) {
            int tokenId;
            this.existingAttributes = new ArrayList();
            for (TokenItem item = this.documentContext.getCurrentToken().getPrevious(); item != null && (tokenId = item.getTokenID().getNumericID()) != 4; item = item.getPrevious()) {
                if (tokenId != 5) continue;
                this.existingAttributes.add(item.getImage());
            }
        }
        return this.existingAttributes;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public Document getDocument() {
        return this.internalDoc;
    }

    public static enum CompletionType {
        TAG,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        NONE;

    }

    private class WsToken
    implements TokenItem {
        private final int caretOffset;
        private final TokenItem currentToken;

        public WsToken(int caretOffset, TokenItem currentToken) {
            this.caretOffset = caretOffset;
            this.currentToken = currentToken;
        }

        public TokenID getTokenID() {
            return XMLDefaultTokenContext.WS;
        }

        public TokenContextPath getTokenContextPath() {
            return this.currentToken.getTokenContextPath();
        }

        public int getOffset() {
            return this.caretOffset;
        }

        public String getImage() {
            return " ";
        }

        public TokenItem getNext() {
            return this.currentToken;
        }

        public TokenItem getPrevious() {
            return this.currentToken.getPrevious();
        }
    }
}

