/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Computable;
import org.netbeans.modules.nativeexecution.support.Logger;

public final class FetchPrivilegesTask
implements Computable<ExecutionEnvironment, List<String>> {
    private static final java.util.logging.Logger log = Logger.getInstance();

    @Override
    public List<String> compute(ExecutionEnvironment execEnv) {
        NativeProcess ppriv = null;
        try {
            String command = "/usr/bin/ppriv -v $$ | grep [IL]";
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
            npb.setExecutable("/bin/sh").setArguments("-c", command);
            ppriv = npb.call();
            int result = ppriv.waitFor();
            if (result != 0) {
                throw new IOException("Unable to get current privileges. Command " + command + " failed with code " + result);
            }
            List<Object> iprivs = new ArrayList();
            List<Object> lprivs = new ArrayList();
            List<String> out = ProcessUtils.readProcessOutput(ppriv);
            for (String str : out) {
                String[] privs;
                if (str.contains("I:")) {
                    privs = str.substring(str.indexOf(": ") + 2).split(",");
                    iprivs = Arrays.asList(privs);
                    continue;
                }
                if (!str.contains("L:")) continue;
                privs = str.substring(str.indexOf(": ") + 2).split(",");
                lprivs = Arrays.asList(privs);
            }
            if (iprivs == null || lprivs == null) {
                return Collections.emptyList();
            }
            ArrayList<String> real_privs = new ArrayList<String>();
            for (String ipriv : iprivs) {
                if (!lprivs.contains(ipriv)) continue;
                real_privs.add(ipriv);
            }
            return real_privs;
        }
        catch (ConnectException ex) {
            return Collections.emptyList();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
        catch (IOException ex) {
            log.fine(ex.getMessage());
            try {
                ProcessUtils.logError(Level.FINE, log, ppriv);
            }
            catch (IOException ioex) {
                // empty catch block
            }
            return Collections.emptyList();
        }
    }
}

