/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.FileInfoProvider;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Md5checker;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

class SftpSupport {
    private static final boolean isUnitTest = Boolean.getBoolean("nativeexecution.mode.unittest");
    private static final java.util.logging.Logger LOG = Logger.getInstance();
    private static final Object instancesLock = new Object();
    private static Map<ExecutionEnvironment, SftpSupport> instances = new HashMap<ExecutionEnvironment, SftpSupport>();
    private static AtomicInteger uploadCount = new AtomicInteger(0);
    private static final int PUT_RETRY_COUNT = Integer.getInteger("sftp.put.retries", 1);
    private static int CONCURRENCY_LEVEL = Integer.getInteger("remote.sftp.threads", Runtime.getRuntime().availableProcessors() + 2);
    private static final String PREFIX = "SFTP: ";
    private final RequestProcessor requestProcessor = new RequestProcessor("SFTP: ", CONCURRENCY_LEVEL);
    private final ExecutionEnvironment execEnv;
    private LinkedList<ChannelSftp> spareChannels = new LinkedList();
    private int currBusyChannels = 0;
    private int maxBusyChannels = 0;
    private final Object channelLock = new Object();

    static int getUploadCount() {
        return uploadCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SftpSupport getInstance(ExecutionEnvironment execEnv) {
        SftpSupport instance = null;
        Object object = instancesLock;
        synchronized (object) {
            instance = instances.get(execEnv);
            if (instance == null) {
                instance = new SftpSupport(execEnv);
                instances.put(execEnv, instance);
            }
        }
        return instance;
    }

    private SftpSupport(ExecutionEnvironment execEnv) {
        this.execEnv = execEnv;
        LOG.log(Level.FINE, "SftpSupport for {0} started with maximum thread count: {1}", new Object[]{execEnv, CONCURRENCY_LEVEL});
    }

    private RequestProcessor getReadRequestProcessor() {
        return this.requestProcessor;
    }

    public RequestProcessor getWriteRuestProcessor() {
        return this.requestProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementStatistics() {
        Object object = this.channelLock;
        synchronized (object) {
            ++this.currBusyChannels;
            if (this.currBusyChannels > this.maxBusyChannels) {
                this.maxBusyChannels = this.currBusyChannels;
                Logger.getInstance().log(Level.FINEST, "SFTP max. busy channels reached: {0}", this.maxBusyChannels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementStatistics() {
        Object object = this.channelLock;
        synchronized (object) {
            --this.currBusyChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseChannel(ChannelSftp channel) {
        Object object = this.channelLock;
        synchronized (object) {
            this.spareChannels.push(channel);
            this.decrementStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelSftp getChannel() throws IOException, ConnectionManager.CancellationException, JSchException, ExecutionException, InterruptedException {
        ConnectionManagerAccessor cmAccess;
        ChannelSftp channel;
        Object object = this.channelLock;
        synchronized (object) {
            if (!this.spareChannels.isEmpty() && (channel = this.spareChannels.pop()).isConnected()) {
                this.incrementStatistics();
                return channel;
            }
        }
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            ConnectionManager.getInstance().connectTo(this.execEnv);
        }
        if ((cmAccess = ConnectionManagerAccessor.getDefault()) == null) {
            throw new ExecutionException("Error getting ConnectionManagerAccessor", new NullPointerException());
        }
        channel = (ChannelSftp)cmAccess.openAndAcquireChannel(this.execEnv, "sftp", true);
        if (channel == null) {
            throw new ExecutionException("ConnectionManagerAccessor returned null channel while waitIfNoAvailable was set to true", new NullPointerException());
        }
        channel.connect();
        this.incrementStatistics();
        return channel;
    }

    private static FileInfoProvider.SftpIOException decorateSftpException(SftpException e, String path) {
        return new FileInfoProvider.SftpIOException(e.id, e.getMessage(), path, e);
    }

    Future<CommonTasksSupport.UploadStatus> uploadFile(CommonTasksSupport.UploadParameters parameters) {
        Logger.assertTrue(((Object)parameters.dstExecEnv).equals(this.execEnv));
        Uploader uploader = new Uploader(parameters.srcFile.getAbsolutePath(), parameters.dstFileName, parameters.mask, parameters.checkMd5);
        final FutureTask<CommonTasksSupport.UploadStatus> ftask = new FutureTask<CommonTasksSupport.UploadStatus>(uploader);
        RequestProcessor.Task requestProcessorTask = this.getWriteRuestProcessor().create(ftask);
        if (parameters.callback != null) {
            final ChangeListener callback = parameters.callback;
            requestProcessorTask.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    callback.stateChanged(new ChangeEvent(ftask));
                }
            });
        }
        requestProcessorTask.schedule(0);
        LOG.log(Level.FINE, "{0} schedulled", uploader.getTraceName());
        return ftask;
    }

    Future<Integer> downloadFile(String srcFileName, String dstFileName, Writer error) {
        Downloader downloader = new Downloader(srcFileName, dstFileName, error);
        FutureTask<Integer> ftask = new FutureTask<Integer>(downloader);
        this.getReadRequestProcessor().post(ftask);
        LOG.log(Level.FINE, "{0} schedulled", downloader.getTraceName());
        return ftask;
    }

    private FileInfoProvider.StatInfo createStatInfo(String dirName, String baseName, SftpATTRS attrs, ChannelSftp cftp) throws FileInfoProvider.SftpIOException {
        String linkTarget = null;
        if (attrs.isLink()) {
            String path = dirName + '/' + baseName;
            LOG.log(Level.FINE, "performing readlink {0}", path);
            try {
                linkTarget = cftp.readlink(path);
            }
            catch (SftpException e) {
                throw SftpSupport.decorateSftpException(e, path);
            }
        }
        Date lastModified = new Date((long)attrs.getMTime() * 1000L);
        FileInfoProvider.StatInfo result = new FileInfoProvider.StatInfo(baseName, attrs.getUId(), attrs.getGId(), attrs.getSize(), attrs.isDir(), attrs.isLink(), linkTarget, attrs.getPermissions(), lastModified);
        return result;
    }

    Future<FileInfoProvider.StatInfo> stat(String absPath, Writer error) {
        StatLoader loader = new StatLoader(absPath);
        FutureTask<FileInfoProvider.StatInfo> ftask = new FutureTask<FileInfoProvider.StatInfo>(loader);
        this.getReadRequestProcessor().post(ftask);
        LOG.log(Level.FINE, "{0} schedulled", loader.getTraceName());
        return ftask;
    }

    Future<FileInfoProvider.StatInfo[]> ls(String absPath, Writer error) {
        LsLoader loader = new LsLoader(absPath);
        FutureTask<FileInfoProvider.StatInfo[]> ftask = new FutureTask<FileInfoProvider.StatInfo[]>(loader);
        this.getReadRequestProcessor().post(ftask);
        LOG.log(Level.FINE, "{0} schedulled", loader.getTraceName());
        return ftask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testSetConcurrencyLevel(int level) {
        boolean hadInstances;
        Object object = instancesLock;
        synchronized (object) {
            hadInstances = !instances.isEmpty();
            instances.clear();
        }
        CONCURRENCY_LEVEL = level;
        if (hadInstances) {
            System.err.printf("Warning: SFTP concurrency level was set while there were some %s instances\n", SftpSupport.class.getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getMaxBusyChannels() {
        Object object = this.channelLock;
        synchronized (object) {
            return this.maxBusyChannels;
        }
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result;

        static {
            $SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result = new int[Md5checker.Result.values().length];
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.UPTODATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.DIFFERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[Md5checker.Result.INEXISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private class Downloader
    extends Worker
    implements Callable<Integer> {
        protected final String srcFileName;
        protected final String dstFileName;

        public Downloader(String srcFileName, String dstFileName, Writer error) {
            super(error);
            this.srcFileName = srcFileName;
            this.dstFileName = dstFileName;
        }

        @Override
        protected void work() throws IOException, ConnectionManager.CancellationException, JSchException, SftpException, ExecutionException, InterruptedException {
            LOG.log(Level.FINE, "{0} started", this.getTraceName());
            ChannelSftp cftp = SftpSupport.this.getChannel();
            try {
                cftp.get(this.srcFileName, this.dstFileName);
            }
            catch (SftpException e) {
                throw SftpSupport.decorateSftpException(e, this.srcFileName);
            }
            finally {
                SftpSupport.this.releaseChannel(cftp);
            }
        }

        @Override
        protected String getTraceName() {
            return "Downloading " + SftpSupport.this.execEnv + ":" + this.srcFileName + " to " + this.dstFileName;
        }
    }

    private class LsLoader
    implements Callable<FileInfoProvider.StatInfo[]> {
        private final String path;

        public LsLoader(String path) {
            assert (path.startsWith("/"));
            this.path = path;
        }

        @Override
        public FileInfoProvider.StatInfo[] call() throws IOException, ConnectionManager.CancellationException, JSchException, ExecutionException, InterruptedException, SftpException {
            LOG.log(Level.FINE, "{0} started", this.getTraceName());
            List<FileInfoProvider.StatInfo> result = Collections.emptyList();
            ChannelSftp cftp = SftpSupport.this.getChannel();
            try {
                Thread.currentThread().setName("SFTP: : " + this.getTraceName());
                Vector entries = cftp.ls(this.path);
                result = new ArrayList(Math.max(1, entries.size() - 2));
                boolean i = false;
                for (ChannelSftp.LsEntry entry : entries) {
                    String name = entry.getFilename();
                    if (".".equals(name) || "..".equals(name)) continue;
                    SftpATTRS attrs = entry.getAttrs();
                    result.add(SftpSupport.this.createStatInfo(this.path, name, attrs, cftp));
                }
            }
            catch (SftpException e) {
                throw SftpSupport.decorateSftpException(e, this.path);
            }
            finally {
                SftpSupport.this.releaseChannel(cftp);
            }
            LOG.log(Level.FINE, "{0} finished", this.getTraceName());
            return result.toArray(new FileInfoProvider.StatInfo[result.size()]);
        }

        public String getTraceName() {
            return "listing directory " + this.path;
        }
    }

    private class StatLoader
    implements Callable<FileInfoProvider.StatInfo> {
        private final String path;

        public StatLoader(String path) {
            if (path.isEmpty()) {
                path = "/";
            }
            assert (path.startsWith("/"));
            this.path = path;
        }

        @Override
        public FileInfoProvider.StatInfo call() throws IOException, ConnectionManager.CancellationException, JSchException, ExecutionException, InterruptedException, SftpException {
            FileInfoProvider.StatInfo result;
            LOG.log(Level.FINE, "{0} started", this.getTraceName());
            ChannelSftp cftp = SftpSupport.this.getChannel();
            try {
                String baseName;
                String dirName;
                Thread.currentThread().setName("SFTP: : " + this.getTraceName());
                SftpATTRS attrs = cftp.lstat(this.path);
                int slashPos = this.path.lastIndexOf(47);
                if (slashPos == 0) {
                    dirName = "";
                    baseName = this.path.substring(1);
                } else {
                    dirName = this.path.substring(0, slashPos);
                    baseName = this.path.substring(slashPos + 1);
                }
                result = SftpSupport.this.createStatInfo(dirName, baseName, attrs, cftp);
            }
            catch (SftpException e) {
                throw SftpSupport.decorateSftpException(e, this.path);
            }
            finally {
                SftpSupport.this.releaseChannel(cftp);
            }
            LOG.log(Level.FINE, "{0} finished", this.getTraceName());
            return result;
        }

        public String getTraceName() {
            return "Getting stat for " + this.path;
        }
    }

    private class Uploader
    implements Callable<CommonTasksSupport.UploadStatus> {
        private final int mask;
        private final boolean checkMd5;
        protected final String srcFileName;
        protected final String dstFileName;
        protected FileInfoProvider.StatInfo statInfo;

        public Uploader(String srcFileName, String dstFileName, int mask, boolean checkMd5) {
            this.srcFileName = srcFileName;
            this.dstFileName = dstFileName;
            this.mask = mask;
            this.checkMd5 = checkMd5;
        }

        @Override
        public CommonTasksSupport.UploadStatus call() throws InterruptedException {
            StringBuilder err = new StringBuilder();
            int rc = -1;
            try {
                Thread.currentThread().setName("SFTP: : " + this.getTraceName());
                this.work(err);
                rc = 0;
            }
            catch (JSchException ex) {
                if (ex.getMessage().contains("Received message is too long: ")) {
                    if (isUnitTest) {
                        this.logException((Exception)((Object)ex));
                    } else {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SftpSupport.class, (String)"SftpConnectionReceivedMessageIsTooLong.error.text"), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                    }
                    rc = 7;
                } else {
                    this.logException((Exception)((Object)ex));
                    rc = 1;
                }
                err.append(ex.getMessage());
            }
            catch (SftpException ex) {
                err.append(ex.getMessage());
                this.logException((Exception)((Object)ex));
                rc = 2;
            }
            catch (ConnectException ex) {
                err.append(ex.getMessage());
                this.logException(ex);
                rc = 3;
            }
            catch (InterruptedIOException ex) {
                err.append(ex.getMessage());
                rc = 4;
                throw new InterruptedException(ex.getMessage());
            }
            catch (IOException ex) {
                err.append(ex.getMessage());
                this.logException(ex);
                rc = 5;
            }
            catch (ConnectionManager.CancellationException ex) {
                err.append(ex.getMessage());
                rc = 6;
            }
            catch (ExecutionException ex) {
                err.append(ex.getMessage());
                this.logException(ex);
                rc = 7;
            }
            LOG.log(Level.FINE, "{0}{1}", new Object[]{this.getTraceName(), rc == 0 ? " OK" : " FAILED"});
            return new CommonTasksSupport.UploadStatus(rc, err.toString(), this.statInfo);
        }

        protected void logException(Exception ex) {
            LOG.log(Level.INFO, "Error " + this.getTraceName(), ex);
        }

        private void work(StringBuilder err) throws IOException, ConnectionManager.CancellationException, JSchException, SftpException, InterruptedException, ExecutionException {
            boolean checkDir = false;
            if (this.checkMd5) {
                LOG.log(Level.FINE, "Md5 check for {0}:{1} started", new Object[]{SftpSupport.this.execEnv, this.dstFileName});
                Enum res = null;
                try {
                    res = new Md5checker(SftpSupport.this.execEnv).check(new File(this.srcFileName), this.dstFileName);
                }
                catch (NoSuchAlgorithmException ex) {
                    LOG.log(Level.WARNING, "Can not perform md5 check for {0}: {1}", new Object[]{SftpSupport.this.execEnv.getDisplayName(), ex.getMessage()});
                    res = HostInfoUtils.fileExists(SftpSupport.this.execEnv, this.dstFileName) ? Md5checker.Result.UPTODATE : Md5checker.Result.INEXISTENT;
                }
                catch (Md5checker.CheckSumException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    LOG.log(Level.FINE, "SftpSupport interrupted", ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                switch (2.$SwitchMap$org$netbeans$modules$nativeexecution$api$util$Md5checker$Result[res.ordinal()]) {
                    case 1: {
                        LOG.log(Level.FINE, "{0}:{1} up to date - skipped", new Object[]{SftpSupport.this.execEnv, this.dstFileName});
                        return;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        checkDir = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected MD5 check result: " + res);
                    }
                }
            }
            LOG.log(Level.FINE, "{0} started", this.getTraceName());
            ChannelSftp cftp = SftpSupport.this.getChannel();
            try {
                String baseName;
                String dirName;
                int slashPos;
                if (checkDir && (slashPos = this.dstFileName.lastIndexOf(47)) >= 0) {
                    String remoteDir = this.dstFileName.substring(0, slashPos);
                    StringWriter swr = new StringWriter();
                    CommonTasksSupport.mkDir(SftpSupport.this.execEnv, remoteDir, swr).get();
                    err.append(swr.getBuffer()).append(' ');
                }
                this.put(cftp);
                if (this.mask >= 0) {
                    cftp.chmod(this.mask, this.dstFileName);
                }
                SftpATTRS attrs = cftp.lstat(this.dstFileName);
                int slashPos2 = this.dstFileName.lastIndexOf(47);
                if (slashPos2 < 0) {
                    dirName = this.dstFileName;
                    baseName = "";
                } else {
                    dirName = this.dstFileName.substring(0, slashPos2);
                    baseName = this.dstFileName.substring(slashPos2 + 1);
                }
                this.statInfo = SftpSupport.this.createStatInfo(dirName, baseName, attrs, cftp);
            }
            catch (SftpException e) {
                throw SftpSupport.decorateSftpException(e, this.dstFileName);
            }
            finally {
                SftpSupport.this.releaseChannel(cftp);
            }
            uploadCount.incrementAndGet();
        }

        private void put(ChannelSftp cftp) throws FileInfoProvider.SftpIOException {
            int attempt = 0;
            while (true) {
                ++attempt;
                try {
                    cftp.put(this.srcFileName, this.dstFileName);
                    if (attempt > 1) {
                        LOG.log(Level.FINE, "Success on attempt {0} to copy {1} to {2}:{3} :\n", new Object[]{attempt, this.srcFileName, SftpSupport.this.execEnv, this.dstFileName});
                    }
                    return;
                }
                catch (SftpException e) {
                    if (attempt > PUT_RETRY_COUNT) {
                        throw SftpSupport.decorateSftpException(e, this.dstFileName);
                    }
                    String message = String.format("Error on attempt %d to copy %s to %s:%s :\n", attempt, this.srcFileName, SftpSupport.this.execEnv, this.dstFileName);
                    LOG.log(Level.FINE, message, e);
                    if (attempt == 2) {
                        Logger.fullThreadDump(message);
                    }
                    e.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }

        protected String getTraceName() {
            return "Uploading " + this.srcFileName + " to " + SftpSupport.this.execEnv + ":" + this.dstFileName;
        }
    }

    private abstract class Worker
    implements Callable<Integer> {
        protected final Writer error;

        public Worker(Writer error) {
            this.error = error;
        }

        protected abstract void work() throws JSchException, SftpException, IOException, ConnectionManager.CancellationException, InterruptedException, ExecutionException;

        protected abstract String getTraceName();

        @Override
        public Integer call() throws InterruptedException {
            int rc = -1;
            try {
                Thread.currentThread().setName("SFTP: : " + this.getTraceName());
                this.work();
                rc = 0;
            }
            catch (JSchException ex) {
                if (ex.getMessage().contains("Received message is too long: ")) {
                    if (isUnitTest) {
                        this.logException((Exception)((Object)ex));
                    } else {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SftpSupport.class, (String)"SftpConnectionReceivedMessageIsTooLong.error.text"), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                    }
                    rc = 7;
                } else {
                    this.logException((Exception)((Object)ex));
                    rc = 1;
                }
            }
            catch (SftpException ex) {
                this.logException((Exception)((Object)ex));
                rc = 2;
            }
            catch (ConnectException ex) {
                this.logException(ex);
                rc = 3;
            }
            catch (InterruptedIOException ex) {
                rc = 4;
                throw new InterruptedException(ex.getMessage());
            }
            catch (IOException ex) {
                this.logException(ex);
                rc = 5;
            }
            catch (ConnectionManager.CancellationException ex) {
                rc = 6;
            }
            catch (ExecutionException ex) {
                this.logException(ex);
                rc = 7;
            }
            LOG.log(Level.FINE, "{0}{1}", new Object[]{this.getTraceName(), rc == 0 ? " OK" : " FAILED"});
            return rc;
        }

        protected void logException(Exception ex) {
            LOG.log(Level.INFO, "Error " + this.getTraceName(), ex);
        }
    }
}

