/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.execution;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.terminal.api.IOEmulation;
import org.netbeans.modules.terminal.api.IOTerm;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NativeExecutionService {
    private final NativeProcessBuilder processBuilder;
    private final String displayName;
    private final NativeExecutionDescriptor descriptor;
    private static final Charset execCharset;
    private Runnable postExecutable;
    private final AtomicReference<NativeProcess> processRef = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ProcessChangeListener listener;
    private long startTimeMillis;

    private NativeExecutionService(NativeProcessBuilder processBuilder, String displayName, NativeExecutionDescriptor descriptor) {
        this.processBuilder = processBuilder;
        this.displayName = displayName;
        this.descriptor = descriptor;
    }

    public static NativeExecutionService newService(NativeProcessBuilder processBuilder, NativeExecutionDescriptor descriptor, String displayName) {
        return new NativeExecutionService(processBuilder, displayName, descriptor);
    }

    public Future<Integer> run() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("NativeExecutionService state error - cannot be called more than once!");
        }
        this.listener = new ProcessChangeListener();
        this.processBuilder.addNativeProcessListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this.listener, (Object)this.processBuilder));
        this.postExecutable = this.descriptor.postExecution;
        this.descriptor.postExecution(new PostRunnable());
        if (IOTerm.isSupported((InputOutput)this.descriptor.inputOutput)) {
            return this.runTerm();
        }
        return this.runRegular();
    }

    private Future<Integer> runTerm() {
        final AtomicReference<Object> runTaskRef = new AtomicReference<Object>(null);
        this.processBuilder.setUsePty(true);
        if (IOEmulation.isSupported((InputOutput)this.descriptor.inputOutput)) {
            this.processBuilder.getEnvironment().put("TERM", IOEmulation.getEmulation((InputOutput)this.descriptor.inputOutput));
        } else {
            this.processBuilder.getEnvironment().put("TERM", "dumb");
        }
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public Integer call() throws Exception {
                Throwable throwable2222222222;
                ProgressHandle progressHandle;
                block35: {
                    InputStream is;
                    NativeProcess process;
                    block32: {
                        InputStream is2;
                        progressHandle = null;
                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.showProgress) {
                            Cancellable c = null;
                            if (((NativeExecutionService)NativeExecutionService.this).descriptor.controllable) {
                                c = new Cancellable(){

                                    public boolean cancel() {
                                        FutureTask task = (FutureTask)runTaskRef.get();
                                        if (task != null) {
                                            return task.cancel(true);
                                        }
                                        return false;
                                    }
                                };
                            }
                            progressHandle = ProgressHandleFactory.createHandle((String)NativeExecutionService.this.displayName, (Cancellable)c, (Action)new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.select();
                                }
                            });
                            progressHandle.start();
                        }
                        process = NativeExecutionService.this.processBuilder.call();
                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.frontWindow) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JComponent screen;
                                    IOSelect.select((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, EnumSet.of(IOSelect.AdditionalOperation.OPEN, IOSelect.AdditionalOperation.REQUEST_ACTIVE, IOSelect.AdditionalOperation.REQUEST_VISIBLE));
                                    Term term = IOTerm.term((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput);
                                    if (term != null && (screen = term.getScreen()) != null) {
                                        screen.requestFocusInWindow();
                                    }
                                }
                            });
                        }
                        IOTerm.term((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput).setReadOnly(!((NativeExecutionService)NativeExecutionService.this).descriptor.inputVisible);
                        PtySupport.connect(((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, process);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                        if (process.getState() != NativeProcess.State.ERROR) break block32;
                        ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr().print(ProcessUtils.readProcessErrorLine(process));
                        ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr().println('\r');
                        Integer n = 1;
                        NativeProcess p = (NativeProcess)NativeExecutionService.this.processRef.get();
                        if (p != null && (is2 = p.getInputStream()) != null) {
                            try {
                                while (is2.available() != 0) {
                                }
                                is2.close();
                            }
                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                        IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, null);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                        try {
                            if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                                ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                            }
                        }
                        finally {
                            IOTerm.term((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput).setReadOnly(true);
                            ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut().close();
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                        }
                        return n;
                    }
                    Integer n = process.waitFor();
                    NativeProcess p = (NativeProcess)NativeExecutionService.this.processRef.get();
                    if (p != null && (is = p.getInputStream()) != null) {
                        try {
                            while (is.available() != 0) {
                            }
                            is.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, null);
                    SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    try {
                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                            ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                        }
                    }
                    finally {
                        IOTerm.term((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput).setReadOnly(true);
                        ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut().close();
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                    }
                    return n;
                    catch (Throwable throwable2222222222) {
                        InputStream is3;
                        NativeProcess p2 = (NativeProcess)NativeExecutionService.this.processRef.get();
                        if (p2 == null || (is3 = p2.getInputStream()) == null) break block35;
                        try {
                            while (is3.available() != 0) {
                            }
                            is3.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, null);
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                try {
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                        ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                    }
                }
                finally {
                    IOTerm.term((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput).setReadOnly(true);
                    ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut().close();
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                }
                throw throwable2222222222;
            }
        };
        FutureTask<Integer> runTask = new FutureTask<Integer>((Callable)callable){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                AtomicReference atomicReference = NativeExecutionService.this.processRef;
                synchronized (atomicReference) {
                    NativeProcess process = (NativeProcess)NativeExecutionService.this.processRef.get();
                    if (process != null) {
                        process.destroy();
                    }
                    return true;
                }
            }
        };
        runTaskRef.set(runTask);
        NativeTaskExecutorService.submit(runTask, "start process in term");
        return runTask;
    }

    private Future<Integer> runRegular() {
        Charset charset = this.descriptor.charset;
        if (charset == null) {
            charset = execCharset;
        }
        Logger.getInstance().log(Level.FINE, "Input stream charset: {0}", charset);
        ExecutionDescriptor descr = new ExecutionDescriptor().controllable(this.descriptor.controllable).frontWindow(this.descriptor.frontWindow).inputVisible(this.descriptor.inputVisible).inputOutput(this.descriptor.inputOutput).outLineBased(this.descriptor.outLineBased).showProgress(this.descriptor.showProgress).postExecution(this.descriptor.postExecution).noReset(!this.descriptor.resetInputOutputOnFinish).errConvertorFactory(this.descriptor.errConvertorFactory).outConvertorFactory(this.descriptor.outConvertorFactory).charset(charset);
        ExecutionService es = ExecutionService.newService((Callable)this.processBuilder, (ExecutionDescriptor)descr, (String)this.displayName);
        Future result = es.run();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean prevFocusTaken = ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.isFocusTaken();
                ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.setFocusTaken(true);
                IOSelect.select((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, EnumSet.of(IOSelect.AdditionalOperation.OPEN, IOSelect.AdditionalOperation.REQUEST_ACTIVE, IOSelect.AdditionalOperation.REQUEST_VISIBLE));
                ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.setFocusTaken(prevFocusTaken);
            }
        });
        return result;
    }

    private void closeIO() {
        this.descriptor.inputOutput.getErr().close();
        this.descriptor.inputOutput.getOut().close();
        try {
            this.descriptor.inputOutput.getIn().close();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String charsetName = System.getProperty("org.netbeans.modules.nativeexecution.execcharset", "UTF-8");
        Charset cs = null;
        try {
            cs = Charset.forName(charsetName);
        }
        catch (Exception ex) {
            cs = Charset.defaultCharset();
        }
        finally {
            execCharset = cs;
        }
    }

    private final class PostRunnable
    implements Runnable {
        private PostRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block13: {
                NativeProcess.State state;
                NativeProcess process = (NativeProcess)NativeExecutionService.this.processRef.get();
                if (process == null) {
                    return;
                }
                int rc = -1;
                try {
                    rc = process.waitFor();
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer == null) break block13;
                    state = process.getState();
                }
                catch (InterruptedException ex) {
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer != null) {
                        NativeProcess.State state2 = process.getState();
                        long time = System.currentTimeMillis() - NativeExecutionService.this.startTimeMillis;
                        String postMsg = ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostMessage(state2, rc, time);
                        OutputWriter pw = rc == 0 ? ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut() : ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr();
                        pw.printf("\n\r%s\n\r", postMsg);
                        StatusDisplayer.getDefault().setStatusText(((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostStatusString(state2, rc));
                    }
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.closeInputOutputOnFinish) {
                        NativeExecutionService.this.closeIO();
                    }
                    if (NativeExecutionService.this.postExecutable != null) {
                        NativeExecutionService.this.postExecutable.run();
                    }
                    catch (Throwable throwable) {
                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer != null) {
                            NativeProcess.State state3 = process.getState();
                            long time = System.currentTimeMillis() - NativeExecutionService.this.startTimeMillis;
                            String postMsg = ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostMessage(state3, rc, time);
                            OutputWriter pw = rc == 0 ? ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut() : ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr();
                            pw.printf("\n\r%s\n\r", postMsg);
                            StatusDisplayer.getDefault().setStatusText(((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostStatusString(state3, rc));
                        }
                        if (((NativeExecutionService)NativeExecutionService.this).descriptor.closeInputOutputOnFinish) {
                            NativeExecutionService.this.closeIO();
                        }
                        if (NativeExecutionService.this.postExecutable != null) {
                            NativeExecutionService.this.postExecutable.run();
                        }
                        throw throwable;
                    }
                }
                long time = System.currentTimeMillis() - NativeExecutionService.this.startTimeMillis;
                String postMsg = ((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostMessage(state, rc, time);
                OutputWriter pw = rc == 0 ? ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getOut() : ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr();
                pw.printf("\n\r%s\n\r", postMsg);
                StatusDisplayer.getDefault().setStatusText(((NativeExecutionService)NativeExecutionService.this).descriptor.postMessageDisplayer.getPostStatusString(state, rc));
            }
            if (((NativeExecutionService)NativeExecutionService.this).descriptor.closeInputOutputOnFinish) {
                NativeExecutionService.this.closeIO();
            }
            if (NativeExecutionService.this.postExecutable != null) {
                NativeExecutionService.this.postExecutable.run();
            }
        }
    }

    private final class ProcessChangeListener
    implements ChangeListener {
        private ProcessChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            NativeExecutionService.this.processRef.compareAndSet(null, (NativeProcess)event.getSource());
            switch (event.state) {
                case RUNNING: 
                case ERROR: {
                    NativeExecutionService.this.startTimeMillis = System.currentTimeMillis();
                }
            }
        }
    }
}

