/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.ara.rules;

import com.sun.enterprise.web.connector.grizzly.LinkedListPipeline;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.Rule;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadRatioRule
implements Rule<ReadTask> {
    protected static final String RESERVE = "reserve";
    protected static final String CEILING = "ceiling";
    protected static final String ALLOCATION_MODE = "com.sun.enterprise.web.ara.policyMethod";
    protected static final String RULE_TOKENS = "com.sun.enterprise.web.ara.policyMetric";
    protected static final String QUERY_STRING = "?";
    protected static final String PATH_STRING = "/";
    protected ReadTask readTask;
    protected static final ConcurrentHashMap<String, Pipeline> pipelines = new ConcurrentHashMap();
    protected static final ConcurrentHashMap<String, Double> privilegedTokens = new ConcurrentHashMap();
    protected static double leftRatio = 1.0;
    protected static String allocationPolicy = "reserve";

    @Override
    public void attach(ReadTask o) {
        this.readTask = o;
    }

    @Override
    public ReadTask attachement() {
        return this.readTask;
    }

    public Integer call() throws Exception {
        String token;
        Pipeline pipeline;
        boolean noCache = false;
        if (leftRatio == 0.0) {
            if (allocationPolicy.equals(RESERVE)) {
                return 2;
            }
            if (allocationPolicy.equals(CEILING)) {
                if (this.isPipelineInUse()) {
                    return 1;
                }
                noCache = true;
            }
        }
        if ((pipeline = pipelines.get(token = this.getContextRoot())) == null) {
            pipeline = this.applyRule(token);
            pipelines.put(token, pipeline);
        }
        this.readTask.setPipeline(pipeline);
        if (!noCache) {
            return 0;
        }
        return 3;
    }

    protected String getContextRoot() {
        boolean slash;
        ByteBuffer byteBuffer = this.readTask.getByteBuffer();
        byte[] chars = new byte[byteBuffer.limit() - byteBuffer.position()];
        byteBuffer.get(chars);
        String token = new String(chars);
        int index = token.indexOf(PATH_STRING);
        if (index != -1) {
            token = token.substring(0, index);
        }
        if ((index = token.indexOf(QUERY_STRING)) != -1) {
            token = token.substring(0, index);
        }
        if (slash = token.endsWith(PATH_STRING)) {
            token = token.substring(0, token.length() - 1);
        }
        return token;
    }

    protected Pipeline applyRule(String token) {
        Pipeline p = this.readTask.getPipeline();
        int maxThreads = p.getMaxThreads();
        Double threadRatio = privilegedTokens.get(token);
        if (threadRatio == null) {
            threadRatio = leftRatio == 0.0 ? 0.5 : leftRatio;
        }
        int privilegedCount = threadRatio == 1.0 ? maxThreads : (int)((double)maxThreads * threadRatio) + 1;
        return this.newPipeline(privilegedCount, p);
    }

    protected Pipeline newPipeline(int threadCount, Pipeline p) {
        if (threadCount == 0) {
            return null;
        }
        LinkedListPipeline pipeline = new LinkedListPipeline();
        pipeline.setMinThreads(1);
        pipeline.setMaxThreads(threadCount);
        pipeline.setName(p.getName());
        pipeline.setQueueSizeInBytes(this.readTask.getSelectorThread().getQueueSizeInBytes());
        pipeline.initPipeline();
        pipeline.startPipeline();
        return pipeline;
    }

    protected boolean isPipelineInUse() {
        Collection<Pipeline> collection = pipelines.values();
        for (Pipeline pipeline : collection) {
            if (pipeline.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cancel() {
        this.readTask = null;
    }

    @Override
    public int getExecutionTime() {
        return -1;
    }

    @Override
    public void setExecutionTime(int time) {
    }

    @Override
    public void setFuture(Future future) {
    }

    static {
        try {
            if (System.getProperty(RULE_TOKENS) != null) {
                StringTokenizer privList = new StringTokenizer(System.getProperty(RULE_TOKENS), ",");
                double countRatio = 0.0;
                while (privList.hasMoreElements()) {
                    StringTokenizer privElement = new StringTokenizer(privList.nextToken());
                    while (privElement.hasMoreElements()) {
                        String tokens = privElement.nextToken();
                        int index = tokens.indexOf("|");
                        double tokenValue = Double.valueOf(tokens.substring(index + 1));
                        privilegedTokens.put(tokens.substring(0, index), tokenValue);
                        countRatio += tokenValue;
                    }
                }
                if (countRatio > 1.0) {
                    SelectorThread.logger().log(Level.WARNING, "Thread ratio too high. The total must be lower or equal to 1");
                } else {
                    leftRatio = 1.0 - countRatio;
                }
            }
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.WARNING, "Unable to parse thread ratio", ex);
        }
        if (System.getProperty(ALLOCATION_MODE) != null && !(allocationPolicy = System.getProperty(ALLOCATION_MODE)).equals(RESERVE) && !allocationPolicy.equals(CEILING)) {
            SelectorThread.logger().log(Level.WARNING, "Invalid allocation policy");
            allocationPolicy = RESERVE;
        }
    }
}

