/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class JavaProjectSettings {
    private static final PropertyChangeSupport pcs = new PropertyChangeSupport(JavaProjectSettings.class);
    public static final String PROP_PACKAGE_VIEW_TYPE = "packageViewType";
    private static final String PROP_SHOW_AGAIN_BROKEN_REF_ALERT = "showAgainBrokenRefAlert";

    private JavaProjectSettings() {
    }

    private static Preferences prefs() {
        return NbPreferences.forModule(JavaProjectSettings.class);
    }

    public static PackageViewType getPackageViewType() {
        int type = JavaProjectSettings.prefs().getInt(PROP_PACKAGE_VIEW_TYPE, -1);
        PackageViewType[] types = PackageViewType.values();
        return type >= 0 && type < types.length ? types[type] : PackageViewType.PACKAGES;
    }

    public static void setPackageViewType(PackageViewType type) {
        PackageViewType currentType = JavaProjectSettings.getPackageViewType();
        if (currentType != type) {
            JavaProjectSettings.prefs().putInt(PROP_PACKAGE_VIEW_TYPE, type.ordinal());
            pcs.firePropertyChange(PROP_PACKAGE_VIEW_TYPE, (Object)currentType, (Object)type);
        }
    }

    public static boolean isShowAgainBrokenRefAlert() {
        return JavaProjectSettings.prefs().getBoolean(PROP_SHOW_AGAIN_BROKEN_REF_ALERT, true);
    }

    public static void setShowAgainBrokenRefAlert(boolean again) {
        JavaProjectSettings.prefs().putBoolean(PROP_SHOW_AGAIN_BROKEN_REF_ALERT, again);
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        pcs.addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        pcs.removePropertyChangeListener(l);
    }

    public static enum PackageViewType {
        PACKAGES,
        TREE,
        REDUCED_TREE;

    }
}

