/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.rules.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.filesystems.FileObject;

public class AnnotationPostContruct
extends EJBVerificationRule {
    @Override
    public Collection<ErrorDescription> check(EJBProblemContext ctx) {
        if (ctx.getEjb() instanceof Session) {
            EjbJar ejbModule = EjbJar.getEjbJar((FileObject)ctx.getFileObject());
            Profile profile = ejbModule.getJ2eeProfile();
            if (!Profile.JAVA_EE_6_FULL.equals(profile) && !Profile.JAVA_EE_6_WEB.equals(profile)) {
                return null;
            }
            List<ExecutableElement> allMethods = ElementFilter.methodsIn(ctx.getClazz().getEnclosedElements());
            LinkedList<ExecutableElement> eligibleMethods = new LinkedList<ExecutableElement>();
            LinkedList<ErrorDescription> problems = new LinkedList<ErrorDescription>();
            for (ExecutableElement method : allMethods) {
                if (!AnnotationPostContruct.isEligibleMethod(method)) continue;
                eligibleMethods.add(method);
            }
            if (eligibleMethods.size() > 1) {
                for (ExecutableElement problematicMethods : eligibleMethods) {
                    problems.add(HintsUtils.createProblem(problematicMethods, ctx.getComplilationInfo(), Bundle.AnnotationPostContruct_too_much_annotations()));
                }
            }
            for (ExecutableElement method : eligibleMethods) {
                List<? extends VariableElement> parameters;
                if (!"void".equals(((Object)method.getReturnType()).toString())) {
                    problems.add(HintsUtils.createProblem(method, ctx.getComplilationInfo(), Bundle.AnnotationPostContruct_wrong_return_type()));
                }
                if (!method.getThrownTypes().isEmpty()) {
                    problems.add(HintsUtils.createProblem(method, ctx.getComplilationInfo(), Bundle.AnnotationPostContruct_thrown_checked_exceptions()));
                }
                if ((parameters = method.getParameters()).isEmpty() || parameters.size() <= 1 && AnnotationPostContruct.isEjbInterceptor(method)) continue;
                problems.add(HintsUtils.createProblem(method, ctx.getComplilationInfo(), Bundle.AnnotationPostContruct_wrong_parameters()));
            }
            return problems;
        }
        return null;
    }

    private static boolean isEjbInterceptor(ExecutableElement method) {
        VariableElement parameter = method.getParameters().get(0);
        if ("javax.interceptor.InvocationContext".equals(((Object)parameter.asType()).toString())) {
            for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                if (!"javax.interceptor.AroundInvoke".equals(annotationMirror.getAnnotationType().asElement().toString())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEligibleMethod(ExecutableElement method) {
        boolean knownClasses = HintsUtils.isContainingKnownClasses(method);
        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
            if (!"javax.annotation.PostConstruct".equals(annotationMirror.getAnnotationType().asElement().toString()) || !knownClasses) continue;
            return true;
        }
        return false;
    }
}

