/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBRulesRegistry;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public abstract class EJBProblemFinder {
    private boolean cancelled = false;
    private FileObject file = null;
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
    public static final Logger LOG = Logger.getLogger(EJBProblemFinder.class.getName());
    private static final Object singleInstanceLock = new Object();
    private static EJBProblemFinder runningInstance = null;

    public EJBProblemFinder(FileObject file) {
        assert (file != null);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final CompilationInfo info) throws Exception {
        if (!"text/x-java".equals(this.file.getMIMEType(new String[]{"text/x-java"}))) {
            return;
        }
        if (runningInstance != null) {
            runningInstance.cancel();
        }
        Object object = singleInstanceLock;
        synchronized (object) {
            runningInstance = this;
            this.cancelled = false;
            this.problemsFound.clear();
            Project prj = FileOwnerQuery.getOwner((FileObject)this.file);
            if (prj == null) {
                return;
            }
            J2eeProjectCapabilities projCap = J2eeProjectCapabilities.forProject((Project)prj);
            if (projCap == null || !projCap.isEjb30Supported() && !projCap.isEjb31LiteSupported()) {
                return;
            }
            EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.file);
            if (ejbModule == null) {
                return;
            }
            ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata metadata) {
                    String ejbVersion = metadata.getRoot().getVersion().toString();
                    if (!"3.0".equals(ejbVersion) && !"3.1".equals(ejbVersion)) {
                        return null;
                    }
                    for (Tree tree : info.getCompilationUnit().getTypeDecls()) {
                        if (EJBProblemFinder.this.isCancelled()) break;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                        long startTime = Calendar.getInstance().getTimeInMillis();
                        TreePath path = info.getTrees().getPath(info.getCompilationUnit(), tree);
                        TypeElement javaClass = (TypeElement)info.getTrees().getElement(path);
                        Ejb ejb = metadata.findByEjbClass(javaClass.getQualifiedName().toString());
                        EJBProblemContext ctx = new EJBProblemContext(info, EJBProblemFinder.this.file, javaClass, ejb, metadata);
                        EJBProblemFinder.this.problemsFound.addAll(EJBRulesRegistry.check(ctx));
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        long timeElapsed = Calendar.getInstance().getTimeInMillis() - startTime;
                        LOG.log(Level.FINE, "processed class {0} in {1} ms", new Object[]{javaClass.getSimpleName(), timeElapsed});
                    }
                    return null;
                }
            });
            HintsController.setErrors((FileObject)this.file, (String)"EJB Verification", this.problemsFound);
            runningInstance = null;
        }
    }

    public void cancel() {
        LOG.fine("Cancelling EJBProblemFinder task");
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<? extends ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    public static class ProblemFinderCompControl
    extends EJBProblemFinder
    implements CancellableTask<CompilationController> {
        public ProblemFinderCompControl(FileObject file) {
            super(file);
        }

        public void run(CompilationController controller) throws Exception {
            controller.toPhase(JavaSource.Phase.RESOLVED);
            super.run((CompilationInfo)controller);
        }
    }

    public static class ProblemFinderCompInfo
    extends EJBProblemFinder
    implements CancellableTask<CompilationInfo> {
        public ProblemFinderCompInfo(FileObject file) {
            super(file);
        }
    }
}

