/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.util.Collection;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.api.NBBugzillaUtils;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.openide.util.NbBundle;

public class NBRepositorySupport
extends BugzillaRepository {
    private static final String NB_BUGZILLA_HOST = "netbeans.org";
    public static final String NB_BUGZILLA_URL = "https://netbeans.org/bugzilla";
    public static final String URL_NB_ORG_SIGNUP = "https://netbeans.org/people/new";
    private static NBRepositorySupport instance;
    private BugzillaRepository bugzillaRepository;
    private Repository nbRepository;
    private boolean isKenai;

    private NBRepositorySupport() {
    }

    public static synchronized NBRepositorySupport getInstance() {
        if (instance == null) {
            instance = new NBRepositorySupport();
        }
        return instance;
    }

    public Repository getNBRepository() {
        if (this.nbRepository != null) {
            if (!this.isKenai) {
                Collection repos = RepositoryManager.getInstance().getRepositories("org.netbeans.modules.bugzilla");
                boolean registered = false;
                for (Repository repo : repos) {
                    if (!BugtrackingUtil.isNbRepository((String)repo.getUrl())) continue;
                    registered = true;
                    break;
                }
                if (!registered) {
                    KenaiUtil.addRepository((Repository)this.nbRepository);
                }
            }
            return this.nbRepository;
        }
        Collection repos = RepositoryManager.getInstance().getRepositories("org.netbeans.modules.bugzilla");
        for (Repository repo : repos) {
            if (!BugtrackingUtil.isNbRepository((String)repo.getUrl())) continue;
            this.nbRepository = repo;
            return repo;
        }
        if (KenaiUtil.isNetbeansKenaiRegistered()) {
            this.isKenai = true;
            this.nbRepository = this.createRepositoryIntern();
        }
        if (this.nbRepository == null) {
            this.nbRepository = this.createRepositoryIntern();
            KenaiUtil.addRepository((Repository)this.nbRepository);
        }
        return this.nbRepository;
    }

    public void setNBBugzillaRepository(BugzillaRepository repo) {
        this.bugzillaRepository = repo;
    }

    public BugzillaRepository getNBBugzillaRepository() {
        if (this.bugzillaRepository == null) {
            this.getNBRepository();
        }
        return this.bugzillaRepository;
    }

    private Repository createRepositoryIntern() {
        char[] password = NBBugzillaUtils.getNBPassword();
        String username = NBBugzillaUtils.getNBUsername();
        String name = NbBundle.getMessage(NBRepositorySupport.class, (String)"LBL_NBRepository");
        RepositoryInfo info = new RepositoryInfo("NetbeansRepository" + System.currentTimeMillis(), "org.netbeans.modules.bugzilla", NB_BUGZILLA_URL, NbBundle.getMessage(NBRepositorySupport.class, (String)"LBL_NBRepository"), NbBundle.getMessage(NBRepositorySupport.class, (String)"LBL_RepositoryTooltip", (Object[])new Object[]{name, username, NB_BUGZILLA_URL}), username, null, password, null);
        this.bugzillaRepository = new BugzillaRepository(info);
        return BugzillaUtil.getRepository(this.bugzillaRepository);
    }
}

