/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.repository;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.kenai.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.BugzillaExecutor;
import org.netbeans.modules.bugzilla.commands.GetMultiTaskDataCommand;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaTaskListProvider;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.query.QueryParameter;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepositoryController;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.bugzilla.util.MylynUtils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class BugzillaRepository {
    private static final String ICON_PATH = "org/netbeans/modules/bugtracking/ui/resources/repository.png";
    private RepositoryInfo info;
    private TaskRepository taskRepository;
    private BugzillaRepositoryController controller;
    private Set<BugzillaQuery> queries = null;
    private IssueCache<BugzillaIssue, TaskData> cache;
    private BugzillaExecutor executor;
    private Image icon;
    private BugzillaConfiguration bc;
    private RequestProcessor refreshProcessor;
    private final Set<String> issuesToRefresh = new HashSet<String>(5);
    private final Set<BugzillaQuery> queriesToRefresh = new HashSet<BugzillaQuery>(3);
    private RequestProcessor.Task refreshIssuesTask;
    private RequestProcessor.Task refreshQueryTask;
    private Lookup lookup;

    public BugzillaRepository() {
        this.icon = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
    }

    public BugzillaRepository(RepositoryInfo info) {
        this();
        char[] httpPassword;
        String httpUser;
        char[] password;
        this.info = info;
        String name = info.getDisplayName();
        String user = info.getUsername();
        if (user == null) {
            user = "";
        }
        if ((password = info.getPassword()) == null) {
            password = new char[]{};
        }
        if ((httpUser = info.getHttpUsername()) == null) {
            httpUser = "";
        }
        if ((httpPassword = info.getHttpPassword()) == null) {
            httpPassword = new char[]{};
        }
        String url = info.getUrl();
        boolean shortLoginEnabled = Boolean.parseBoolean(info.getValue("bugzilla.shortLoginEnabled"));
        this.taskRepository = BugzillaRepository.createTaskRepository(name, url, user, password, httpUser, httpPassword, shortLoginEnabled);
        BugzillaTaskListProvider.getInstance().notifyRepositoryCreated(this);
    }

    public RepositoryInfo getInfo() {
        return this.info;
    }

    public String getID() {
        return this.info.getId();
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public BugzillaQuery createQuery() {
        BugzillaConfiguration conf = this.getConfiguration();
        if (conf == null || !conf.isValid()) {
            return null;
        }
        BugzillaQuery q = new BugzillaQuery(this);
        return q;
    }

    public BugzillaIssue createIssue() {
        BugzillaConfiguration conf = this.getConfiguration();
        if (conf == null || !conf.isValid()) {
            return null;
        }
        TaskAttributeMapper attributeMapper = Bugzilla.getInstance().getRepositoryConnector().getTaskDataHandler().getAttributeMapper(this.taskRepository);
        TaskData data = new TaskData(attributeMapper, this.taskRepository.getConnectorKind(), this.taskRepository.getRepositoryUrl(), "");
        return new BugzillaIssue(data, this);
    }

    public void remove() {
        BugzillaQuery[] toRemove;
        Collection<BugzillaQuery> qs = this.getQueries();
        for (BugzillaQuery q : toRemove = qs.toArray(new BugzillaQuery[qs.size()])) {
            this.removeQuery(q);
        }
        this.resetRepository(true);
        BugzillaTaskListProvider.getInstance().notifyRepositoryRemoved(this);
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookups.fixed((Object[])this.getLookupObjects());
        }
        return this.lookup;
    }

    protected Object[] getLookupObjects() {
        return new Object[]{this.getIssueCache()};
    }

    synchronized void resetRepository(boolean keepConfiguration) {
        if (!keepConfiguration) {
            this.bc = null;
        }
        if (this.getTaskRepository() != null) {
            Bugzilla.getInstance().getRepositoryConnector().getClientManager().repositoryRemoved(this.getTaskRepository());
        }
    }

    synchronized void setInfoValues(String name, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean localUserEnabled) {
        this.setTaskRepository(name, url, user, password, httpUser, httpPassword, localUserEnabled);
        String id = this.info != null ? this.info.getId() : name + System.currentTimeMillis();
        this.info = new RepositoryInfo(id, "org.netbeans.modules.bugzilla", url, name, this.getTooltip(name, user, url), user, httpUser, password, httpPassword);
    }

    public String getDisplayName() {
        return this.info.getDisplayName();
    }

    private String getTooltip(String repoName, String user, String url) {
        return NbBundle.getMessage(BugzillaRepository.class, (String)"LBL_RepositoryTooltip", (Object[])new Object[]{repoName, user, url});
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getUsername() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return c != null ? c.getUserName() : "";
    }

    public char[] getPassword() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.REPOSITORY);
        return c != null ? c.getPassword().toCharArray() : new char[]{};
    }

    public String getHttpUsername() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return c != null ? c.getUserName() : "";
    }

    public char[] getHttpPassword() {
        AuthenticationCredentials c = this.getTaskRepository().getCredentials(AuthenticationType.HTTP);
        return c != null ? c.getPassword().toCharArray() : new char[]{};
    }

    public BugzillaIssue[] getIssues(String ... ids) {
        final LinkedList ret = new LinkedList();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                String id = BugzillaIssue.getID(taskData);
                try {
                    BugzillaIssue issue = (BugzillaIssue)BugzillaRepository.this.getIssueCache().setIssueData(id, (Object)taskData);
                    if (issue != null) {
                        ret.add(issue);
                    }
                }
                catch (IOException ex) {
                    Bugzilla.LOG.log(Level.SEVERE, null, ex);
                }
            }
        };
        GetMultiTaskDataCommand dataCmd = new GetMultiTaskDataCommand(this, new HashSet<String>(Arrays.asList(ids)), collector);
        this.getExecutor().execute(dataCmd, true);
        return ret.toArray(new BugzillaIssue[ret.size()]);
    }

    public BugzillaIssue getIssue(String id) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        TaskData taskData = BugzillaUtil.getTaskData(this, id);
        if (taskData == null) {
            return null;
        }
        try {
            BugzillaIssue issue = (BugzillaIssue)this.getIssueCache().setIssueData(id, (Object)taskData);
            this.ensureConfigurationUptodate(issue);
            return issue;
        }
        catch (IOException ex) {
            Bugzilla.LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Collection<BugzillaIssue> simpleSearch(String criteria) {
        QueryParameter[] additionalParams;
        TaskData taskData;
        assert (this.taskRepository != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        String[] keywords = criteria.split(" ");
        final ArrayList<BugzillaIssue> issues = new ArrayList<BugzillaIssue>();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                BugzillaIssue issue = new BugzillaIssue(taskData, BugzillaRepository.this);
                issues.add(issue);
            }
        };
        if (keywords.length == 1 && this.isInteger(keywords[0]) && (taskData = BugzillaUtil.getTaskData(this, keywords[0], false)) != null) {
            BugzillaIssue issue = new BugzillaIssue(taskData, this);
            issues.add(issue);
        }
        StringBuffer url = new StringBuffer();
        url.append("/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=");
        for (int i = 0; i < keywords.length; ++i) {
            String val = keywords[i].trim();
            if (val.equals("")) continue;
            try {
                val = URLEncoder.encode(val, this.getTaskRepository().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException ueex) {
                Bugzilla.LOG.log(Level.INFO, null, ueex);
                try {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            url.append(val);
            if (i >= keywords.length - 1) continue;
            url.append("+");
        }
        for (QueryParameter qp : additionalParams = this.getSimpleSearchParameters()) {
            url.append(qp.get(true));
        }
        PerformQueryCommand queryCmd = new PerformQueryCommand(this, url.toString(), collector);
        this.getExecutor().execute(queryCmd);
        if (queryCmd.hasFailed()) {
            return Collections.emptyList();
        }
        return issues;
    }

    public RepositoryController getController() {
        if (this.controller == null) {
            this.controller = new BugzillaRepositoryController(this);
        }
        return this.controller;
    }

    public Collection<BugzillaQuery> getQueries() {
        return this.getQueriesIntern();
    }

    public IssueCache<BugzillaIssue, TaskData> getIssueCache() {
        if (this.cache == null) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public void removeQuery(BugzillaQuery query) {
        BugzillaConfig.getInstance().removeQuery(this, query);
        this.getIssueCache().removeQuery(query.getStoredQueryName());
        this.getQueriesIntern().remove(query);
        this.stopRefreshing(query);
    }

    public void saveQuery(BugzillaQuery query) {
        assert (this.info != null);
        BugzillaConfig.getInstance().putQuery(this, query);
        this.getQueriesIntern().add(query);
    }

    private Set<BugzillaQuery> getQueriesIntern() {
        if (this.queries == null) {
            String[] qs;
            this.queries = new HashSet<BugzillaQuery>(10);
            for (String queryName : qs = BugzillaConfig.getInstance().getQueries(this.getID())) {
                BugzillaQuery q = BugzillaConfig.getInstance().getQuery(this, queryName);
                if (q != null) {
                    this.queries.add(q);
                    continue;
                }
                Bugzilla.LOG.warning("Couldn't find query with stored name " + queryName);
            }
        }
        return this.queries;
    }

    public void ensureCredentials() {
        this.setCredentials(this.info.getUsername(), this.info.getPassword(), this.info.getHttpUsername(), this.info.getHttpPassword(), true);
    }

    public void setCredentials(String user, char[] password, String httpUser, char[] httpPassword) {
        this.setCredentials(user, password, httpUser, httpPassword, false);
    }

    private void setCredentials(String user, char[] password, String httpUser, char[] httpPassword, boolean keepConfiguration) {
        MylynUtils.setCredentials(this.taskRepository, user, password, httpUser, httpPassword);
        this.resetRepository(keepConfiguration);
    }

    protected void setTaskRepository(String name, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean shortLoginEnabled) {
        String oldUrl = this.taskRepository != null ? this.taskRepository.getUrl() : "";
        AuthenticationCredentials c = this.taskRepository != null ? this.taskRepository.getCredentials(AuthenticationType.REPOSITORY) : null;
        String oldUser = c != null ? c.getUserName() : "";
        String oldPassword = c != null ? c.getPassword() : "";
        this.taskRepository = BugzillaRepository.createTaskRepository(name, url, user, password, httpUser, httpPassword, shortLoginEnabled);
        this.resetRepository(oldUrl.equals(url) && oldUser.equals(user) && oldPassword.equals(new String(password)));
    }

    static TaskRepository createTaskRepository(String name, String url, String user, char[] password, String httpUser, char[] httpPassword, boolean shortLoginEnabled) {
        TaskRepository repository = MylynUtils.createTaskRepository(Bugzilla.getInstance().getRepositoryConnector().getConnectorKind(), name, url, user, password, httpUser, httpPassword);
        repository.setProperty("bugzilla.shortLoginEnabled", shortLoginEnabled ? "true" : "false");
        return repository;
    }

    public String getUrl() {
        return this.taskRepository != null ? this.taskRepository.getUrl() : null;
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public BugzillaExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new BugzillaExecutor(this);
        }
        return this.executor;
    }

    public boolean authenticate(String errroMsg) {
        return BugtrackingUtil.editRepository((Repository)BugzillaUtil.getRepository(this), (String)errroMsg);
    }

    public boolean isShortUsernamesEnabled() {
        return this.taskRepository != null && "true".equals(this.taskRepository.getProperty("bugzilla.shortLoginEnabled"));
    }

    public Collection<RepositoryUser> getUsers() {
        return Collections.emptyList();
    }

    public OwnerInfo getOwnerInfo(Node[] nodes) {
        OwnerInfo ownerInfo;
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        if (BugzillaUtil.isNbRepository(this) && nodes != null && nodes.length > 0 && (ownerInfo = KenaiUtil.getOwnerInfo((Node)nodes[0])) != null) {
            return ownerInfo;
        }
        return null;
    }

    public synchronized BugzillaConfiguration getConfiguration() {
        if (this.bc == null) {
            this.bc = this.createConfiguration(false);
        } else if (!this.bc.isValid()) {
            this.bc = this.createConfiguration(false);
        }
        return this.bc;
    }

    public synchronized void refreshConfiguration() {
        BugzillaConfiguration conf = this.createConfiguration(true);
        if (conf.isValid()) {
            this.bc = conf;
        }
    }

    protected BugzillaConfiguration createConfiguration(boolean forceRefresh) {
        BugzillaConfiguration conf = new BugzillaConfiguration();
        conf.initialize(this, forceRefresh);
        return conf;
    }

    private void setupIssueRefreshTask() {
        if (this.refreshIssuesTask == null) {
            this.refreshIssuesTask = this.getRefreshProcessor().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet<String> ids;
                    Set set = BugzillaRepository.this.issuesToRefresh;
                    synchronized (set) {
                        ids = new HashSet<String>(BugzillaRepository.this.issuesToRefresh);
                    }
                    if (ids.size() == 0) {
                        Bugzilla.LOG.log(Level.FINE, "no issues to refresh {0}", new Object[]{BugzillaRepository.this.getDisplayName()});
                        return;
                    }
                    Bugzilla.LOG.log(Level.FINER, "preparing to refresh issue {0} - {1}", new Object[]{BugzillaRepository.this.getDisplayName(), ids});
                    GetMultiTaskDataCommand cmd = new GetMultiTaskDataCommand(BugzillaRepository.this, ids, new IssuesCollector());
                    BugzillaRepository.this.getExecutor().execute(cmd, false);
                    BugzillaRepository.this.scheduleIssueRefresh();
                }
            });
            this.scheduleIssueRefresh();
        }
    }

    private void setupQueryRefreshTask() {
        if (this.refreshQueryTask == null) {
            this.refreshQueryTask = this.getRefreshProcessor().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        HashSet queries;
                        RequestProcessor.Task task = BugzillaRepository.this.refreshQueryTask;
                        synchronized (task) {
                            queries = new HashSet(BugzillaRepository.this.queriesToRefresh);
                        }
                        if (queries.size() == 0) {
                            Bugzilla.LOG.log(Level.FINE, "no queries to refresh {0}", new Object[]{BugzillaRepository.this.getDisplayName()});
                            return;
                        }
                        for (BugzillaQuery q : queries) {
                            Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{q.getDisplayName(), BugzillaRepository.this.getDisplayName()});
                            QueryController qc = q.getController();
                            qc.autoRefresh();
                        }
                    }
                    finally {
                        BugzillaRepository.this.scheduleQueryRefresh();
                    }
                }
            });
            this.scheduleQueryRefresh();
        }
    }

    private void scheduleIssueRefresh() {
        int delay = BugzillaConfig.getInstance().getIssueRefreshInterval();
        Bugzilla.LOG.log(Level.FINE, "scheduling issue refresh for repository {0} in {1} minute(s)", new Object[]{this.getDisplayName(), delay});
        if (delay < 5 && System.getProperty("netbeans.t9y.bugzilla.force.refresh.delay") == null) {
            Bugzilla.LOG.log(Level.WARNING, " wrong issue refresh delay {0}. Falling back to default {0}", new Object[]{delay, 15});
            delay = 15;
        }
        this.refreshIssuesTask.schedule(delay * 60 * 1000);
    }

    private void scheduleQueryRefresh() {
        String schedule = System.getProperty("netbeans.t9y.bugzilla.force.refresh.schedule", "");
        if (!schedule.isEmpty()) {
            int delay = Integer.parseInt(schedule);
            this.refreshQueryTask.schedule(delay);
            return;
        }
        int delay = BugzillaConfig.getInstance().getQueryRefreshInterval();
        Bugzilla.LOG.log(Level.FINE, "scheduling query refresh for repository {0} in {1} minute(s)", new Object[]{this.getDisplayName(), delay});
        if (delay < 5) {
            Bugzilla.LOG.log(Level.WARNING, " wrong query refresh delay {0}. Falling back to default {0}", new Object[]{delay, 30});
            delay = 30;
        }
        this.refreshQueryTask.schedule(delay * 60 * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRefresh(String id) {
        Bugzilla.LOG.log(Level.FINE, "scheduling issue {0} for refresh on repository {0}", new Object[]{id, this.getDisplayName()});
        Set<String> set = this.issuesToRefresh;
        synchronized (set) {
            this.issuesToRefresh.add(id);
        }
        this.setupIssueRefreshTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRefreshing(String id) {
        Bugzilla.LOG.log(Level.FINE, "removing issue {0} from refresh on repository {1}", new Object[]{id, this.getDisplayName()});
        Set<String> set = this.issuesToRefresh;
        synchronized (set) {
            this.issuesToRefresh.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRefresh(BugzillaQuery query) {
        Bugzilla.LOG.log(Level.FINE, "scheduling query {0} for refresh on repository {1}", new Object[]{query.getDisplayName(), this.getDisplayName()});
        Set<BugzillaQuery> set = this.queriesToRefresh;
        synchronized (set) {
            this.queriesToRefresh.add(query);
        }
        this.setupQueryRefreshTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRefreshing(BugzillaQuery query) {
        Bugzilla.LOG.log(Level.FINE, "removing query {0} from refresh on repository {1}", new Object[]{query.getDisplayName(), this.getDisplayName()});
        Set<BugzillaQuery> set = this.queriesToRefresh;
        synchronized (set) {
            this.queriesToRefresh.remove(query);
        }
    }

    public void refreshAllQueries() {
        this.refreshAllQueries(true);
    }

    protected void refreshAllQueries(final boolean onlyOpened) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Collection<BugzillaQuery> qs = BugzillaRepository.this.getQueries();
                for (BugzillaQuery q : qs) {
                    if (!onlyOpened || !Bugzilla.getInstance().getBugtrackingFactory().isOpen(BugzillaUtil.getRepository(BugzillaRepository.this), (Object)q)) continue;
                    Bugzilla.LOG.log(Level.FINER, "preparing to refresh query {0} - {1}", new Object[]{q.getDisplayName(), BugzillaRepository.this.getDisplayName()});
                    QueryController qc = q.getController();
                    qc.onRefresh();
                }
            }
        });
    }

    public void ensureConfigurationUptodate(BugzillaIssue issue) {
        BugzillaConfiguration conf = this.getConfiguration();
        String product = issue.getFieldValue(IssueField.PRODUCT);
        String resolution = issue.getFieldValue(IssueField.RESOLUTION);
        String severity = issue.getFieldValue(IssueField.SEVERITY);
        String milestone = issue.getFieldValue(IssueField.MILESTONE);
        String version = issue.getFieldValue(IssueField.VERSION);
        String priority = issue.getFieldValue(IssueField.PRIORITY);
        String platform = issue.getFieldValue(IssueField.PLATFORM);
        String status = issue.getFieldValue(IssueField.STATUS);
        String os = issue.getFieldValue(IssueField.OS);
        String component = issue.getFieldValue(IssueField.COMPONENT);
        if (!component.isEmpty() && !conf.getComponents(product).contains(component) || !os.isEmpty() && !conf.getOSs().contains(os) || !status.isEmpty() && !conf.getStatusValues().contains(status) || !platform.isEmpty() && !conf.getPlatforms().contains(platform) || !priority.isEmpty() && !conf.getPriorities().contains(priority) || !product.isEmpty() && !conf.getProducts().contains(product) || !resolution.isEmpty() && !conf.getResolutions().contains(resolution) || !severity.isEmpty() && !conf.getSeverities().contains(severity) || !milestone.isEmpty() && !conf.getTargetMilestones(product).contains(milestone) || !version.isEmpty() && !conf.getVersions(product).contains(version)) {
            this.refreshConfiguration();
        }
    }

    private RequestProcessor getRefreshProcessor() {
        if (this.refreshProcessor == null) {
            this.refreshProcessor = new RequestProcessor("Bugzilla refresh - " + this.getDisplayName());
        }
        return this.refreshProcessor;
    }

    public String toString() {
        return super.toString() + " (" + this.getDisplayName() + ')';
    }

    protected QueryParameter[] getSimpleSearchParameters() {
        return new QueryParameter[0];
    }

    private class Cache
    extends IssueCache<BugzillaIssue, TaskData> {
        Cache() {
            super(BugzillaRepository.this.getUrl(), (IssueCache.IssueAccessor)new IssueAccessorImpl(), (IssueProvider)Bugzilla.getInstance().getIssueProvider(), BugzillaUtil.getRepository(BugzillaRepository.this));
        }
    }

    private class IssueAccessorImpl
    implements IssueCache.IssueAccessor<BugzillaIssue, TaskData> {
        private IssueAccessorImpl() {
        }

        public BugzillaIssue createIssue(TaskData taskData) {
            BugzillaIssue issue = new BugzillaIssue(taskData, BugzillaRepository.this);
            BugzillaTaskListProvider.getInstance().notifyIssueCreated(issue);
            return issue;
        }

        public void setIssueData(BugzillaIssue issue, TaskData taskData) {
            assert (issue != null && taskData != null);
            issue.setTaskData(taskData);
        }

        public String getRecentChanges(BugzillaIssue issue) {
            assert (issue != null);
            return issue.getRecentChanges();
        }

        public long getLastModified(BugzillaIssue issue) {
            assert (issue != null);
            return issue.getLastModify();
        }

        public long getCreated(BugzillaIssue issue) {
            assert (issue != null);
            return issue.getCreated();
        }

        public String getID(TaskData issueData) {
            assert (issueData != null);
            return BugzillaIssue.getID(issueData);
        }

        public Map<String, String> getAttributes(BugzillaIssue issue) {
            assert (issue != null);
            return issue.getAttributes();
        }
    }

    private class IssuesCollector
    extends TaskDataCollector {
        private IssuesCollector() {
        }

        public void accept(TaskData taskData) {
            String id = BugzillaIssue.getID(taskData);
            Bugzilla.LOG.log(Level.FINE, "refreshed issue {0} - {1}", new Object[]{BugzillaRepository.this.getDisplayName(), id});
            try {
                BugzillaRepository.this.getIssueCache().setIssueData(id, (Object)taskData);
            }
            catch (IOException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
                return;
            }
        }
    }
}

